@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dcdn.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getDomains.
 * @property changeEndTime
 * @property changeStartTime
 * @property checkDomainShow
 * @property domainSearchType
 * @property domains A list of domains. Each element contains the following attributes:
 * @property enableDetails
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids A list ids of DCDN Domain.
 * @property nameRegex
 * @property names A list of DCDN Domain names.
 * @property outputFile
 * @property resourceGroupId The ID of the resource group.
 * @property securityToken
 * @property status The status of DCDN Domain. Valid values: `online`, `offline`, `check_failed`, `checking`, `configure_failed`, `configuring`.
 */
public data class GetDomainsResult(
    public val changeEndTime: String? = null,
    public val changeStartTime: String? = null,
    public val checkDomainShow: Boolean? = null,
    public val domainSearchType: String? = null,
    public val domains: List<GetDomainsDomain>,
    public val enableDetails: Boolean? = null,
    public val id: String,
    public val ids: List<String>,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
    public val resourceGroupId: String? = null,
    public val securityToken: String? = null,
    public val status: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.dcdn.outputs.GetDomainsResult): GetDomainsResult = GetDomainsResult(
            changeEndTime = javaType.changeEndTime().map({ args0 -> args0 }).orElse(null),
            changeStartTime = javaType.changeStartTime().map({ args0 -> args0 }).orElse(null),
            checkDomainShow = javaType.checkDomainShow().map({ args0 -> args0 }).orElse(null),
            domainSearchType = javaType.domainSearchType().map({ args0 -> args0 }).orElse(null),
            domains = javaType.domains().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.dcdn.kotlin.outputs.GetDomainsDomain.Companion.toKotlin(args0)
                })
            }),
            enableDetails = javaType.enableDetails().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            resourceGroupId = javaType.resourceGroupId().map({ args0 -> args0 }).orElse(null),
            securityToken = javaType.securityToken().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
        )
    }
}
