@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dcdn.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property certName CertName.
 * @property cname The CNAME assigned to the domain name.
 * @property createTime The time when the accelerated domain name was created.
 * @property description The description.
 * @property domainName The accelerated domain names.
 * @property id The ID of the Ipa Domain.
 * @property resourceGroupId The ID of the resource group.
 * @property scope The accelerated region.
 * @property sources The information about the origin server.
 * @property sslProtocol Indicates whether the Security Socket Layer (SSL) certificate is enabled.
 * @property sslPub Indicates the public key of the certificate if the HTTPS protocol is enabled.
 * @property status The status of the accelerated domain name.
 */
public data class GetIpaDomainsDomain(
    public val certName: String,
    public val cname: String,
    public val createTime: String,
    public val description: String,
    public val domainName: String,
    public val id: String,
    public val resourceGroupId: String,
    public val scope: String,
    public val sources: List<GetIpaDomainsDomainSource>,
    public val sslProtocol: String,
    public val sslPub: String,
    public val status: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.dcdn.outputs.GetIpaDomainsDomain): GetIpaDomainsDomain = GetIpaDomainsDomain(
            certName = javaType.certName(),
            cname = javaType.cname(),
            createTime = javaType.createTime(),
            description = javaType.description(),
            domainName = javaType.domainName(),
            id = javaType.id(),
            resourceGroupId = javaType.resourceGroupId(),
            scope = javaType.scope(),
            sources = javaType.sources().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.dcdn.kotlin.outputs.GetIpaDomainsDomainSource.Companion.toKotlin(args0)
                })
            }),
            sslProtocol = javaType.sslProtocol(),
            sslPub = javaType.sslPub(),
            status = javaType.status(),
        )
    }
}
