@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dcdn.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property content The address of the origin server.
 * @property port The custom port.
 * @property priority The priority of the origin server if multiple origin servers are specified.
 * @property type The type of the origin server.
 * @property weight The weight of the origin server if multiple origin servers are specified.
 */
public data class GetIpaDomainsDomainSource(
    public val content: String,
    public val port: Int,
    public val priority: String,
    public val type: String,
    public val weight: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.dcdn.outputs.GetIpaDomainsDomainSource): GetIpaDomainsDomainSource = GetIpaDomainsDomainSource(
            content = javaType.content(),
            port = javaType.port(),
            priority = javaType.priority(),
            type = javaType.type(),
            weight = javaType.weight(),
        )
    }
}
