@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dcdn.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getIpaDomains.
 * @property domainName
 * @property domains
 * @property enableDetails
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property names
 * @property outputFile
 * @property status
 */
public data class GetIpaDomainsResult(
    public val domainName: String? = null,
    public val domains: List<GetIpaDomainsDomain>,
    public val enableDetails: Boolean? = null,
    public val id: String,
    public val ids: List<String>,
    public val names: List<String>,
    public val outputFile: String? = null,
    public val status: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.dcdn.outputs.GetIpaDomainsResult): GetIpaDomainsResult = GetIpaDomainsResult(
            domainName = javaType.domainName().map({ args0 -> args0 }).orElse(null),
            domains = javaType.domains().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.dcdn.kotlin.outputs.GetIpaDomainsDomain.Companion.toKotlin(args0)
                })
            }),
            enableDetails = javaType.enableDetails().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            names = javaType.names().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
        )
    }
}
