@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dcdn.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property clientIpTag The client ip tag.
 * @property defenseScenes Protection policy type.
 * @property domainName The accelerated domain name.
 * @property id The ID of the Waf Domain.
 */
public data class GetWafDomainsDomain(
    public val clientIpTag: String,
    public val defenseScenes: List<GetWafDomainsDomainDefenseScene>,
    public val domainName: String,
    public val id: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.dcdn.outputs.GetWafDomainsDomain): GetWafDomainsDomain = GetWafDomainsDomain(
            clientIpTag = javaType.clientIpTag(),
            defenseScenes = javaType.defenseScenes().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.dcdn.kotlin.outputs.GetWafDomainsDomainDefenseScene.Companion.toKotlin(args0)
                })
            }),
            domainName = javaType.domainName(),
            id = javaType.id(),
        )
    }
}
