@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dcdn.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getWafDomains.
 * @property domains
 * @property enableDetails
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property outputFile
 * @property queryArgs
 */
public data class GetWafDomainsResult(
    public val domains: List<GetWafDomainsDomain>,
    public val enableDetails: Boolean? = null,
    public val id: String,
    public val ids: List<String>,
    public val outputFile: String? = null,
    public val queryArgs: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.dcdn.outputs.GetWafDomainsResult): GetWafDomainsResult = GetWafDomainsResult(
            domains = javaType.domains().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.dcdn.kotlin.outputs.GetWafDomainsDomain.Companion.toKotlin(args0)
                })
            }),
            enableDetails = javaType.enableDetails().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            queryArgs = javaType.queryArgs().map({ args0 -> args0 }).orElse(null),
        )
    }
}
