@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dcdn.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property dcdnWafPolicyId The first ID of the resource.
 * @property defenseScene The type of protection policy.
 * @property domainCount The number of domain names that use this protection policy.
 * @property gmtModified The time when the protection policy was modified.
 * @property id The ID of the Waf Policy.
 * @property policyName The name of the protection policy.
 * @property policyType The type of the protection policy.
 * @property ruleCount The number of protection rules in this protection policy.
 * @property status The status of the resource.
 */
public data class GetWafPoliciesPolicy(
    public val dcdnWafPolicyId: String,
    public val defenseScene: String,
    public val domainCount: Int,
    public val gmtModified: String,
    public val id: String,
    public val policyName: String,
    public val policyType: String,
    public val ruleCount: String,
    public val status: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.dcdn.outputs.GetWafPoliciesPolicy): GetWafPoliciesPolicy = GetWafPoliciesPolicy(
            dcdnWafPolicyId = javaType.dcdnWafPolicyId(),
            defenseScene = javaType.defenseScene(),
            domainCount = javaType.domainCount(),
            gmtModified = javaType.gmtModified(),
            id = javaType.id(),
            policyName = javaType.policyName(),
            policyType = javaType.policyType(),
            ruleCount = javaType.ruleCount(),
            status = javaType.status(),
        )
    }
}
