@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dcdn.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getWafRules.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property outputFile
 * @property pageNumber
 * @property pageSize
 * @property queryArgs
 * @property wafRules A list of Waf Rule Entries. Each element contains the following attributes:
 */
public data class GetWafRulesResult(
    public val id: String,
    public val ids: List<String>,
    public val outputFile: String? = null,
    public val pageNumber: Int? = null,
    public val pageSize: Int? = null,
    public val queryArgs: String? = null,
    public val wafRules: List<GetWafRulesWafRule>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.dcdn.outputs.GetWafRulesResult): GetWafRulesResult = GetWafRulesResult(
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            pageNumber = javaType.pageNumber().map({ args0 -> args0 }).orElse(null),
            pageSize = javaType.pageSize().map({ args0 -> args0 }).orElse(null),
            queryArgs = javaType.queryArgs().map({ args0 -> args0 }).orElse(null),
            wafRules = javaType.wafRules().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.dcdn.kotlin.outputs.GetWafRulesWafRule.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
