@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dcdn.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property action Specifies the action of the rule.
 * @property ccStatus Whether to turn on Frequency Control, on/off
 * @property cnRegionList The blocked regions in the Chinese mainland, separated by commas (,).
 * @property conditions The trigger condition of the rule.
 * @property defenseScene The type of protection policy. The following scenarios are supported:-waf_group:Web basic protection-custom_acl: Custom protection policy-whitelist: whitelist
 * @property effect The effective range of the frequency control blacklist.
 * @property gmtModified Revised the time. The date format is based on ISO8601 notation and uses UTC +0 time in the format of yyyy-MM-ddTHH:mm:ssZ.
 * @property id The ID of the Waf Rule.
 * @property otherRegionList The effective range of the frequency control blacklist.
 * @property policyId The protection policy ID.
 * @property rateLimits The rules of rate limiting.
 * @property regularRules The regular expression.
 * @property regularTypes The type of the regular expression. If the value of the tags field contains waf_group, you can specify this field.
 * @property remoteAddrs Filter by IP address.
 * @property ruleName The name of the protection rule.
 * @property scenes List of protection scenarios
 * @property status The information about the HTTP status code.
 * @property wafGroupIds The id of the waf rule group.
 * @property wafRuleId The first ID of the resource
 */
public data class GetWafRulesWafRule(
    public val action: String,
    public val ccStatus: String,
    public val cnRegionList: String,
    public val conditions: List<GetWafRulesWafRuleCondition>,
    public val defenseScene: String,
    public val effect: String,
    public val gmtModified: String,
    public val id: String,
    public val otherRegionList: String,
    public val policyId: String,
    public val rateLimits: List<GetWafRulesWafRuleRateLimit>,
    public val regularRules: List<String>,
    public val regularTypes: List<String>,
    public val remoteAddrs: List<String>,
    public val ruleName: String,
    public val scenes: List<String>,
    public val status: String,
    public val wafGroupIds: String,
    public val wafRuleId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.dcdn.outputs.GetWafRulesWafRule): GetWafRulesWafRule = GetWafRulesWafRule(
            action = javaType.action(),
            ccStatus = javaType.ccStatus(),
            cnRegionList = javaType.cnRegionList(),
            conditions = javaType.conditions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.dcdn.kotlin.outputs.GetWafRulesWafRuleCondition.Companion.toKotlin(args0)
                })
            }),
            defenseScene = javaType.defenseScene(),
            effect = javaType.effect(),
            gmtModified = javaType.gmtModified(),
            id = javaType.id(),
            otherRegionList = javaType.otherRegionList(),
            policyId = javaType.policyId(),
            rateLimits = javaType.rateLimits().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.dcdn.kotlin.outputs.GetWafRulesWafRuleRateLimit.Companion.toKotlin(args0)
                })
            }),
            regularRules = javaType.regularRules().map({ args0 -> args0 }),
            regularTypes = javaType.regularTypes().map({ args0 -> args0 }),
            remoteAddrs = javaType.remoteAddrs().map({ args0 -> args0 }),
            ruleName = javaType.ruleName(),
            scenes = javaType.scenes().map({ args0 -> args0 }),
            status = javaType.status(),
            wafGroupIds = javaType.wafGroupIds(),
            wafRuleId = javaType.wafRuleId(),
        )
    }
}
