@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dcdn.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property interval The statistical interval. Valid values: 5 to 1800. Unit: seconds.
 * @property statuses The information about the HTTP status code.
 * @property subKey The subfield of the target field.
 * @property target The statistical field for frequency control.
 * @property threshold The trigger threshold of rate limiting. Valid values: 2 to 500000. Unit: requests.
 * @property ttl The validity period of the blacklist. Valid values: 60 to 86400. Unit: seconds.
 */
public data class GetWafRulesWafRuleRateLimit(
    public val interval: Int,
    public val statuses: List<GetWafRulesWafRuleRateLimitStatus>,
    public val subKey: String,
    public val target: String,
    public val threshold: Int,
    public val ttl: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.dcdn.outputs.GetWafRulesWafRuleRateLimit): GetWafRulesWafRuleRateLimit = GetWafRulesWafRuleRateLimit(
            interval = javaType.interval(),
            statuses = javaType.statuses().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.dcdn.kotlin.outputs.GetWafRulesWafRuleRateLimitStatus.Companion.toKotlin(args0)
                })
            }),
            subKey = javaType.subKey(),
            target = javaType.target(),
            threshold = javaType.threshold(),
            ttl = javaType.ttl(),
        )
    }
}
