@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dcdn.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property content The address of the origin server. You can specify an IP address or a domain name.
 * @property port The custom port number. Valid values: `0` to `65535`.
 * @property priority The priority of the origin server. Valid values: `20` and `30`. Default value: `20`. A value of 20 specifies that the origin is a primary origin. A value of 30 specifies that the origin is a secondary origin.
 * @property type The type of the origin server. Valid values: `ipaddr`, `domain`, `oss`.
 * @property weight The weight of the origin server. You must specify a value that is less than `100`. Default value: `10`.
 */
public data class IpaDomainSource(
    public val content: String,
    public val port: Int,
    public val priority: String,
    public val type: String,
    public val weight: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.dcdn.outputs.IpaDomainSource): IpaDomainSource = IpaDomainSource(
            content = javaType.content(),
            port = javaType.port(),
            priority = javaType.priority(),
            type = javaType.type(),
            weight = javaType.weight(),
        )
    }
}
