@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dcdn.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property key The match field.
 * @property opValue The logical symbol.
 * @property subKey The match subfield.
 * @property values The match content. Separate multiple values with commas (,).
 */
public data class WafRuleCondition(
    public val key: String,
    public val opValue: String,
    public val subKey: String? = null,
    public val values: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.dcdn.outputs.WafRuleCondition): WafRuleCondition = WafRuleCondition(
            key = javaType.key(),
            opValue = javaType.opValue(),
            subKey = javaType.subKey().map({ args0 -> args0 }).orElse(null),
            values = javaType.values().map({ args0 -> args0 }).orElse(null),
        )
    }
}
