@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dcdn.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property interval Statistical duration, 5-1800.
 * @property status Response code statistics. See `status` below.
 * @property subKey The subfield of the target field. If you set `target` to `Header`, `Query String Parameter`, or `Cookie Name`, you must configure `sub_key`.
 * @property target The statistical field for frequency control. Currently, `IP`, `Header`, `Query String Parameter`, `Cookie Name`, `Session` is supported.
 * @property threshold The trigger threshold of rate limiting. Valid values: 2 to 500000. Unit: requests.
 * @property ttl The validity period of the blacklist. Valid values: 60 to 86400. Unit: seconds.
 */
public data class WafRuleRateLimit(
    public val interval: Int? = null,
    public val status: WafRuleRateLimitStatus? = null,
    public val subKey: String? = null,
    public val target: String? = null,
    public val threshold: Int? = null,
    public val ttl: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.dcdn.outputs.WafRuleRateLimit): WafRuleRateLimit = WafRuleRateLimit(
            interval = javaType.interval().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.dcdn.kotlin.outputs.WafRuleRateLimitStatus.Companion.toKotlin(args0)
                })
            }).orElse(null),
            subKey = javaType.subKey().map({ args0 -> args0 }).orElse(null),
            target = javaType.target().map({ args0 -> args0 }).orElse(null),
            threshold = javaType.threshold().map({ args0 -> args0 }).orElse(null),
            ttl = javaType.ttl().map({ args0 -> args0 }).orElse(null),
        )
    }
}
