@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dcdn.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property code The HTTP status code returned.
 * @property count The number of times that the HTTP status code that was returned. Valid values: 2 to 50000. You can configure only one of the `ratio` and `count` fields.
 * @property ratio The percentage of HTTP status codes. Valid values: 1 to 100. You can configure only one of the `ratio` and `count` fields.
 */
public data class WafRuleRateLimitStatus(
    public val code: String? = null,
    public val count: Int? = null,
    public val ratio: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.dcdn.outputs.WafRuleRateLimitStatus): WafRuleRateLimitStatus = WafRuleRateLimitStatus(
            code = javaType.code().map({ args0 -> args0 }).orElse(null),
            count = javaType.count().map({ args0 -> args0 }).orElse(null),
            ratio = javaType.ratio().map({ args0 -> args0 }).orElse(null),
        )
    }
}
