@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ddos.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [BasicDefenseThreshold].
 */
@PulumiTagMarker
public class BasicDefenseThresholdResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: BasicDefenseThresholdArgs = BasicDefenseThresholdArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend BasicDefenseThresholdArgsBuilder.() -> Unit) {
        val builder = BasicDefenseThresholdArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): BasicDefenseThreshold {
        val builtJavaResource = com.pulumi.alicloud.ddos.BasicDefenseThreshold(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return BasicDefenseThreshold(builtJavaResource)
    }
}

/**
 * Provides a Ddos Basic defense threshold resource.
 * For information about Ddos Basic Antiddos and how to use it, see [What is Defense Threshold](https://www.alibabacloud.com/help/en/ddos-protection/latest/modifydefensethreshold).
 * > **NOTE:** Available since v1.168.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf-example";
 * const _default = new alicloud.ecs.EipAddress("default", {
 *     addressName: name,
 *     isp: "BGP",
 *     internetChargeType: "PayByBandwidth",
 *     paymentType: "PayAsYouGo",
 * });
 * const defaultBasicDefenseThreshold = new alicloud.ddos.BasicDefenseThreshold("default", {
 *     instanceId: _default.id,
 *     ddosType: "defense",
 *     instanceType: "eip",
 *     bps: 390,
 *     pps: 90000,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf-example"
 * default = alicloud.ecs.EipAddress("default",
 *     address_name=name,
 *     isp="BGP",
 *     internet_charge_type="PayByBandwidth",
 *     payment_type="PayAsYouGo")
 * default_basic_defense_threshold = alicloud.ddos.BasicDefenseThreshold("default",
 *     instance_id=default.id,
 *     ddos_type="defense",
 *     instance_type="eip",
 *     bps=390,
 *     pps=90000)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf-example";
 *     var @default = new AliCloud.Ecs.EipAddress("default", new()
 *     {
 *         AddressName = name,
 *         Isp = "BGP",
 *         InternetChargeType = "PayByBandwidth",
 *         PaymentType = "PayAsYouGo",
 *     });
 *     var defaultBasicDefenseThreshold = new AliCloud.Ddos.BasicDefenseThreshold("default", new()
 *     {
 *         InstanceId = @default.Id,
 *         DdosType = "defense",
 *         InstanceType = "eip",
 *         Bps = 390,
 *         Pps = 90000,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ddos"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ecs"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := ecs.NewEipAddress(ctx, "default", &ecs.EipAddressArgs{
 * 			AddressName:        pulumi.String(name),
 * 			Isp:                pulumi.String("BGP"),
 * 			InternetChargeType: pulumi.String("PayByBandwidth"),
 * 			PaymentType:        pulumi.String("PayAsYouGo"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ddos.NewBasicDefenseThreshold(ctx, "default", &ddos.BasicDefenseThresholdArgs{
 * 			InstanceId:   _default.ID(),
 * 			DdosType:     pulumi.String("defense"),
 * 			InstanceType: pulumi.String("eip"),
 * 			Bps:          pulumi.Int(390),
 * 			Pps:          pulumi.Int(90000),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.ecs.EipAddress;
 * import com.pulumi.alicloud.ecs.EipAddressArgs;
 * import com.pulumi.alicloud.ddos.BasicDefenseThreshold;
 * import com.pulumi.alicloud.ddos.BasicDefenseThresholdArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf-example");
 *         var default_ = new EipAddress("default", EipAddressArgs.builder()
 *             .addressName(name)
 *             .isp("BGP")
 *             .internetChargeType("PayByBandwidth")
 *             .paymentType("PayAsYouGo")
 *             .build());
 *         var defaultBasicDefenseThreshold = new BasicDefenseThreshold("defaultBasicDefenseThreshold", BasicDefenseThresholdArgs.builder()
 *             .instanceId(default_.id())
 *             .ddosType("defense")
 *             .instanceType("eip")
 *             .bps(390)
 *             .pps(90000)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf-example
 * resources:
 *   default:
 *     type: alicloud:ecs:EipAddress
 *     properties:
 *       addressName: ${name}
 *       isp: BGP
 *       internetChargeType: PayByBandwidth
 *       paymentType: PayAsYouGo
 *   defaultBasicDefenseThreshold:
 *     type: alicloud:ddos:BasicDefenseThreshold
 *     name: default
 *     properties:
 *       instanceId: ${default.id}
 *       ddosType: defense
 *       instanceType: eip
 *       bps: 390
 *       pps: 90000
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Ddos Basic Antiddos can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:ddos/basicDefenseThreshold:BasicDefenseThreshold example <instance_id>:<instance_type>:<ddos_type>
 * ```
 */
public class BasicDefenseThreshold internal constructor(
    override val javaResource: com.pulumi.alicloud.ddos.BasicDefenseThreshold,
) : KotlinCustomResource(javaResource, BasicDefenseThresholdMapper) {
    /**
     * Specifies the traffic scrubbing threshold. Unit: Mbit/s. The traffic scrubbing threshold cannot exceed the peak inbound or outbound Internet traffic, whichever is larger, of the asset.
     */
    public val bps: Output<Int>
        get() = javaResource.bps().applyValue({ args0 -> args0 })

    /**
     * The type of the threshold to query. Valid values: `defense`,`blackhole`.
     */
    public val ddosType: Output<String>
        get() = javaResource.ddosType().applyValue({ args0 -> args0 })

    /**
     * The ID of the instance.
     */
    public val instanceId: Output<String>
        get() = javaResource.instanceId().applyValue({ args0 -> args0 })

    /**
     * The instance type of the public IP address asset. Value: `ecs`,`slb`,`eip`.
     */
    public val instanceType: Output<String>
        get() = javaResource.instanceType().applyValue({ args0 -> args0 })

    /**
     * The Internet IP address.
     */
    public val internetIp: Output<String>
        get() = javaResource.internetIp().applyValue({ args0 -> args0 })

    /**
     * Whether it is the system default threshold. Value:
     */
    public val isAuto: Output<Boolean>
        get() = javaResource.isAuto().applyValue({ args0 -> args0 })

    /**
     * The maximum traffic scrubbing threshold. Unit: Mbit/s.
     */
    public val maxBps: Output<Int>
        get() = javaResource.maxBps().applyValue({ args0 -> args0 })

    /**
     * The maximum packet scrubbing threshold. Unit: pps.
     */
    public val maxPps: Output<Int>
        get() = javaResource.maxPps().applyValue({ args0 -> args0 })

    /**
     * The current message number cleaning threshold. Unit: pps.
     */
    public val pps: Output<Int>
        get() = javaResource.pps().applyValue({ args0 -> args0 })
}

public object BasicDefenseThresholdMapper : ResourceMapper<BasicDefenseThreshold> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.ddos.BasicDefenseThreshold::class == javaResource::class

    override fun map(javaResource: Resource): BasicDefenseThreshold =
        BasicDefenseThreshold(javaResource as com.pulumi.alicloud.ddos.BasicDefenseThreshold)
}

/**
 * @see [BasicDefenseThreshold].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [BasicDefenseThreshold].
 */
public suspend fun basicDefenseThreshold(
    name: String,
    block: suspend BasicDefenseThresholdResourceBuilder.() -> Unit,
): BasicDefenseThreshold {
    val builder = BasicDefenseThresholdResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [BasicDefenseThreshold].
 * @param name The _unique_ name of the resulting resource.
 */
public fun basicDefenseThreshold(name: String): BasicDefenseThreshold {
    val builder = BasicDefenseThresholdResourceBuilder()
    builder.name(name)
    return builder.build()
}
