@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ddos.kotlin

import com.pulumi.alicloud.ddos.BasicDefenseThresholdArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a Ddos Basic defense threshold resource.
 * For information about Ddos Basic Antiddos and how to use it, see [What is Defense Threshold](https://www.alibabacloud.com/help/en/ddos-protection/latest/modifydefensethreshold).
 * > **NOTE:** Available since v1.168.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf-example";
 * const _default = new alicloud.ecs.EipAddress("default", {
 *     addressName: name,
 *     isp: "BGP",
 *     internetChargeType: "PayByBandwidth",
 *     paymentType: "PayAsYouGo",
 * });
 * const defaultBasicDefenseThreshold = new alicloud.ddos.BasicDefenseThreshold("default", {
 *     instanceId: _default.id,
 *     ddosType: "defense",
 *     instanceType: "eip",
 *     bps: 390,
 *     pps: 90000,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf-example"
 * default = alicloud.ecs.EipAddress("default",
 *     address_name=name,
 *     isp="BGP",
 *     internet_charge_type="PayByBandwidth",
 *     payment_type="PayAsYouGo")
 * default_basic_defense_threshold = alicloud.ddos.BasicDefenseThreshold("default",
 *     instance_id=default.id,
 *     ddos_type="defense",
 *     instance_type="eip",
 *     bps=390,
 *     pps=90000)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf-example";
 *     var @default = new AliCloud.Ecs.EipAddress("default", new()
 *     {
 *         AddressName = name,
 *         Isp = "BGP",
 *         InternetChargeType = "PayByBandwidth",
 *         PaymentType = "PayAsYouGo",
 *     });
 *     var defaultBasicDefenseThreshold = new AliCloud.Ddos.BasicDefenseThreshold("default", new()
 *     {
 *         InstanceId = @default.Id,
 *         DdosType = "defense",
 *         InstanceType = "eip",
 *         Bps = 390,
 *         Pps = 90000,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ddos"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ecs"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := ecs.NewEipAddress(ctx, "default", &ecs.EipAddressArgs{
 * 			AddressName:        pulumi.String(name),
 * 			Isp:                pulumi.String("BGP"),
 * 			InternetChargeType: pulumi.String("PayByBandwidth"),
 * 			PaymentType:        pulumi.String("PayAsYouGo"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ddos.NewBasicDefenseThreshold(ctx, "default", &ddos.BasicDefenseThresholdArgs{
 * 			InstanceId:   _default.ID(),
 * 			DdosType:     pulumi.String("defense"),
 * 			InstanceType: pulumi.String("eip"),
 * 			Bps:          pulumi.Int(390),
 * 			Pps:          pulumi.Int(90000),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.ecs.EipAddress;
 * import com.pulumi.alicloud.ecs.EipAddressArgs;
 * import com.pulumi.alicloud.ddos.BasicDefenseThreshold;
 * import com.pulumi.alicloud.ddos.BasicDefenseThresholdArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf-example");
 *         var default_ = new EipAddress("default", EipAddressArgs.builder()
 *             .addressName(name)
 *             .isp("BGP")
 *             .internetChargeType("PayByBandwidth")
 *             .paymentType("PayAsYouGo")
 *             .build());
 *         var defaultBasicDefenseThreshold = new BasicDefenseThreshold("defaultBasicDefenseThreshold", BasicDefenseThresholdArgs.builder()
 *             .instanceId(default_.id())
 *             .ddosType("defense")
 *             .instanceType("eip")
 *             .bps(390)
 *             .pps(90000)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf-example
 * resources:
 *   default:
 *     type: alicloud:ecs:EipAddress
 *     properties:
 *       addressName: ${name}
 *       isp: BGP
 *       internetChargeType: PayByBandwidth
 *       paymentType: PayAsYouGo
 *   defaultBasicDefenseThreshold:
 *     type: alicloud:ddos:BasicDefenseThreshold
 *     name: default
 *     properties:
 *       instanceId: ${default.id}
 *       ddosType: defense
 *       instanceType: eip
 *       bps: 390
 *       pps: 90000
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Ddos Basic Antiddos can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:ddos/basicDefenseThreshold:BasicDefenseThreshold example <instance_id>:<instance_type>:<ddos_type>
 * ```
 * @property bps Specifies the traffic scrubbing threshold. Unit: Mbit/s. The traffic scrubbing threshold cannot exceed the peak inbound or outbound Internet traffic, whichever is larger, of the asset.
 * @property ddosType The type of the threshold to query. Valid values: `defense`,`blackhole`.
 * @property instanceId The ID of the instance.
 * @property instanceType The instance type of the public IP address asset. Value: `ecs`,`slb`,`eip`.
 * @property internetIp The Internet IP address.
 * @property isAuto Whether it is the system default threshold. Value:
 * @property pps The current message number cleaning threshold. Unit: pps.
 */
public data class BasicDefenseThresholdArgs(
    public val bps: Output<Int>? = null,
    public val ddosType: Output<String>? = null,
    public val instanceId: Output<String>? = null,
    public val instanceType: Output<String>? = null,
    public val internetIp: Output<String>? = null,
    public val isAuto: Output<Boolean>? = null,
    public val pps: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ddos.BasicDefenseThresholdArgs> {
    override fun toJava(): com.pulumi.alicloud.ddos.BasicDefenseThresholdArgs =
        com.pulumi.alicloud.ddos.BasicDefenseThresholdArgs.builder()
            .bps(bps?.applyValue({ args0 -> args0 }))
            .ddosType(ddosType?.applyValue({ args0 -> args0 }))
            .instanceId(instanceId?.applyValue({ args0 -> args0 }))
            .instanceType(instanceType?.applyValue({ args0 -> args0 }))
            .internetIp(internetIp?.applyValue({ args0 -> args0 }))
            .isAuto(isAuto?.applyValue({ args0 -> args0 }))
            .pps(pps?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BasicDefenseThresholdArgs].
 */
@PulumiTagMarker
public class BasicDefenseThresholdArgsBuilder internal constructor() {
    private var bps: Output<Int>? = null

    private var ddosType: Output<String>? = null

    private var instanceId: Output<String>? = null

    private var instanceType: Output<String>? = null

    private var internetIp: Output<String>? = null

    private var isAuto: Output<Boolean>? = null

    private var pps: Output<Int>? = null

    /**
     * @param value Specifies the traffic scrubbing threshold. Unit: Mbit/s. The traffic scrubbing threshold cannot exceed the peak inbound or outbound Internet traffic, whichever is larger, of the asset.
     */
    @JvmName("ykahsfroeynfvyms")
    public suspend fun bps(`value`: Output<Int>) {
        this.bps = value
    }

    /**
     * @param value The type of the threshold to query. Valid values: `defense`,`blackhole`.
     */
    @JvmName("xwibylunprdmisih")
    public suspend fun ddosType(`value`: Output<String>) {
        this.ddosType = value
    }

    /**
     * @param value The ID of the instance.
     */
    @JvmName("vqecwwkxtvtmttyk")
    public suspend fun instanceId(`value`: Output<String>) {
        this.instanceId = value
    }

    /**
     * @param value The instance type of the public IP address asset. Value: `ecs`,`slb`,`eip`.
     */
    @JvmName("agllynbcrfowytbf")
    public suspend fun instanceType(`value`: Output<String>) {
        this.instanceType = value
    }

    /**
     * @param value The Internet IP address.
     */
    @JvmName("vqxxrvoksdhmtwxb")
    public suspend fun internetIp(`value`: Output<String>) {
        this.internetIp = value
    }

    /**
     * @param value Whether it is the system default threshold. Value:
     */
    @JvmName("pnhnllcsbxmhiwld")
    public suspend fun isAuto(`value`: Output<Boolean>) {
        this.isAuto = value
    }

    /**
     * @param value The current message number cleaning threshold. Unit: pps.
     */
    @JvmName("niboxvcyxqtkawfi")
    public suspend fun pps(`value`: Output<Int>) {
        this.pps = value
    }

    /**
     * @param value Specifies the traffic scrubbing threshold. Unit: Mbit/s. The traffic scrubbing threshold cannot exceed the peak inbound or outbound Internet traffic, whichever is larger, of the asset.
     */
    @JvmName("aohebjgiotbhadbr")
    public suspend fun bps(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bps = mapped
    }

    /**
     * @param value The type of the threshold to query. Valid values: `defense`,`blackhole`.
     */
    @JvmName("qfmnwjgkiqmrbmpc")
    public suspend fun ddosType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ddosType = mapped
    }

    /**
     * @param value The ID of the instance.
     */
    @JvmName("pojuarvlpgvorqub")
    public suspend fun instanceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceId = mapped
    }

    /**
     * @param value The instance type of the public IP address asset. Value: `ecs`,`slb`,`eip`.
     */
    @JvmName("nsrwncuvunamrbny")
    public suspend fun instanceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceType = mapped
    }

    /**
     * @param value The Internet IP address.
     */
    @JvmName("whlvjdlybuvbcriy")
    public suspend fun internetIp(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.internetIp = mapped
    }

    /**
     * @param value Whether it is the system default threshold. Value:
     */
    @JvmName("txbyiyqqtcgrorpq")
    public suspend fun isAuto(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isAuto = mapped
    }

    /**
     * @param value The current message number cleaning threshold. Unit: pps.
     */
    @JvmName("mdsshhcxgjtinfdp")
    public suspend fun pps(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pps = mapped
    }

    internal fun build(): BasicDefenseThresholdArgs = BasicDefenseThresholdArgs(
        bps = bps,
        ddosType = ddosType,
        instanceId = instanceId,
        instanceType = instanceType,
        internetIp = internetIp,
        isAuto = isAuto,
        pps = pps,
    )
}
