@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ddos.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [BasicThreshold].
 */
@PulumiTagMarker
public class BasicThresholdResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: BasicThresholdArgs = BasicThresholdArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend BasicThresholdArgsBuilder.() -> Unit) {
        val builder = BasicThresholdArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): BasicThreshold {
        val builtJavaResource = com.pulumi.alicloud.ddos.BasicThreshold(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return BasicThreshold(builtJavaResource)
    }
}

/**
 * Provides a Ddos Basic Threshold resource.
 * For information about Ddos Basic Threshold and how to use it, see [What is Threshold](https://www.alibabacloud.com/help/en/ddos-protection/latest/describe-ip-ddosthreshold).
 * > **NOTE:** Available since v1.183.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf-example";
 * const default = alicloud.getZones({
 *     availableDiskCategory: "cloud_efficiency",
 *     availableResourceCreation: "VSwitch",
 * });
 * const defaultGetInstanceTypes = _default.then(_default => alicloud.ecs.getInstanceTypes({
 *     availabilityZone: _default.zones?.[0]?.id,
 *     instanceTypeFamily: "ecs.sn1ne",
 * }));
 * const defaultGetImages = alicloud.ecs.getImages({
 *     nameRegex: "^ubuntu_18.*64",
 *     mostRecent: true,
 *     owners: "system",
 * });
 * const defaultNetwork = new alicloud.vpc.Network("default", {
 *     vpcName: name,
 *     cidrBlock: "192.168.0.0/16",
 * });
 * const defaultSwitch = new alicloud.vpc.Switch("default", {
 *     vswitchName: name,
 *     vpcId: defaultNetwork.id,
 *     cidrBlock: "192.168.192.0/24",
 *     zoneId: _default.then(_default => _default.ids?.[0]),
 * });
 * const defaultSecurityGroup = new alicloud.ecs.SecurityGroup("default", {
 *     name: name,
 *     vpcId: defaultNetwork.id,
 * });
 * const defaultInstance = new alicloud.ecs.Instance("default", {
 *     imageId: defaultGetImages.then(defaultGetImages => defaultGetImages.images?.[0]?.id),
 *     instanceType: defaultGetInstanceTypes.then(defaultGetInstanceTypes => defaultGetInstanceTypes.instanceTypes?.[0]?.id),
 *     instanceName: name,
 *     securityGroups: [defaultSecurityGroup].map(__item => __item.id),
 *     internetChargeType: "PayByTraffic",
 *     internetMaxBandwidthOut: 10,
 *     availabilityZone: _default.then(_default => _default.zones?.[0]?.id),
 *     instanceChargeType: "PostPaid",
 *     systemDiskCategory: "cloud_efficiency",
 *     vswitchId: defaultSwitch.id,
 * });
 * const example = new alicloud.ddos.BasicThreshold("example", {
 *     instanceType: "ecs",
 *     instanceId: defaultInstance.id,
 *     internetIp: defaultInstance.publicIp,
 *     bps: 100,
 *     pps: 60000,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf-example"
 * default = alicloud.get_zones(available_disk_category="cloud_efficiency",
 *     available_resource_creation="VSwitch")
 * default_get_instance_types = alicloud.ecs.get_instance_types(availability_zone=default.zones[0].id,
 *     instance_type_family="ecs.sn1ne")
 * default_get_images = alicloud.ecs.get_images(name_regex="^ubuntu_18.*64",
 *     most_recent=True,
 *     owners="system")
 * default_network = alicloud.vpc.Network("default",
 *     vpc_name=name,
 *     cidr_block="192.168.0.0/16")
 * default_switch = alicloud.vpc.Switch("default",
 *     vswitch_name=name,
 *     vpc_id=default_network.id,
 *     cidr_block="192.168.192.0/24",
 *     zone_id=default.ids[0])
 * default_security_group = alicloud.ecs.SecurityGroup("default",
 *     name=name,
 *     vpc_id=default_network.id)
 * default_instance = alicloud.ecs.Instance("default",
 *     image_id=default_get_images.images[0].id,
 *     instance_type=default_get_instance_types.instance_types[0].id,
 *     instance_name=name,
 *     security_groups=[__item&#46;id for __item in [default_security_group]],
 *     internet_charge_type="PayByTraffic",
 *     internet_max_bandwidth_out=10,
 *     availability_zone=default.zones[0].id,
 *     instance_charge_type="PostPaid",
 *     system_disk_category="cloud_efficiency",
 *     vswitch_id=default_switch.id)
 * example = alicloud.ddos.BasicThreshold("example",
 *     instance_type="ecs",
 *     instance_id=default_instance.id,
 *     internet_ip=default_instance.public_ip,
 *     bps=100,
 *     pps=60000)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf-example";
 *     var @default = AliCloud.GetZones.Invoke(new()
 *     {
 *         AvailableDiskCategory = "cloud_efficiency",
 *         AvailableResourceCreation = "VSwitch",
 *     });
 *     var defaultGetInstanceTypes = AliCloud.Ecs.GetInstanceTypes.Invoke(new()
 *     {
 *         AvailabilityZone = @default.Apply(getZonesResult => getZonesResult.Zones[0]?.Id),
 *         InstanceTypeFamily = "ecs.sn1ne",
 *     });
 *     var defaultGetImages = AliCloud.Ecs.GetImages.Invoke(new()
 *     {
 *         NameRegex = "^ubuntu_18.*64",
 *         MostRecent = true,
 *         Owners = "system",
 *     });
 *     var defaultNetwork = new AliCloud.Vpc.Network("default", new()
 *     {
 *         VpcName = name,
 *         CidrBlock = "192.168.0.0/16",
 *     });
 *     var defaultSwitch = new AliCloud.Vpc.Switch("default", new()
 *     {
 *         VswitchName = name,
 *         VpcId = defaultNetwork.Id,
 *         CidrBlock = "192.168.192.0/24",
 *         ZoneId = @default.Apply(@default => @default.Apply(getZonesResult => getZonesResult.Ids[0])),
 *     });
 *     var defaultSecurityGroup = new AliCloud.Ecs.SecurityGroup("default", new()
 *     {
 *         Name = name,
 *         VpcId = defaultNetwork.Id,
 *     });
 *     var defaultInstance = new AliCloud.Ecs.Instance("default", new()
 *     {
 *         ImageId = defaultGetImages.Apply(getImagesResult => getImagesResult.Images[0]?.Id),
 *         InstanceType = defaultGetInstanceTypes.Apply(getInstanceTypesResult => getInstanceTypesResult.InstanceTypes[0]?.Id),
 *         InstanceName = name,
 *         SecurityGroups = new[]
 *         {
 *             defaultSecurityGroup,
 *         }.Select(__item => __item.Id).ToList(),
 *         InternetChargeType = "PayByTraffic",
 *         InternetMaxBandwidthOut = 10,
 *         AvailabilityZone = @default.Apply(@default => @default.Apply(getZonesResult => getZonesResult.Zones[0]?.Id)),
 *         InstanceChargeType = "PostPaid",
 *         SystemDiskCategory = "cloud_efficiency",
 *         VswitchId = defaultSwitch.Id,
 *     });
 *     var example = new AliCloud.Ddos.BasicThreshold("example", new()
 *     {
 *         InstanceType = "ecs",
 *         InstanceId = defaultInstance.Id,
 *         InternetIp = defaultInstance.PublicIp,
 *         Bps = 100,
 *         Pps = 60000,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ddos"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ecs"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * cfg := config.New(ctx, "")
 * name := "tf-example";
 * if param := cfg.Get("name"); param != ""{
 * name = param
 * }
 * _default, err := alicloud.GetZones(ctx, &alicloud.GetZonesArgs{
 * AvailableDiskCategory: pulumi.StringRef("cloud_efficiency"),
 * AvailableResourceCreation: pulumi.StringRef("VSwitch"),
 * }, nil);
 * if err != nil {
 * return err
 * }
 * defaultGetInstanceTypes, err := ecs.GetInstanceTypes(ctx, &ecs.GetInstanceTypesArgs{
 * AvailabilityZone: pulumi.StringRef(_default.Zones[0].Id),
 * InstanceTypeFamily: pulumi.StringRef("ecs.sn1ne"),
 * }, nil);
 * if err != nil {
 * return err
 * }
 * defaultGetImages, err := ecs.GetImages(ctx, &ecs.GetImagesArgs{
 * NameRegex: pulumi.StringRef("^ubuntu_18.*64"),
 * MostRecent: pulumi.BoolRef(true),
 * Owners: pulumi.StringRef("system"),
 * }, nil);
 * if err != nil {
 * return err
 * }
 * defaultNetwork, err := vpc.NewNetwork(ctx, "default", &vpc.NetworkArgs{
 * VpcName: pulumi.String(name),
 * CidrBlock: pulumi.String("192.168.0.0/16"),
 * })
 * if err != nil {
 * return err
 * }
 * defaultSwitch, err := vpc.NewSwitch(ctx, "default", &vpc.SwitchArgs{
 * VswitchName: pulumi.String(name),
 * VpcId: defaultNetwork.ID(),
 * CidrBlock: pulumi.String("192.168.192.0/24"),
 * ZoneId: pulumi.String(_default.Ids[0]),
 * })
 * if err != nil {
 * return err
 * }
 * defaultSecurityGroup, err := ecs.NewSecurityGroup(ctx, "default", &ecs.SecurityGroupArgs{
 * Name: pulumi.String(name),
 * VpcId: defaultNetwork.ID(),
 * })
 * if err != nil {
 * return err
 * }
 * var splat0 pulumi.StringArray
 * for _, val0 := range %!v(PANIC=Format method: fatal: An assertion has failed: tok: ) {
 * splat0 = append(splat0, val0.ID())
 * }
 * defaultInstance, err := ecs.NewInstance(ctx, "default", &ecs.InstanceArgs{
 * ImageId: pulumi.String(defaultGetImages.Images[0].Id),
 * InstanceType: pulumi.String(defaultGetInstanceTypes.InstanceTypes[0].Id),
 * InstanceName: pulumi.String(name),
 * SecurityGroups: splat0,
 * InternetChargeType: pulumi.String("PayByTraffic"),
 * InternetMaxBandwidthOut: pulumi.Int(10),
 * AvailabilityZone: pulumi.String(_default.Zones[0].Id),
 * InstanceChargeType: pulumi.String("PostPaid"),
 * SystemDiskCategory: pulumi.String("cloud_efficiency"),
 * VswitchId: defaultSwitch.ID(),
 * })
 * if err != nil {
 * return err
 * }
 * _, err = ddos.NewBasicThreshold(ctx, "example", &ddos.BasicThresholdArgs{
 * InstanceType: pulumi.String("ecs"),
 * InstanceId: defaultInstance.ID(),
 * InternetIp: defaultInstance.PublicIp,
 * Bps: pulumi.Int(100),
 * Pps: pulumi.Int(60000),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.AlicloudFunctions;
 * import com.pulumi.alicloud.inputs.GetZonesArgs;
 * import com.pulumi.alicloud.ecs.EcsFunctions;
 * import com.pulumi.alicloud.ecs.inputs.GetInstanceTypesArgs;
 * import com.pulumi.alicloud.ecs.inputs.GetImagesArgs;
 * import com.pulumi.alicloud.vpc.Network;
 * import com.pulumi.alicloud.vpc.NetworkArgs;
 * import com.pulumi.alicloud.vpc.Switch;
 * import com.pulumi.alicloud.vpc.SwitchArgs;
 * import com.pulumi.alicloud.ecs.SecurityGroup;
 * import com.pulumi.alicloud.ecs.SecurityGroupArgs;
 * import com.pulumi.alicloud.ecs.Instance;
 * import com.pulumi.alicloud.ecs.InstanceArgs;
 * import com.pulumi.alicloud.ddos.BasicThreshold;
 * import com.pulumi.alicloud.ddos.BasicThresholdArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf-example");
 *         final var default = AlicloudFunctions.getZones(GetZonesArgs.builder()
 *             .availableDiskCategory("cloud_efficiency")
 *             .availableResourceCreation("VSwitch")
 *             .build());
 *         final var defaultGetInstanceTypes = EcsFunctions.getInstanceTypes(GetInstanceTypesArgs.builder()
 *             .availabilityZone(default_.zones()[0].id())
 *             .instanceTypeFamily("ecs.sn1ne")
 *             .build());
 *         final var defaultGetImages = EcsFunctions.getImages(GetImagesArgs.builder()
 *             .nameRegex("^ubuntu_18.*64")
 *             .mostRecent(true)
 *             .owners("system")
 *             .build());
 *         var defaultNetwork = new Network("defaultNetwork", NetworkArgs.builder()
 *             .vpcName(name)
 *             .cidrBlock("192.168.0.0/16")
 *             .build());
 *         var defaultSwitch = new Switch("defaultSwitch", SwitchArgs.builder()
 *             .vswitchName(name)
 *             .vpcId(defaultNetwork.id())
 *             .cidrBlock("192.168.192.0/24")
 *             .zoneId(default_.ids()[0])
 *             .build());
 *         var defaultSecurityGroup = new SecurityGroup("defaultSecurityGroup", SecurityGroupArgs.builder()
 *             .name(name)
 *             .vpcId(defaultNetwork.id())
 *             .build());
 *         var defaultInstance = new Instance("defaultInstance", InstanceArgs.builder()
 *             .imageId(defaultGetImages.applyValue(getImagesResult -> getImagesResult.images()[0].id()))
 *             .instanceType(defaultGetInstanceTypes.applyValue(getInstanceTypesResult -> getInstanceTypesResult.instanceTypes()[0].id()))
 *             .instanceName(name)
 *             .securityGroups(defaultSecurityGroup.stream().map(element -> element.id()).collect(toList()))
 *             .internetChargeType("PayByTraffic")
 *             .internetMaxBandwidthOut("10")
 *             .availabilityZone(default_.zones()[0].id())
 *             .instanceChargeType("PostPaid")
 *             .systemDiskCategory("cloud_efficiency")
 *             .vswitchId(defaultSwitch.id())
 *             .build());
 *         var example = new BasicThreshold("example", BasicThresholdArgs.builder()
 *             .instanceType("ecs")
 *             .instanceId(defaultInstance.id())
 *             .internetIp(defaultInstance.publicIp())
 *             .bps(100)
 *             .pps(60000)
 *             .build());
 *     }
 * }
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Ddos Basic Threshold can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:ddos/basicThreshold:BasicThreshold example <instance_type>:<instance_id>:<internet_ip>
 * ```
 */
public class BasicThreshold internal constructor(
    override val javaResource: com.pulumi.alicloud.ddos.BasicThreshold,
) : KotlinCustomResource(javaResource, BasicThresholdMapper) {
    /**
     * Specifies the traffic scrubbing threshold. Unit: Mbit/s. The traffic scrubbing threshold cannot exceed the peak inbound or outbound Internet traffic, whichever is larger, of the asset.
     */
    public val bps: Output<Int>
        get() = javaResource.bps().applyValue({ args0 -> args0 })

    /**
     * The ID of the instance.
     */
    public val instanceId: Output<String>
        get() = javaResource.instanceId().applyValue({ args0 -> args0 })

    /**
     * The type of the Instance. Valid values: `ecs`,`slb`,`eip`.
     */
    public val instanceType: Output<String>
        get() = javaResource.instanceType().applyValue({ args0 -> args0 })

    /**
     * The IP address of the public IP address asset.
     */
    public val internetIp: Output<String>
        get() = javaResource.internetIp().applyValue({ args0 -> args0 })

    /**
     * Maximum flow cleaning threshold. Unit: Mbps.
     */
    public val maxBps: Output<Int>
        get() = javaResource.maxBps().applyValue({ args0 -> args0 })

    /**
     * The maximum number of messages cleaning threshold. Unit: pps.
     */
    public val maxPps: Output<Int>
        get() = javaResource.maxPps().applyValue({ args0 -> args0 })

    /**
     * The current message number cleaning threshold. Unit: pps.
     */
    public val pps: Output<Int>
        get() = javaResource.pps().applyValue({ args0 -> args0 })
}

public object BasicThresholdMapper : ResourceMapper<BasicThreshold> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.ddos.BasicThreshold::class == javaResource::class

    override fun map(javaResource: Resource): BasicThreshold = BasicThreshold(
        javaResource as
            com.pulumi.alicloud.ddos.BasicThreshold,
    )
}

/**
 * @see [BasicThreshold].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [BasicThreshold].
 */
public suspend fun basicThreshold(
    name: String,
    block: suspend BasicThresholdResourceBuilder.() -> Unit,
): BasicThreshold {
    val builder = BasicThresholdResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [BasicThreshold].
 * @param name The _unique_ name of the resulting resource.
 */
public fun basicThreshold(name: String): BasicThreshold {
    val builder = BasicThresholdResourceBuilder()
    builder.name(name)
    return builder.build()
}
