@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ddos.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [BgpIp].
 */
@PulumiTagMarker
public class BgpIpResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: BgpIpArgs = BgpIpArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend BgpIpArgsBuilder.() -> Unit) {
        val builder = BgpIpArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): BgpIp {
        val builtJavaResource = com.pulumi.alicloud.ddos.BgpIp(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return BgpIp(builtJavaResource)
    }
}

/**
 * Provides a Ddos Bgp Ip resource.
 * For information about Ddos Bgp Ip and how to use it, see [What is Ip](https://www.alibabacloud.com/help/en/ddos-protection/latest/addip).
 * > **NOTE:** Available since v1.180.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf-example";
 * const default = alicloud.resourcemanager.getResourceGroups({});
 * const instance = new alicloud.ddos.DdosBgpInstance("instance", {
 *     name: name,
 *     baseBandwidth: 20,
 *     bandwidth: -1,
 *     ipCount: 100,
 *     ipType: "IPv4",
 *     normalBandwidth: 100,
 *     type: "Enterprise",
 * });
 * const defaultEipAddress = new alicloud.ecs.EipAddress("default", {addressName: name});
 * const defaultBgpIp = new alicloud.ddos.BgpIp("default", {
 *     instanceId: instance.id,
 *     ip: defaultEipAddress.ipAddress,
 *     resourceGroupId: _default.then(_default => _default.groups?.[0]?.id),
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf-example"
 * default = alicloud.resourcemanager.get_resource_groups()
 * instance = alicloud.ddos.DdosBgpInstance("instance",
 *     name=name,
 *     base_bandwidth=20,
 *     bandwidth=-1,
 *     ip_count=100,
 *     ip_type="IPv4",
 *     normal_bandwidth=100,
 *     type="Enterprise")
 * default_eip_address = alicloud.ecs.EipAddress("default", address_name=name)
 * default_bgp_ip = alicloud.ddos.BgpIp("default",
 *     instance_id=instance.id,
 *     ip=default_eip_address.ip_address,
 *     resource_group_id=default.groups[0].id)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf-example";
 *     var @default = AliCloud.ResourceManager.GetResourceGroups.Invoke();
 *     var instance = new AliCloud.Ddos.DdosBgpInstance("instance", new()
 *     {
 *         Name = name,
 *         BaseBandwidth = 20,
 *         Bandwidth = -1,
 *         IpCount = 100,
 *         IpType = "IPv4",
 *         NormalBandwidth = 100,
 *         Type = "Enterprise",
 *     });
 *     var defaultEipAddress = new AliCloud.Ecs.EipAddress("default", new()
 *     {
 *         AddressName = name,
 *     });
 *     var defaultBgpIp = new AliCloud.Ddos.BgpIp("default", new()
 *     {
 *         InstanceId = instance.Id,
 *         Ip = defaultEipAddress.IpAddress,
 *         ResourceGroupId = @default.Apply(@default => @default.Apply(getResourceGroupsResult => getResourceGroupsResult.Groups[0]?.Id)),
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ddos"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ecs"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/resourcemanager"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_default, err := resourcemanager.GetResourceGroups(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		instance, err := ddos.NewDdosBgpInstance(ctx, "instance", &ddos.DdosBgpInstanceArgs{
 * 			Name:            pulumi.String(name),
 * 			BaseBandwidth:   pulumi.Int(20),
 * 			Bandwidth:       int(-1),
 * 			IpCount:         pulumi.Int(100),
 * 			IpType:          pulumi.String("IPv4"),
 * 			NormalBandwidth: pulumi.Int(100),
 * 			Type:            pulumi.String("Enterprise"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultEipAddress, err := ecs.NewEipAddress(ctx, "default", &ecs.EipAddressArgs{
 * 			AddressName: pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ddos.NewBgpIp(ctx, "default", &ddos.BgpIpArgs{
 * 			InstanceId:      instance.ID(),
 * 			Ip:              defaultEipAddress.IpAddress,
 * 			ResourceGroupId: pulumi.String(_default.Groups[0].Id),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf-example
 * resources:
 *   instance:
 *     type: alicloud:ddos:DdosBgpInstance
 *     properties:
 *       name: ${name}
 *       baseBandwidth: 20
 *       bandwidth: -1
 *       ipCount: 100
 *       ipType: IPv4
 *       normalBandwidth: 100
 *       type: Enterprise
 *   defaultEipAddress:
 *     type: alicloud:ecs:EipAddress
 *     name: default
 *     properties:
 *       addressName: ${name}
 *   defaultBgpIp:
 *     type: alicloud:ddos:BgpIp
 *     name: default
 *     properties:
 *       instanceId: ${instance.id}
 *       ip: ${defaultEipAddress.ipAddress}
 *       resourceGroupId: ${default.groups[0].id}
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:resourcemanager:getResourceGroups
 *       Arguments: {}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Ddos Bgp Ip can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:ddos/bgpIp:BgpIp example <instance_id>:<ip>
 * ```
 */
public class BgpIp internal constructor(
    override val javaResource: com.pulumi.alicloud.ddos.BgpIp,
) : KotlinCustomResource(javaResource, BgpIpMapper) {
    /**
     * The ID of the native protection enterprise instance to be operated.
     */
    public val instanceId: Output<String>
        get() = javaResource.instanceId().applyValue({ args0 -> args0 })

    /**
     * The IP address.
     */
    public val ip: Output<String>
        get() = javaResource.ip().applyValue({ args0 -> args0 })

    /**
     * The member account id of the IP address.
     */
    public val memberUid: Output<String>?
        get() = javaResource.memberUid().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The ID of the resource group.
     */
    public val resourceGroupId: Output<String>?
        get() = javaResource.resourceGroupId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The current state of the IP address. Valid Value: `normal`, `hole_begin`.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })
}

public object BgpIpMapper : ResourceMapper<BgpIp> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.ddos.BgpIp::class == javaResource::class

    override fun map(javaResource: Resource): BgpIp = BgpIp(
        javaResource as
            com.pulumi.alicloud.ddos.BgpIp,
    )
}

/**
 * @see [BgpIp].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [BgpIp].
 */
public suspend fun bgpIp(name: String, block: suspend BgpIpResourceBuilder.() -> Unit): BgpIp {
    val builder = BgpIpResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [BgpIp].
 * @param name The _unique_ name of the resulting resource.
 */
public fun bgpIp(name: String): BgpIp {
    val builder = BgpIpResourceBuilder()
    builder.name(name)
    return builder.build()
}
