@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ddos.kotlin

import com.pulumi.alicloud.ddos.BgpIpArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a Ddos Bgp Ip resource.
 * For information about Ddos Bgp Ip and how to use it, see [What is Ip](https://www.alibabacloud.com/help/en/ddos-protection/latest/addip).
 * > **NOTE:** Available since v1.180.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf-example";
 * const default = alicloud.resourcemanager.getResourceGroups({});
 * const instance = new alicloud.ddos.DdosBgpInstance("instance", {
 *     name: name,
 *     baseBandwidth: 20,
 *     bandwidth: -1,
 *     ipCount: 100,
 *     ipType: "IPv4",
 *     normalBandwidth: 100,
 *     type: "Enterprise",
 * });
 * const defaultEipAddress = new alicloud.ecs.EipAddress("default", {addressName: name});
 * const defaultBgpIp = new alicloud.ddos.BgpIp("default", {
 *     instanceId: instance.id,
 *     ip: defaultEipAddress.ipAddress,
 *     resourceGroupId: _default.then(_default => _default.groups?.[0]?.id),
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf-example"
 * default = alicloud.resourcemanager.get_resource_groups()
 * instance = alicloud.ddos.DdosBgpInstance("instance",
 *     name=name,
 *     base_bandwidth=20,
 *     bandwidth=-1,
 *     ip_count=100,
 *     ip_type="IPv4",
 *     normal_bandwidth=100,
 *     type="Enterprise")
 * default_eip_address = alicloud.ecs.EipAddress("default", address_name=name)
 * default_bgp_ip = alicloud.ddos.BgpIp("default",
 *     instance_id=instance.id,
 *     ip=default_eip_address.ip_address,
 *     resource_group_id=default.groups[0].id)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf-example";
 *     var @default = AliCloud.ResourceManager.GetResourceGroups.Invoke();
 *     var instance = new AliCloud.Ddos.DdosBgpInstance("instance", new()
 *     {
 *         Name = name,
 *         BaseBandwidth = 20,
 *         Bandwidth = -1,
 *         IpCount = 100,
 *         IpType = "IPv4",
 *         NormalBandwidth = 100,
 *         Type = "Enterprise",
 *     });
 *     var defaultEipAddress = new AliCloud.Ecs.EipAddress("default", new()
 *     {
 *         AddressName = name,
 *     });
 *     var defaultBgpIp = new AliCloud.Ddos.BgpIp("default", new()
 *     {
 *         InstanceId = instance.Id,
 *         Ip = defaultEipAddress.IpAddress,
 *         ResourceGroupId = @default.Apply(@default => @default.Apply(getResourceGroupsResult => getResourceGroupsResult.Groups[0]?.Id)),
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ddos"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ecs"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/resourcemanager"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_default, err := resourcemanager.GetResourceGroups(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		instance, err := ddos.NewDdosBgpInstance(ctx, "instance", &ddos.DdosBgpInstanceArgs{
 * 			Name:            pulumi.String(name),
 * 			BaseBandwidth:   pulumi.Int(20),
 * 			Bandwidth:       int(-1),
 * 			IpCount:         pulumi.Int(100),
 * 			IpType:          pulumi.String("IPv4"),
 * 			NormalBandwidth: pulumi.Int(100),
 * 			Type:            pulumi.String("Enterprise"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultEipAddress, err := ecs.NewEipAddress(ctx, "default", &ecs.EipAddressArgs{
 * 			AddressName: pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ddos.NewBgpIp(ctx, "default", &ddos.BgpIpArgs{
 * 			InstanceId:      instance.ID(),
 * 			Ip:              defaultEipAddress.IpAddress,
 * 			ResourceGroupId: pulumi.String(_default.Groups[0].Id),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf-example
 * resources:
 *   instance:
 *     type: alicloud:ddos:DdosBgpInstance
 *     properties:
 *       name: ${name}
 *       baseBandwidth: 20
 *       bandwidth: -1
 *       ipCount: 100
 *       ipType: IPv4
 *       normalBandwidth: 100
 *       type: Enterprise
 *   defaultEipAddress:
 *     type: alicloud:ecs:EipAddress
 *     name: default
 *     properties:
 *       addressName: ${name}
 *   defaultBgpIp:
 *     type: alicloud:ddos:BgpIp
 *     name: default
 *     properties:
 *       instanceId: ${instance.id}
 *       ip: ${defaultEipAddress.ipAddress}
 *       resourceGroupId: ${default.groups[0].id}
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:resourcemanager:getResourceGroups
 *       Arguments: {}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Ddos Bgp Ip can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:ddos/bgpIp:BgpIp example <instance_id>:<ip>
 * ```
 * @property instanceId The ID of the native protection enterprise instance to be operated.
 * @property ip The IP address.
 * @property memberUid The member account id of the IP address.
 * @property resourceGroupId The ID of the resource group.
 */
public data class BgpIpArgs(
    public val instanceId: Output<String>? = null,
    public val ip: Output<String>? = null,
    public val memberUid: Output<String>? = null,
    public val resourceGroupId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ddos.BgpIpArgs> {
    override fun toJava(): com.pulumi.alicloud.ddos.BgpIpArgs =
        com.pulumi.alicloud.ddos.BgpIpArgs.builder()
            .instanceId(instanceId?.applyValue({ args0 -> args0 }))
            .ip(ip?.applyValue({ args0 -> args0 }))
            .memberUid(memberUid?.applyValue({ args0 -> args0 }))
            .resourceGroupId(resourceGroupId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BgpIpArgs].
 */
@PulumiTagMarker
public class BgpIpArgsBuilder internal constructor() {
    private var instanceId: Output<String>? = null

    private var ip: Output<String>? = null

    private var memberUid: Output<String>? = null

    private var resourceGroupId: Output<String>? = null

    /**
     * @param value The ID of the native protection enterprise instance to be operated.
     */
    @JvmName("xctempogwjagpqfk")
    public suspend fun instanceId(`value`: Output<String>) {
        this.instanceId = value
    }

    /**
     * @param value The IP address.
     */
    @JvmName("pmxdtrkymjydynaf")
    public suspend fun ip(`value`: Output<String>) {
        this.ip = value
    }

    /**
     * @param value The member account id of the IP address.
     */
    @JvmName("jbvgjwffqkgwmqrk")
    public suspend fun memberUid(`value`: Output<String>) {
        this.memberUid = value
    }

    /**
     * @param value The ID of the resource group.
     */
    @JvmName("tfoidptjaidlqmoq")
    public suspend fun resourceGroupId(`value`: Output<String>) {
        this.resourceGroupId = value
    }

    /**
     * @param value The ID of the native protection enterprise instance to be operated.
     */
    @JvmName("emqnftvuoyatjkhd")
    public suspend fun instanceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceId = mapped
    }

    /**
     * @param value The IP address.
     */
    @JvmName("xqoufadwkxmoayfx")
    public suspend fun ip(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ip = mapped
    }

    /**
     * @param value The member account id of the IP address.
     */
    @JvmName("gevtfkhekxposntt")
    public suspend fun memberUid(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.memberUid = mapped
    }

    /**
     * @param value The ID of the resource group.
     */
    @JvmName("acmculdtxsgqgmaq")
    public suspend fun resourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupId = mapped
    }

    internal fun build(): BgpIpArgs = BgpIpArgs(
        instanceId = instanceId,
        ip = ip,
        memberUid = memberUid,
        resourceGroupId = resourceGroupId,
    )
}
