@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ddos.kotlin

import com.pulumi.alicloud.ddos.kotlin.outputs.BgpPolicyContent
import com.pulumi.alicloud.ddos.kotlin.outputs.BgpPolicyContent.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [BgpPolicy].
 */
@PulumiTagMarker
public class BgpPolicyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: BgpPolicyArgs = BgpPolicyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend BgpPolicyArgsBuilder.() -> Unit) {
        val builder = BgpPolicyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): BgpPolicy {
        val builtJavaResource = com.pulumi.alicloud.ddos.BgpPolicy(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return BgpPolicy(builtJavaResource)
    }
}

/**
 * Provides a Ddos Bgp Policy resource.
 * Ddos protection policy.
 * For information about Ddos Bgp Policy and how to use it, see [What is Policy](https://www.alibabacloud.com/help/en/).
 * > **NOTE:** Available since v1.226.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf_exampleacc_bgp32594";
 * const policyName = config.get("policyName") || "example_l4_policy";
 * const _default = new alicloud.ddos.BgpPolicy("default", {
 *     content: {
 *         enableDefense: false,
 *         layer4RuleLists: [{
 *             method: "hex",
 *             match: "1",
 *             action: "1",
 *             limited: 0,
 *             conditionLists: [{
 *                 arg: "3C",
 *                 position: 1,
 *                 depth: 2,
 *             }],
 *             name: "11",
 *             priority: 10,
 *         }],
 *     },
 *     type: "l4",
 *     policyName: "tf_exampleacc_bgp32594",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf_exampleacc_bgp32594"
 * policy_name = config.get("policyName")
 * if policy_name is None:
 *     policy_name = "example_l4_policy"
 * default = alicloud.ddos.BgpPolicy("default",
 *     content={
 *         "enable_defense": False,
 *         "layer4_rule_lists": [{
 *             "method": "hex",
 *             "match": "1",
 *             "action": "1",
 *             "limited": 0,
 *             "condition_lists": [{
 *                 "arg": "3C",
 *                 "position": 1,
 *                 "depth": 2,
 *             }],
 *             "name": "11",
 *             "priority": 10,
 *         }],
 *     },
 *     type="l4",
 *     policy_name="tf_exampleacc_bgp32594")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf_exampleacc_bgp32594";
 *     var policyName = config.Get("policyName") ?? "example_l4_policy";
 *     var @default = new AliCloud.Ddos.BgpPolicy("default", new()
 *     {
 *         Content = new AliCloud.Ddos.Inputs.BgpPolicyContentArgs
 *         {
 *             EnableDefense = false,
 *             Layer4RuleLists = new[]
 *             {
 *                 new AliCloud.Ddos.Inputs.BgpPolicyContentLayer4RuleListArgs
 *                 {
 *                     Method = "hex",
 *                     Match = "1",
 *                     Action = "1",
 *                     Limited = 0,
 *                     ConditionLists = new[]
 *                     {
 *                         new AliCloud.Ddos.Inputs.BgpPolicyContentLayer4RuleListConditionListArgs
 *                         {
 *                             Arg = "3C",
 *                             Position = 1,
 *                             Depth = 2,
 *                         },
 *                     },
 *                     Name = "11",
 *                     Priority = 10,
 *                 },
 *             },
 *         },
 *         Type = "l4",
 *         PolicyName = "tf_exampleacc_bgp32594",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ddos"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf_exampleacc_bgp32594"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		policyName := "example_l4_policy"
 * 		if param := cfg.Get("policyName"); param != "" {
 * 			policyName = param
 * 		}
 * 		_, err := ddos.NewBgpPolicy(ctx, "default", &ddos.BgpPolicyArgs{
 * 			Content: &ddos.BgpPolicyContentArgs{
 * 				EnableDefense: pulumi.Bool(false),
 * 				Layer4RuleLists: ddos.BgpPolicyContentLayer4RuleListArray{
 * 					&ddos.BgpPolicyContentLayer4RuleListArgs{
 * 						Method:  pulumi.String("hex"),
 * 						Match:   pulumi.String("1"),
 * 						Action:  pulumi.String("1"),
 * 						Limited: pulumi.Int(0),
 * 						ConditionLists: ddos.BgpPolicyContentLayer4RuleListConditionListArray{
 * 							&ddos.BgpPolicyContentLayer4RuleListConditionListArgs{
 * 								Arg:      pulumi.String("3C"),
 * 								Position: pulumi.Int(1),
 * 								Depth:    pulumi.Int(2),
 * 							},
 * 						},
 * 						Name:     pulumi.String("11"),
 * 						Priority: pulumi.Int(10),
 * 					},
 * 				},
 * 			},
 * 			Type:       pulumi.String("l4"),
 * 			PolicyName: pulumi.String("tf_exampleacc_bgp32594"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.ddos.BgpPolicy;
 * import com.pulumi.alicloud.ddos.BgpPolicyArgs;
 * import com.pulumi.alicloud.ddos.inputs.BgpPolicyContentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf_exampleacc_bgp32594");
 *         final var policyName = config.get("policyName").orElse("example_l4_policy");
 *         var default_ = new BgpPolicy("default", BgpPolicyArgs.builder()
 *             .content(BgpPolicyContentArgs.builder()
 *                 .enableDefense("false")
 *                 .layer4RuleLists(BgpPolicyContentLayer4RuleListArgs.builder()
 *                     .method("hex")
 *                     .match("1")
 *                     .action("1")
 *                     .limited("0")
 *                     .conditionLists(BgpPolicyContentLayer4RuleListConditionListArgs.builder()
 *                         .arg("3C")
 *                         .position("1")
 *                         .depth("2")
 *                         .build())
 *                     .name("11")
 *                     .priority("10")
 *                     .build())
 *                 .build())
 *             .type("l4")
 *             .policyName("tf_exampleacc_bgp32594")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf_exampleacc_bgp32594
 *   policyName:
 *     type: string
 *     default: example_l4_policy
 * resources:
 *   default:
 *     type: alicloud:ddos:BgpPolicy
 *     properties:
 *       content:
 *         enableDefense: 'false'
 *         layer4RuleLists:
 *           - method: hex
 *             match: '1'
 *             action: '1'
 *             limited: '0'
 *             conditionLists:
 *               - arg: 3C
 *                 position: '1'
 *                 depth: '2'
 *             name: '11'
 *             priority: '10'
 *       type: l4
 *       policyName: tf_exampleacc_bgp32594
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Ddos Bgp Policy can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:ddos/bgpPolicy:BgpPolicy example <id>
 * ```
 */
public class BgpPolicy internal constructor(
    override val javaResource: com.pulumi.alicloud.ddos.BgpPolicy,
) : KotlinCustomResource(javaResource, BgpPolicyMapper) {
    /**
     * Configuration Content See `content` below.
     */
    public val content: Output<BgpPolicyContent>
        get() = javaResource.content().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * The name of the resource
     */
    public val policyName: Output<String>
        get() = javaResource.policyName().applyValue({ args0 -> args0 })

    /**
     * Type
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object BgpPolicyMapper : ResourceMapper<BgpPolicy> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.ddos.BgpPolicy::class == javaResource::class

    override fun map(javaResource: Resource): BgpPolicy = BgpPolicy(
        javaResource as
            com.pulumi.alicloud.ddos.BgpPolicy,
    )
}

/**
 * @see [BgpPolicy].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [BgpPolicy].
 */
public suspend fun bgpPolicy(name: String, block: suspend BgpPolicyResourceBuilder.() -> Unit): BgpPolicy {
    val builder = BgpPolicyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [BgpPolicy].
 * @param name The _unique_ name of the resulting resource.
 */
public fun bgpPolicy(name: String): BgpPolicy {
    val builder = BgpPolicyResourceBuilder()
    builder.name(name)
    return builder.build()
}
