@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ddos.kotlin

import com.pulumi.alicloud.ddos.DdosBgpInstanceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Anti-DDoS Advanced instance resource. "Ddosbgp" is the short term of this product.
 * > **NOTE:** The endpoint of bssopenapi used only support "business.aliyuncs.com" at present.
 * > **NOTE:** Available since v1.183.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf-example";
 * const instance = new alicloud.ddos.DdosBgpInstance("instance", {
 *     name: name,
 *     baseBandwidth: 20,
 *     bandwidth: -1,
 *     ipCount: 100,
 *     ipType: "IPv4",
 *     normalBandwidth: 100,
 *     type: "Enterprise",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf-example"
 * instance = alicloud.ddos.DdosBgpInstance("instance",
 *     name=name,
 *     base_bandwidth=20,
 *     bandwidth=-1,
 *     ip_count=100,
 *     ip_type="IPv4",
 *     normal_bandwidth=100,
 *     type="Enterprise")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf-example";
 *     var instance = new AliCloud.Ddos.DdosBgpInstance("instance", new()
 *     {
 *         Name = name,
 *         BaseBandwidth = 20,
 *         Bandwidth = -1,
 *         IpCount = 100,
 *         IpType = "IPv4",
 *         NormalBandwidth = 100,
 *         Type = "Enterprise",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ddos"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := ddos.NewDdosBgpInstance(ctx, "instance", &ddos.DdosBgpInstanceArgs{
 * 			Name:            pulumi.String(name),
 * 			BaseBandwidth:   pulumi.Int(20),
 * 			Bandwidth:       int(-1),
 * 			IpCount:         pulumi.Int(100),
 * 			IpType:          pulumi.String("IPv4"),
 * 			NormalBandwidth: pulumi.Int(100),
 * 			Type:            pulumi.String("Enterprise"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf-example
 * resources:
 *   instance:
 *     type: alicloud:ddos:DdosBgpInstance
 *     properties:
 *       name: ${name}
 *       baseBandwidth: 20
 *       bandwidth: -1
 *       ipCount: 100
 *       ipType: IPv4
 *       normalBandwidth: 100
 *       type: Enterprise
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Ddosbgp instance can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:ddos/ddosBgpInstance:DdosBgpInstance example ddosbgp-abc123456
 * ```
 * @property bandwidth Elastic defend bandwidth of the instance. This value must be larger than the base defend bandwidth. Valid values: 51,91,101,201,301. The unit is Gbps.
 * @property baseBandwidth Base defend bandwidth of the instance. Valid values: 20. The unit is Gbps. Default to `20`.
 * @property ipCount IP count of the instance. Valid values: 100.
 * @property ipType IP version of the instance. Valid values: IPv4,IPv6.
 * @property name Name of the instance. This name can have a string of 1 to 63 characters.
 * @property normalBandwidth Normal defend bandwidth of the instance. The unit is Gbps.
 * @property period The duration that you will buy Ddosbgp instance (in month). Valid values: [1~9], 12, 24, 36. Default to 12. At present, the provider does not support modify "period".
 * @property type Type of the instance. Valid values: `Enterprise`, `Professional`. Default to `Enterprise`
 */
public data class DdosBgpInstanceArgs(
    public val bandwidth: Output<Int>? = null,
    public val baseBandwidth: Output<Int>? = null,
    public val ipCount: Output<Int>? = null,
    public val ipType: Output<String>? = null,
    public val name: Output<String>? = null,
    public val normalBandwidth: Output<Int>? = null,
    public val period: Output<Int>? = null,
    public val type: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ddos.DdosBgpInstanceArgs> {
    override fun toJava(): com.pulumi.alicloud.ddos.DdosBgpInstanceArgs =
        com.pulumi.alicloud.ddos.DdosBgpInstanceArgs.builder()
            .bandwidth(bandwidth?.applyValue({ args0 -> args0 }))
            .baseBandwidth(baseBandwidth?.applyValue({ args0 -> args0 }))
            .ipCount(ipCount?.applyValue({ args0 -> args0 }))
            .ipType(ipType?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .normalBandwidth(normalBandwidth?.applyValue({ args0 -> args0 }))
            .period(period?.applyValue({ args0 -> args0 }))
            .type(type?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DdosBgpInstanceArgs].
 */
@PulumiTagMarker
public class DdosBgpInstanceArgsBuilder internal constructor() {
    private var bandwidth: Output<Int>? = null

    private var baseBandwidth: Output<Int>? = null

    private var ipCount: Output<Int>? = null

    private var ipType: Output<String>? = null

    private var name: Output<String>? = null

    private var normalBandwidth: Output<Int>? = null

    private var period: Output<Int>? = null

    private var type: Output<String>? = null

    /**
     * @param value Elastic defend bandwidth of the instance. This value must be larger than the base defend bandwidth. Valid values: 51,91,101,201,301. The unit is Gbps.
     */
    @JvmName("snjnhuxudcxttadd")
    public suspend fun bandwidth(`value`: Output<Int>) {
        this.bandwidth = value
    }

    /**
     * @param value Base defend bandwidth of the instance. Valid values: 20. The unit is Gbps. Default to `20`.
     */
    @JvmName("tcxacywynyhwwoii")
    public suspend fun baseBandwidth(`value`: Output<Int>) {
        this.baseBandwidth = value
    }

    /**
     * @param value IP count of the instance. Valid values: 100.
     */
    @JvmName("icrlamcocgtnusxh")
    public suspend fun ipCount(`value`: Output<Int>) {
        this.ipCount = value
    }

    /**
     * @param value IP version of the instance. Valid values: IPv4,IPv6.
     */
    @JvmName("ostglwdmgokdhdgi")
    public suspend fun ipType(`value`: Output<String>) {
        this.ipType = value
    }

    /**
     * @param value Name of the instance. This name can have a string of 1 to 63 characters.
     */
    @JvmName("tltcbhrdvdlwdvtl")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Normal defend bandwidth of the instance. The unit is Gbps.
     */
    @JvmName("ckgxusovsawfpame")
    public suspend fun normalBandwidth(`value`: Output<Int>) {
        this.normalBandwidth = value
    }

    /**
     * @param value The duration that you will buy Ddosbgp instance (in month). Valid values: [1~9], 12, 24, 36. Default to 12. At present, the provider does not support modify "period".
     */
    @JvmName("ijdvyeqtcalmcsdv")
    public suspend fun period(`value`: Output<Int>) {
        this.period = value
    }

    /**
     * @param value Type of the instance. Valid values: `Enterprise`, `Professional`. Default to `Enterprise`
     */
    @JvmName("chksvwdrqmxlewqd")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Elastic defend bandwidth of the instance. This value must be larger than the base defend bandwidth. Valid values: 51,91,101,201,301. The unit is Gbps.
     */
    @JvmName("ddswuyicjtyydsip")
    public suspend fun bandwidth(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bandwidth = mapped
    }

    /**
     * @param value Base defend bandwidth of the instance. Valid values: 20. The unit is Gbps. Default to `20`.
     */
    @JvmName("sesxiylkklpruqml")
    public suspend fun baseBandwidth(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.baseBandwidth = mapped
    }

    /**
     * @param value IP count of the instance. Valid values: 100.
     */
    @JvmName("rwrkcefdihfuomgd")
    public suspend fun ipCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipCount = mapped
    }

    /**
     * @param value IP version of the instance. Valid values: IPv4,IPv6.
     */
    @JvmName("wtiorttoagjatnre")
    public suspend fun ipType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipType = mapped
    }

    /**
     * @param value Name of the instance. This name can have a string of 1 to 63 characters.
     */
    @JvmName("jasvhkbrrbirpymy")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Normal defend bandwidth of the instance. The unit is Gbps.
     */
    @JvmName("lubbcswcbgnabdle")
    public suspend fun normalBandwidth(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.normalBandwidth = mapped
    }

    /**
     * @param value The duration that you will buy Ddosbgp instance (in month). Valid values: [1~9], 12, 24, 36. Default to 12. At present, the provider does not support modify "period".
     */
    @JvmName("vwxguvbhedyipuhm")
    public suspend fun period(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.period = mapped
    }

    /**
     * @param value Type of the instance. Valid values: `Enterprise`, `Professional`. Default to `Enterprise`
     */
    @JvmName("abrkpoxwwikpoetc")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): DdosBgpInstanceArgs = DdosBgpInstanceArgs(
        bandwidth = bandwidth,
        baseBandwidth = baseBandwidth,
        ipCount = ipCount,
        ipType = ipType,
        name = name,
        normalBandwidth = normalBandwidth,
        period = period,
        type = type,
    )
}
