@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ddos.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [DdosCooInstance].
 */
@PulumiTagMarker
public class DdosCooInstanceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DdosCooInstanceArgs = DdosCooInstanceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DdosCooInstanceArgsBuilder.() -> Unit) {
        val builder = DdosCooInstanceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): DdosCooInstance {
        val builtJavaResource = com.pulumi.alicloud.ddos.DdosCooInstance(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return DdosCooInstance(builtJavaResource)
    }
}

/**
 * Provides a BGP-line Anti-DDoS Pro(DdosCoo) Instance resource.
 * For information about BGP-line Anti-DDoS Pro(DdosCoo) Instance and how to use it, see [What is Anti-DDoS Pro Instance](https://www.alibabacloud.com/help/en/ddos-protection/latest/create-an-anti-ddos-pro-or-anti-ddos-premium-instance-by-calling-an-api-operation).
 * > **NOTE:** Available since v1.37.0.
 * > **NOTE:** The endpoint of bssopenapi used only support "business.aliyuncs.com" at present.
 * > **NOTE:** From version 1.214.0, if `product_type` is set to `ddoscoo` or `ddoscoo_intl`, the provider `region` should be set to `cn-hangzhou`, and if `product_type` is set to `ddosDip`, the provider `region` should be set to `ap-southeast-1`.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf-example";
 * const _default = new alicloud.ddos.DdosCooInstance("default", {
 *     name: name,
 *     baseBandwidth: "30",
 *     bandwidth: "30",
 *     serviceBandwidth: "100",
 *     portCount: "50",
 *     domainCount: "50",
 *     productType: "ddoscoo",
 *     period: 1,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf-example"
 * default = alicloud.ddos.DdosCooInstance("default",
 *     name=name,
 *     base_bandwidth="30",
 *     bandwidth="30",
 *     service_bandwidth="100",
 *     port_count="50",
 *     domain_count="50",
 *     product_type="ddoscoo",
 *     period=1)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf-example";
 *     var @default = new AliCloud.Ddos.DdosCooInstance("default", new()
 *     {
 *         Name = name,
 *         BaseBandwidth = "30",
 *         Bandwidth = "30",
 *         ServiceBandwidth = "100",
 *         PortCount = "50",
 *         DomainCount = "50",
 *         ProductType = "ddoscoo",
 *         Period = 1,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ddos"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := ddos.NewDdosCooInstance(ctx, "default", &ddos.DdosCooInstanceArgs{
 * 			Name:             pulumi.String(name),
 * 			BaseBandwidth:    pulumi.String("30"),
 * 			Bandwidth:        pulumi.String("30"),
 * 			ServiceBandwidth: pulumi.String("100"),
 * 			PortCount:        pulumi.String("50"),
 * 			DomainCount:      pulumi.String("50"),
 * 			ProductType:      pulumi.String("ddoscoo"),
 * 			Period:           pulumi.Int(1),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.ddos.DdosCooInstance;
 * import com.pulumi.alicloud.ddos.DdosCooInstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf-example");
 *         var default_ = new DdosCooInstance("default", DdosCooInstanceArgs.builder()
 *             .name(name)
 *             .baseBandwidth("30")
 *             .bandwidth("30")
 *             .serviceBandwidth("100")
 *             .portCount("50")
 *             .domainCount("50")
 *             .productType("ddoscoo")
 *             .period("1")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf-example
 * resources:
 *   default:
 *     type: alicloud:ddos:DdosCooInstance
 *     properties:
 *       name: ${name}
 *       baseBandwidth: '30'
 *       bandwidth: '30'
 *       serviceBandwidth: '100'
 *       portCount: '50'
 *       domainCount: '50'
 *       productType: ddoscoo
 *       period: '1'
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * DdosCoo instance can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:ddos/ddosCooInstance:DdosCooInstance example ddoscoo-cn-123456
 * ```
 */
public class DdosCooInstance internal constructor(
    override val javaResource: com.pulumi.alicloud.ddos.DdosCooInstance,
) : KotlinCustomResource(javaResource, DdosCooInstanceMapper) {
    /**
     * The IP version of the IP address. Default value: `Ipv4`. Valid values: `Ipv4`, `Ipv6`. **NOTE:** `address_type` is valid only when `product_type` is set to `ddoscoo` or `ddoscoo_intl`.
     */
    public val addressType: Output<String>
        get() = javaResource.addressType().applyValue({ args0 -> args0 })

    /**
     * Elastic defend bandwidth of the instance. This value must be larger than the base defend bandwidth. Valid values: `30`, `60`, `100`, `300`, `400`, `500`, `600`. The unit is Gbps. Only support upgrade. **NOTE:** `bandwidth` is valid only when `product_type` is set to `ddoscoo` or `ddoscoo_intl`.
     */
    public val bandwidth: Output<String>
        get() = javaResource.bandwidth().applyValue({ args0 -> args0 })

    /**
     * The mitigation plan of the instance. Valid values:
     */
    public val bandwidthMode: Output<String>?
        get() = javaResource.bandwidthMode().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Base defend bandwidth of the instance. Valid values: `30`, `60`, `100`, `300`, `400`, `500`, `600`. The unit is Gbps. Only support upgrade. **NOTE:** `base_bandwidth` is valid only when `product_type` is set to `ddoscoo` or `ddoscoo_intl`.
     */
    public val baseBandwidth: Output<String>
        get() = javaResource.baseBandwidth().applyValue({ args0 -> args0 })

    /**
     * Domain retransmission rule count of the instance. At least 50. Increase 5 per step, such as 55, 60, 65. Only support upgrade.
     */
    public val domainCount: Output<String>
        get() = javaResource.domainCount().applyValue({ args0 -> args0 })

    /**
     * The mitigation plan of the instance. Default value: `coop`. Valid values:
     */
    public val editionSale: Output<String>
        get() = javaResource.editionSale().applyValue({ args0 -> args0 })

    /**
     * The function plan of the instance. Valid values:
     */
    public val functionVersion: Output<String>
        get() = javaResource.functionVersion().applyValue({ args0 -> args0 })

    /**
     * (Available since v1.212.0) The IP address of the instance.
     */
    public val ip: Output<String>
        get() = javaResource.ip().applyValue({ args0 -> args0 })

    /**
     * Name of the instance. This name can have a string of `1` to `64` characters.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The clean bandwidth provided by the instance. **NOTE:** `normal_bandwidth` is valid only when `product_type` is set to `ddosDip`.
     */
    public val normalBandwidth: Output<String>
        get() = javaResource.normalBandwidth().applyValue({ args0 -> args0 })

    /**
     * The clean QPS provided by the instance. **NOTE:** `normal_qps` is valid only when `product_type` is set to `ddosDip`.
     */
    public val normalQps: Output<String>
        get() = javaResource.normalQps().applyValue({ args0 -> args0 })

    /**
     * The duration that you will buy DdosCoo instance (in month). Valid values: [1~9], `12`, `24`, `36`. Default value: `1`. At present, the provider does not support modify `period`.
     */
    public val period: Output<Int>?
        get() = javaResource.period().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Port retransmission rule count of the instance. At least 50. Increase 5 per step, such as 55, 60, 65. Only support upgrade.
     */
    public val portCount: Output<String>
        get() = javaResource.portCount().applyValue({ args0 -> args0 })

    /**
     * The mitigation plan of the instance. Valid values:
     */
    public val productPlan: Output<String>
        get() = javaResource.productPlan().applyValue({ args0 -> args0 })

    /**
     * The product type for purchasing DDOSCOO instances used to differ different account type. Default value: `ddoscoo`. Valid values:
     */
    public val productType: Output<String>?
        get() = javaResource.productType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Business bandwidth of the instance. At leaset 100. Increased 100 per step, such as 100, 200, 300. The unit is Mbps. Only support upgrade. **NOTE:** `service_bandwidth` is valid only when `product_type` is set to `ddoscoo` or `ddoscoo_intl`.
     */
    public val serviceBandwidth: Output<String>
        get() = javaResource.serviceBandwidth().applyValue({ args0 -> args0 })
}

public object DdosCooInstanceMapper : ResourceMapper<DdosCooInstance> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.ddos.DdosCooInstance::class == javaResource::class

    override fun map(javaResource: Resource): DdosCooInstance = DdosCooInstance(
        javaResource as
            com.pulumi.alicloud.ddos.DdosCooInstance,
    )
}

/**
 * @see [DdosCooInstance].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [DdosCooInstance].
 */
public suspend fun ddosCooInstance(
    name: String,
    block: suspend DdosCooInstanceResourceBuilder.() -> Unit,
): DdosCooInstance {
    val builder = DdosCooInstanceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [DdosCooInstance].
 * @param name The _unique_ name of the resulting resource.
 */
public fun ddosCooInstance(name: String): DdosCooInstance {
    val builder = DdosCooInstanceResourceBuilder()
    builder.name(name)
    return builder.build()
}
