@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ddos.kotlin

import com.pulumi.alicloud.ddos.DdosCooInstanceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a BGP-line Anti-DDoS Pro(DdosCoo) Instance resource.
 * For information about BGP-line Anti-DDoS Pro(DdosCoo) Instance and how to use it, see [What is Anti-DDoS Pro Instance](https://www.alibabacloud.com/help/en/ddos-protection/latest/create-an-anti-ddos-pro-or-anti-ddos-premium-instance-by-calling-an-api-operation).
 * > **NOTE:** Available since v1.37.0.
 * > **NOTE:** The endpoint of bssopenapi used only support "business.aliyuncs.com" at present.
 * > **NOTE:** From version 1.214.0, if `product_type` is set to `ddoscoo` or `ddoscoo_intl`, the provider `region` should be set to `cn-hangzhou`, and if `product_type` is set to `ddosDip`, the provider `region` should be set to `ap-southeast-1`.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf-example";
 * const _default = new alicloud.ddos.DdosCooInstance("default", {
 *     name: name,
 *     baseBandwidth: "30",
 *     bandwidth: "30",
 *     serviceBandwidth: "100",
 *     portCount: "50",
 *     domainCount: "50",
 *     productType: "ddoscoo",
 *     period: 1,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf-example"
 * default = alicloud.ddos.DdosCooInstance("default",
 *     name=name,
 *     base_bandwidth="30",
 *     bandwidth="30",
 *     service_bandwidth="100",
 *     port_count="50",
 *     domain_count="50",
 *     product_type="ddoscoo",
 *     period=1)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf-example";
 *     var @default = new AliCloud.Ddos.DdosCooInstance("default", new()
 *     {
 *         Name = name,
 *         BaseBandwidth = "30",
 *         Bandwidth = "30",
 *         ServiceBandwidth = "100",
 *         PortCount = "50",
 *         DomainCount = "50",
 *         ProductType = "ddoscoo",
 *         Period = 1,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ddos"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := ddos.NewDdosCooInstance(ctx, "default", &ddos.DdosCooInstanceArgs{
 * 			Name:             pulumi.String(name),
 * 			BaseBandwidth:    pulumi.String("30"),
 * 			Bandwidth:        pulumi.String("30"),
 * 			ServiceBandwidth: pulumi.String("100"),
 * 			PortCount:        pulumi.String("50"),
 * 			DomainCount:      pulumi.String("50"),
 * 			ProductType:      pulumi.String("ddoscoo"),
 * 			Period:           pulumi.Int(1),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.ddos.DdosCooInstance;
 * import com.pulumi.alicloud.ddos.DdosCooInstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf-example");
 *         var default_ = new DdosCooInstance("default", DdosCooInstanceArgs.builder()
 *             .name(name)
 *             .baseBandwidth("30")
 *             .bandwidth("30")
 *             .serviceBandwidth("100")
 *             .portCount("50")
 *             .domainCount("50")
 *             .productType("ddoscoo")
 *             .period("1")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf-example
 * resources:
 *   default:
 *     type: alicloud:ddos:DdosCooInstance
 *     properties:
 *       name: ${name}
 *       baseBandwidth: '30'
 *       bandwidth: '30'
 *       serviceBandwidth: '100'
 *       portCount: '50'
 *       domainCount: '50'
 *       productType: ddoscoo
 *       period: '1'
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * DdosCoo instance can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:ddos/ddosCooInstance:DdosCooInstance example ddoscoo-cn-123456
 * ```
 * @property addressType The IP version of the IP address. Default value: `Ipv4`. Valid values: `Ipv4`, `Ipv6`. **NOTE:** `address_type` is valid only when `product_type` is set to `ddoscoo` or `ddoscoo_intl`.
 * @property bandwidth Elastic defend bandwidth of the instance. This value must be larger than the base defend bandwidth. Valid values: `30`, `60`, `100`, `300`, `400`, `500`, `600`. The unit is Gbps. Only support upgrade. **NOTE:** `bandwidth` is valid only when `product_type` is set to `ddoscoo` or `ddoscoo_intl`.
 * @property bandwidthMode The mitigation plan of the instance. Valid values:
 * @property baseBandwidth Base defend bandwidth of the instance. Valid values: `30`, `60`, `100`, `300`, `400`, `500`, `600`. The unit is Gbps. Only support upgrade. **NOTE:** `base_bandwidth` is valid only when `product_type` is set to `ddoscoo` or `ddoscoo_intl`.
 * @property domainCount Domain retransmission rule count of the instance. At least 50. Increase 5 per step, such as 55, 60, 65. Only support upgrade.
 * @property editionSale The mitigation plan of the instance. Default value: `coop`. Valid values:
 * @property functionVersion The function plan of the instance. Valid values:
 * @property name Name of the instance. This name can have a string of `1` to `64` characters.
 * @property normalBandwidth The clean bandwidth provided by the instance. **NOTE:** `normal_bandwidth` is valid only when `product_type` is set to `ddosDip`.
 * @property normalQps The clean QPS provided by the instance. **NOTE:** `normal_qps` is valid only when `product_type` is set to `ddosDip`.
 * @property period The duration that you will buy DdosCoo instance (in month). Valid values: [1~9], `12`, `24`, `36`. Default value: `1`. At present, the provider does not support modify `period`.
 * @property portCount Port retransmission rule count of the instance. At least 50. Increase 5 per step, such as 55, 60, 65. Only support upgrade.
 * @property productPlan The mitigation plan of the instance. Valid values:
 * @property productType The product type for purchasing DDOSCOO instances used to differ different account type. Default value: `ddoscoo`. Valid values:
 * @property serviceBandwidth Business bandwidth of the instance. At leaset 100. Increased 100 per step, such as 100, 200, 300. The unit is Mbps. Only support upgrade. **NOTE:** `service_bandwidth` is valid only when `product_type` is set to `ddoscoo` or `ddoscoo_intl`.
 */
public data class DdosCooInstanceArgs(
    public val addressType: Output<String>? = null,
    public val bandwidth: Output<String>? = null,
    public val bandwidthMode: Output<String>? = null,
    public val baseBandwidth: Output<String>? = null,
    public val domainCount: Output<String>? = null,
    public val editionSale: Output<String>? = null,
    public val functionVersion: Output<String>? = null,
    public val name: Output<String>? = null,
    public val normalBandwidth: Output<String>? = null,
    public val normalQps: Output<String>? = null,
    public val period: Output<Int>? = null,
    public val portCount: Output<String>? = null,
    public val productPlan: Output<String>? = null,
    public val productType: Output<String>? = null,
    public val serviceBandwidth: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ddos.DdosCooInstanceArgs> {
    override fun toJava(): com.pulumi.alicloud.ddos.DdosCooInstanceArgs =
        com.pulumi.alicloud.ddos.DdosCooInstanceArgs.builder()
            .addressType(addressType?.applyValue({ args0 -> args0 }))
            .bandwidth(bandwidth?.applyValue({ args0 -> args0 }))
            .bandwidthMode(bandwidthMode?.applyValue({ args0 -> args0 }))
            .baseBandwidth(baseBandwidth?.applyValue({ args0 -> args0 }))
            .domainCount(domainCount?.applyValue({ args0 -> args0 }))
            .editionSale(editionSale?.applyValue({ args0 -> args0 }))
            .functionVersion(functionVersion?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .normalBandwidth(normalBandwidth?.applyValue({ args0 -> args0 }))
            .normalQps(normalQps?.applyValue({ args0 -> args0 }))
            .period(period?.applyValue({ args0 -> args0 }))
            .portCount(portCount?.applyValue({ args0 -> args0 }))
            .productPlan(productPlan?.applyValue({ args0 -> args0 }))
            .productType(productType?.applyValue({ args0 -> args0 }))
            .serviceBandwidth(serviceBandwidth?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DdosCooInstanceArgs].
 */
@PulumiTagMarker
public class DdosCooInstanceArgsBuilder internal constructor() {
    private var addressType: Output<String>? = null

    private var bandwidth: Output<String>? = null

    private var bandwidthMode: Output<String>? = null

    private var baseBandwidth: Output<String>? = null

    private var domainCount: Output<String>? = null

    private var editionSale: Output<String>? = null

    private var functionVersion: Output<String>? = null

    private var name: Output<String>? = null

    private var normalBandwidth: Output<String>? = null

    private var normalQps: Output<String>? = null

    private var period: Output<Int>? = null

    private var portCount: Output<String>? = null

    private var productPlan: Output<String>? = null

    private var productType: Output<String>? = null

    private var serviceBandwidth: Output<String>? = null

    /**
     * @param value The IP version of the IP address. Default value: `Ipv4`. Valid values: `Ipv4`, `Ipv6`. **NOTE:** `address_type` is valid only when `product_type` is set to `ddoscoo` or `ddoscoo_intl`.
     */
    @JvmName("nkltplpihgumbsls")
    public suspend fun addressType(`value`: Output<String>) {
        this.addressType = value
    }

    /**
     * @param value Elastic defend bandwidth of the instance. This value must be larger than the base defend bandwidth. Valid values: `30`, `60`, `100`, `300`, `400`, `500`, `600`. The unit is Gbps. Only support upgrade. **NOTE:** `bandwidth` is valid only when `product_type` is set to `ddoscoo` or `ddoscoo_intl`.
     */
    @JvmName("kuvfnkaidgpkoocp")
    public suspend fun bandwidth(`value`: Output<String>) {
        this.bandwidth = value
    }

    /**
     * @param value The mitigation plan of the instance. Valid values:
     */
    @JvmName("auiiluuhtjiolesy")
    public suspend fun bandwidthMode(`value`: Output<String>) {
        this.bandwidthMode = value
    }

    /**
     * @param value Base defend bandwidth of the instance. Valid values: `30`, `60`, `100`, `300`, `400`, `500`, `600`. The unit is Gbps. Only support upgrade. **NOTE:** `base_bandwidth` is valid only when `product_type` is set to `ddoscoo` or `ddoscoo_intl`.
     */
    @JvmName("anpolspgxwgwmskw")
    public suspend fun baseBandwidth(`value`: Output<String>) {
        this.baseBandwidth = value
    }

    /**
     * @param value Domain retransmission rule count of the instance. At least 50. Increase 5 per step, such as 55, 60, 65. Only support upgrade.
     */
    @JvmName("hqmpfxipwlelwioy")
    public suspend fun domainCount(`value`: Output<String>) {
        this.domainCount = value
    }

    /**
     * @param value The mitigation plan of the instance. Default value: `coop`. Valid values:
     */
    @JvmName("gxvjvovulhuyxbdi")
    public suspend fun editionSale(`value`: Output<String>) {
        this.editionSale = value
    }

    /**
     * @param value The function plan of the instance. Valid values:
     */
    @JvmName("hkshprebspvovjet")
    public suspend fun functionVersion(`value`: Output<String>) {
        this.functionVersion = value
    }

    /**
     * @param value Name of the instance. This name can have a string of `1` to `64` characters.
     */
    @JvmName("gpkfxsoxnxinfdyb")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The clean bandwidth provided by the instance. **NOTE:** `normal_bandwidth` is valid only when `product_type` is set to `ddosDip`.
     */
    @JvmName("fuskmiatrssuxxwb")
    public suspend fun normalBandwidth(`value`: Output<String>) {
        this.normalBandwidth = value
    }

    /**
     * @param value The clean QPS provided by the instance. **NOTE:** `normal_qps` is valid only when `product_type` is set to `ddosDip`.
     */
    @JvmName("vyckbvlacstholvj")
    public suspend fun normalQps(`value`: Output<String>) {
        this.normalQps = value
    }

    /**
     * @param value The duration that you will buy DdosCoo instance (in month). Valid values: [1~9], `12`, `24`, `36`. Default value: `1`. At present, the provider does not support modify `period`.
     */
    @JvmName("bwlxvwnawqtsnkwp")
    public suspend fun period(`value`: Output<Int>) {
        this.period = value
    }

    /**
     * @param value Port retransmission rule count of the instance. At least 50. Increase 5 per step, such as 55, 60, 65. Only support upgrade.
     */
    @JvmName("ykiufsxskbpkosqp")
    public suspend fun portCount(`value`: Output<String>) {
        this.portCount = value
    }

    /**
     * @param value The mitigation plan of the instance. Valid values:
     */
    @JvmName("egwafwdvvjdbrtjq")
    public suspend fun productPlan(`value`: Output<String>) {
        this.productPlan = value
    }

    /**
     * @param value The product type for purchasing DDOSCOO instances used to differ different account type. Default value: `ddoscoo`. Valid values:
     */
    @JvmName("deglwigjfoesvcxw")
    public suspend fun productType(`value`: Output<String>) {
        this.productType = value
    }

    /**
     * @param value Business bandwidth of the instance. At leaset 100. Increased 100 per step, such as 100, 200, 300. The unit is Mbps. Only support upgrade. **NOTE:** `service_bandwidth` is valid only when `product_type` is set to `ddoscoo` or `ddoscoo_intl`.
     */
    @JvmName("namujehabeaanxto")
    public suspend fun serviceBandwidth(`value`: Output<String>) {
        this.serviceBandwidth = value
    }

    /**
     * @param value The IP version of the IP address. Default value: `Ipv4`. Valid values: `Ipv4`, `Ipv6`. **NOTE:** `address_type` is valid only when `product_type` is set to `ddoscoo` or `ddoscoo_intl`.
     */
    @JvmName("vnxdbvadgdvmhafh")
    public suspend fun addressType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.addressType = mapped
    }

    /**
     * @param value Elastic defend bandwidth of the instance. This value must be larger than the base defend bandwidth. Valid values: `30`, `60`, `100`, `300`, `400`, `500`, `600`. The unit is Gbps. Only support upgrade. **NOTE:** `bandwidth` is valid only when `product_type` is set to `ddoscoo` or `ddoscoo_intl`.
     */
    @JvmName("vxcmymfbwgxjfaix")
    public suspend fun bandwidth(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bandwidth = mapped
    }

    /**
     * @param value The mitigation plan of the instance. Valid values:
     */
    @JvmName("domyeqaseytqihtw")
    public suspend fun bandwidthMode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bandwidthMode = mapped
    }

    /**
     * @param value Base defend bandwidth of the instance. Valid values: `30`, `60`, `100`, `300`, `400`, `500`, `600`. The unit is Gbps. Only support upgrade. **NOTE:** `base_bandwidth` is valid only when `product_type` is set to `ddoscoo` or `ddoscoo_intl`.
     */
    @JvmName("xsqksimpdstdowak")
    public suspend fun baseBandwidth(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.baseBandwidth = mapped
    }

    /**
     * @param value Domain retransmission rule count of the instance. At least 50. Increase 5 per step, such as 55, 60, 65. Only support upgrade.
     */
    @JvmName("qqwbldqmpdwewcyn")
    public suspend fun domainCount(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.domainCount = mapped
    }

    /**
     * @param value The mitigation plan of the instance. Default value: `coop`. Valid values:
     */
    @JvmName("prfgkgwadgbhpmbk")
    public suspend fun editionSale(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.editionSale = mapped
    }

    /**
     * @param value The function plan of the instance. Valid values:
     */
    @JvmName("rptqnudkiyyrykql")
    public suspend fun functionVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.functionVersion = mapped
    }

    /**
     * @param value Name of the instance. This name can have a string of `1` to `64` characters.
     */
    @JvmName("hluojoymggwrfxch")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The clean bandwidth provided by the instance. **NOTE:** `normal_bandwidth` is valid only when `product_type` is set to `ddosDip`.
     */
    @JvmName("yppdinipmqqfoaul")
    public suspend fun normalBandwidth(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.normalBandwidth = mapped
    }

    /**
     * @param value The clean QPS provided by the instance. **NOTE:** `normal_qps` is valid only when `product_type` is set to `ddosDip`.
     */
    @JvmName("qavgkieqmixcuuar")
    public suspend fun normalQps(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.normalQps = mapped
    }

    /**
     * @param value The duration that you will buy DdosCoo instance (in month). Valid values: [1~9], `12`, `24`, `36`. Default value: `1`. At present, the provider does not support modify `period`.
     */
    @JvmName("ujmaaoajnsqtyoak")
    public suspend fun period(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.period = mapped
    }

    /**
     * @param value Port retransmission rule count of the instance. At least 50. Increase 5 per step, such as 55, 60, 65. Only support upgrade.
     */
    @JvmName("tggtvakaruweclik")
    public suspend fun portCount(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.portCount = mapped
    }

    /**
     * @param value The mitigation plan of the instance. Valid values:
     */
    @JvmName("osarluxiltynsxri")
    public suspend fun productPlan(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.productPlan = mapped
    }

    /**
     * @param value The product type for purchasing DDOSCOO instances used to differ different account type. Default value: `ddoscoo`. Valid values:
     */
    @JvmName("ifdahltjteexkvum")
    public suspend fun productType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.productType = mapped
    }

    /**
     * @param value Business bandwidth of the instance. At leaset 100. Increased 100 per step, such as 100, 200, 300. The unit is Mbps. Only support upgrade. **NOTE:** `service_bandwidth` is valid only when `product_type` is set to `ddoscoo` or `ddoscoo_intl`.
     */
    @JvmName("swnfqmbjsmgnbtqm")
    public suspend fun serviceBandwidth(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceBandwidth = mapped
    }

    internal fun build(): DdosCooInstanceArgs = DdosCooInstanceArgs(
        addressType = addressType,
        bandwidth = bandwidth,
        bandwidthMode = bandwidthMode,
        baseBandwidth = baseBandwidth,
        domainCount = domainCount,
        editionSale = editionSale,
        functionVersion = functionVersion,
        name = name,
        normalBandwidth = normalBandwidth,
        normalQps = normalQps,
        period = period,
        portCount = portCount,
        productPlan = productPlan,
        productType = productType,
        serviceBandwidth = serviceBandwidth,
    )
}
