@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ddos.kotlin

import com.pulumi.alicloud.ddos.DdosFunctions.getDdosBgpInstancesPlain
import com.pulumi.alicloud.ddos.DdosFunctions.getDdosBgpIpsPlain
import com.pulumi.alicloud.ddos.DdosFunctions.getDdosCooDomainResourcesPlain
import com.pulumi.alicloud.ddos.DdosFunctions.getDdosCooInstancesPlain
import com.pulumi.alicloud.ddos.DdosFunctions.getDdosCooPortsPlain
import com.pulumi.alicloud.ddos.kotlin.inputs.GetDdosBgpInstancesPlainArgs
import com.pulumi.alicloud.ddos.kotlin.inputs.GetDdosBgpInstancesPlainArgsBuilder
import com.pulumi.alicloud.ddos.kotlin.inputs.GetDdosBgpIpsPlainArgs
import com.pulumi.alicloud.ddos.kotlin.inputs.GetDdosBgpIpsPlainArgsBuilder
import com.pulumi.alicloud.ddos.kotlin.inputs.GetDdosCooDomainResourcesPlainArgs
import com.pulumi.alicloud.ddos.kotlin.inputs.GetDdosCooDomainResourcesPlainArgsBuilder
import com.pulumi.alicloud.ddos.kotlin.inputs.GetDdosCooInstancesPlainArgs
import com.pulumi.alicloud.ddos.kotlin.inputs.GetDdosCooInstancesPlainArgsBuilder
import com.pulumi.alicloud.ddos.kotlin.inputs.GetDdosCooPortsPlainArgs
import com.pulumi.alicloud.ddos.kotlin.inputs.GetDdosCooPortsPlainArgsBuilder
import com.pulumi.alicloud.ddos.kotlin.outputs.GetDdosBgpInstancesResult
import com.pulumi.alicloud.ddos.kotlin.outputs.GetDdosBgpIpsResult
import com.pulumi.alicloud.ddos.kotlin.outputs.GetDdosCooDomainResourcesResult
import com.pulumi.alicloud.ddos.kotlin.outputs.GetDdosCooInstancesResult
import com.pulumi.alicloud.ddos.kotlin.outputs.GetDdosCooPortsResult
import kotlinx.coroutines.future.await
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.alicloud.ddos.kotlin.outputs.GetDdosBgpInstancesResult.Companion.toKotlin as getDdosBgpInstancesResultToKotlin
import com.pulumi.alicloud.ddos.kotlin.outputs.GetDdosBgpIpsResult.Companion.toKotlin as getDdosBgpIpsResultToKotlin
import com.pulumi.alicloud.ddos.kotlin.outputs.GetDdosCooDomainResourcesResult.Companion.toKotlin as getDdosCooDomainResourcesResultToKotlin
import com.pulumi.alicloud.ddos.kotlin.outputs.GetDdosCooInstancesResult.Companion.toKotlin as getDdosCooInstancesResultToKotlin
import com.pulumi.alicloud.ddos.kotlin.outputs.GetDdosCooPortsResult.Companion.toKotlin as getDdosCooPortsResultToKotlin

public object DdosFunctions {
    /**
     * This data source provides a list of Anti-DDoS Advanced instances in an Alibaba Cloud account according to the specified filters.
     * > **NOTE:** Available in v1.183.0+ .
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * export = async () => {
     *     const config = new pulumi.Config();
     *     const name = config.get("name") || "tf-example";
     *     const instanceDdosBgpInstance = new alicloud.ddos.DdosBgpInstance("instance", {
     *         name: name,
     *         baseBandwidth: 20,
     *         bandwidth: -1,
     *         ipCount: 100,
     *         ipType: "IPv4",
     *         normalBandwidth: 100,
     *         type: "Enterprise",
     *     });
     *     const instance = await alicloud.ddos.getDdosBgpInstances({
     *         nameRegex: "ddosbgp",
     *     });
     *     return {
     *         instance: [instance].map(__item => __item.id),
     *     };
     * }
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * config = pulumi.Config()
     * name = config.get("name")
     * if name is None:
     *     name = "tf-example"
     * instance_ddos_bgp_instance = alicloud.ddos.DdosBgpInstance("instance",
     *     name=name,
     *     base_bandwidth=20,
     *     bandwidth=-1,
     *     ip_count=100,
     *     ip_type="IPv4",
     *     normal_bandwidth=100,
     *     type="Enterprise")
     * instance = alicloud.ddos.get_ddos_bgp_instances(name_regex="ddosbgp")
     * pulumi.export("instance", [__item&#46;id for __item in [instance]])
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var config = new Config();
     *     var name = config.Get("name") ?? "tf-example";
     *     var instanceDdosBgpInstance = new AliCloud.Ddos.DdosBgpInstance("instance", new()
     *     {
     *         Name = name,
     *         BaseBandwidth = 20,
     *         Bandwidth = -1,
     *         IpCount = 100,
     *         IpType = "IPv4",
     *         NormalBandwidth = 100,
     *         Type = "Enterprise",
     *     });
     *     var instance = AliCloud.Ddos.GetDdosBgpInstances.Invoke(new()
     *     {
     *         NameRegex = "ddosbgp",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["instance"] = new[]
     *         {
     *             instance,
     *         }.Select(__item => __item.Id).ToList(),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ddos"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
     * )
     * func main() {
     * pulumi.Run(func(ctx *pulumi.Context) error {
     * cfg := config.New(ctx, "")
     * name := "tf-example";
     * if param := cfg.Get("name"); param != ""{
     * name = param
     * }
     * _, err := ddos.NewDdosBgpInstance(ctx, "instance", &ddos.DdosBgpInstanceArgs{
     * Name: pulumi.String(name),
     * BaseBandwidth: pulumi.Int(20),
     * Bandwidth: int(-1),
     * IpCount: pulumi.Int(100),
     * IpType: pulumi.String("IPv4"),
     * NormalBandwidth: pulumi.Int(100),
     * Type: pulumi.String("Enterprise"),
     * })
     * if err != nil {
     * return err
     * }
     * instance, err := ddos.GetDdosBgpInstances(ctx, &ddos.GetDdosBgpInstancesArgs{
     * NameRegex: pulumi.StringRef("ddosbgp"),
     * }, nil);
     * if err != nil {
     * return err
     * }
     * ctx.Export("instance", pulumi.StringArray(%!v(PANIC=Format method: fatal: A failure has occurred: unlowered splat expression @ example.pp:21,11-25)))
     * return nil
     * })
     * }
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getDdosBgpInstances.
     * @return A collection of values returned by getDdosBgpInstances.
     */
    public suspend fun getDdosBgpInstances(argument: GetDdosBgpInstancesPlainArgs): GetDdosBgpInstancesResult =
        getDdosBgpInstancesResultToKotlin(getDdosBgpInstancesPlain(argument.toJava()).await())

    /**
     * @see [getDdosBgpInstances].
     * @param ids A list of instance IDs.
     * @param nameRegex A regex string to filter results by the instance name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @return A collection of values returned by getDdosBgpInstances.
     */
    public suspend fun getDdosBgpInstances(
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
    ): GetDdosBgpInstancesResult {
        val argument = GetDdosBgpInstancesPlainArgs(
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
        )
        return getDdosBgpInstancesResultToKotlin(getDdosBgpInstancesPlain(argument.toJava()).await())
    }

    /**
     * @see [getDdosBgpInstances].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;ddos&#46;kotlin&#46;inputs&#46;GetDdosBgpInstancesPlainArgs].
     * @return A collection of values returned by getDdosBgpInstances.
     */
    public suspend fun getDdosBgpInstances(argument: suspend GetDdosBgpInstancesPlainArgsBuilder.() -> Unit): GetDdosBgpInstancesResult {
        val builder = GetDdosBgpInstancesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDdosBgpInstancesResultToKotlin(getDdosBgpInstancesPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Ddos Bgp Ips of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.180.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.ddos.getDdosBgpIps({
     *     instanceId: "example_value",
     *     ids: [
     *         "example_value-1",
     *         "example_value-2",
     *     ],
     * });
     * export const ddosbgpIpId1 = ids.then(ids => ids.ips?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.ddos.get_ddos_bgp_ips(instance_id="example_value",
     *     ids=[
     *         "example_value-1",
     *         "example_value-2",
     *     ])
     * pulumi.export("ddosbgpIpId1", ids.ips[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.Ddos.GetDdosBgpIps.Invoke(new()
     *     {
     *         InstanceId = "example_value",
     *         Ids = new[]
     *         {
     *             "example_value-1",
     *             "example_value-2",
     *         },
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["ddosbgpIpId1"] = ids&#46;Apply(getDdosBgpIpsResult => getDdosBgpIpsResult&#46;Ips[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ddos"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := ddos.GetDdosBgpIps(ctx, &ddos.GetDdosBgpIpsArgs{
     * 			InstanceId: "example_value",
     * 			Ids: []string{
     * 				"example_value-1",
     * 				"example_value-2",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("ddosbgpIpId1", ids.Ips[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.ddos.DdosFunctions;
     * import com.pulumi.alicloud.ddos.inputs.GetDdosBgpIpsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = DdosFunctions.getDdosBgpIps(GetDdosBgpIpsArgs.builder()
     *             .instanceId("example_value")
     *             .ids(
     *                 "example_value-1",
     *                 "example_value-2")
     *             .build());
     *         ctx.export("ddosbgpIpId1", ids.applyValue(getDdosBgpIpsResult -> getDdosBgpIpsResult.ips()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:ddos:getDdosBgpIps
     *       Arguments:
     *         instanceId: example_value
     *         ids:
     *           - example_value-1
     *           - example_value-2
     * outputs:
     *   ddosbgpIpId1: ${ids.ips[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getDdosBgpIps.
     * @return A collection of values returned by getDdosBgpIps.
     */
    public suspend fun getDdosBgpIps(argument: GetDdosBgpIpsPlainArgs): GetDdosBgpIpsResult =
        getDdosBgpIpsResultToKotlin(getDdosBgpIpsPlain(argument.toJava()).await())

    /**
     * @see [getDdosBgpIps].
     * @param ids A list of Ip IDs.
     * @param instanceId The ID of the native protection enterprise instance to be operated.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param pageNumber
     * @param pageSize
     * @param productName The product name. Valid Value:`ECS`, `SLB`, `EIP`, `WAF`.
     * @param status The current state of the IP address. Valid Value:
     * - normal: indicates normal (not attacked).
     * - hole_begin: indicates that you are in a black hole state.
     * @return A collection of values returned by getDdosBgpIps.
     */
    public suspend fun getDdosBgpIps(
        ids: List<String>? = null,
        instanceId: String,
        outputFile: String? = null,
        pageNumber: Int? = null,
        pageSize: Int? = null,
        productName: String? = null,
        status: String? = null,
    ): GetDdosBgpIpsResult {
        val argument = GetDdosBgpIpsPlainArgs(
            ids = ids,
            instanceId = instanceId,
            outputFile = outputFile,
            pageNumber = pageNumber,
            pageSize = pageSize,
            productName = productName,
            status = status,
        )
        return getDdosBgpIpsResultToKotlin(getDdosBgpIpsPlain(argument.toJava()).await())
    }

    /**
     * @see [getDdosBgpIps].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;ddos&#46;kotlin&#46;inputs&#46;GetDdosBgpIpsPlainArgs].
     * @return A collection of values returned by getDdosBgpIps.
     */
    public suspend fun getDdosBgpIps(argument: suspend GetDdosBgpIpsPlainArgsBuilder.() -> Unit): GetDdosBgpIpsResult {
        val builder = GetDdosBgpIpsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDdosBgpIpsResultToKotlin(getDdosBgpIpsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Ddoscoo Domain Resources of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.123.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const example = alicloud.ddos.getDdosCooDomainResources({
     *     ids: ["tftestacc1234&#46;abc"],
     * });
     * export const firstDdoscooDomainResourceId = example.then(example => example.resources?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * example = alicloud.ddos.get_ddos_coo_domain_resources(ids=["tftestacc1234&#46;abc"])
     * pulumi.export("firstDdoscooDomainResourceId", example.resources[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = AliCloud.Ddos.GetDdosCooDomainResources.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             "tftestacc1234.abc",
     *         },
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["firstDdoscooDomainResourceId"] = example&#46;Apply(getDdosCooDomainResourcesResult => getDdosCooDomainResourcesResult&#46;Resources[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ddos"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		example, err := ddos.GetDdosCooDomainResources(ctx, &ddos.GetDdosCooDomainResourcesArgs{
     * 			Ids: []string{
     * 				"tftestacc1234.abc",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("firstDdoscooDomainResourceId", example.Resources[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.ddos.DdosFunctions;
     * import com.pulumi.alicloud.ddos.inputs.GetDdosCooDomainResourcesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = DdosFunctions.getDdosCooDomainResources(GetDdosCooDomainResourcesArgs.builder()
     *             .ids("tftestacc1234.abc")
     *             .build());
     *         ctx.export("firstDdoscooDomainResourceId", example.applyValue(getDdosCooDomainResourcesResult -> getDdosCooDomainResourcesResult.resources()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: alicloud:ddos:getDdosCooDomainResources
     *       Arguments:
     *         ids:
     *           - tftestacc1234.abc
     * outputs:
     *   firstDdoscooDomainResourceId: ${example.resources[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getDdosCooDomainResources.
     * @return A collection of values returned by getDdosCooDomainResources.
     */
    public suspend fun getDdosCooDomainResources(argument: GetDdosCooDomainResourcesPlainArgs): GetDdosCooDomainResourcesResult =
        getDdosCooDomainResourcesResultToKotlin(getDdosCooDomainResourcesPlain(argument.toJava()).await())

    /**
     * @see [getDdosCooDomainResources].
     * @param ids A list of Domain Resource IDs.
     * @param instanceIds A ID list of Ddoscoo instance.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param queryDomainPattern Match the pattern.
     * @return A collection of values returned by getDdosCooDomainResources.
     */
    public suspend fun getDdosCooDomainResources(
        ids: List<String>? = null,
        instanceIds: List<String>? = null,
        outputFile: String? = null,
        queryDomainPattern: String? = null,
    ): GetDdosCooDomainResourcesResult {
        val argument = GetDdosCooDomainResourcesPlainArgs(
            ids = ids,
            instanceIds = instanceIds,
            outputFile = outputFile,
            queryDomainPattern = queryDomainPattern,
        )
        return getDdosCooDomainResourcesResultToKotlin(getDdosCooDomainResourcesPlain(argument.toJava()).await())
    }

    /**
     * @see [getDdosCooDomainResources].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;ddos&#46;kotlin&#46;inputs&#46;GetDdosCooDomainResourcesPlainArgs].
     * @return A collection of values returned by getDdosCooDomainResources.
     */
    public suspend fun getDdosCooDomainResources(argument: suspend GetDdosCooDomainResourcesPlainArgsBuilder.() -> Unit): GetDdosCooDomainResourcesResult {
        val builder = GetDdosCooDomainResourcesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDdosCooDomainResourcesResultToKotlin(getDdosCooDomainResourcesPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the BGP-Line Anti-DDoS Pro(DdosCoo) instances of the current Alibaba Cloud user.
     * > **NOTE:** Available since v1.39.0.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const default = alicloud.ddos.getDdosCooInstances({
     *     nameRegex: "tf",
     * });
     * export const instance = _default.then(_default => _default.instances.map(__item => __item.id));
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * default = alicloud.ddos.get_ddos_coo_instances(name_regex="tf")
     * pulumi.export("instance", [__item&#46;id for __item in default&#46;instances])
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var @default = AliCloud.Ddos.GetDdosCooInstances.Invoke(new()
     *     {
     *         NameRegex = "tf",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["instance"] = @default.Apply(@default => @default.Apply(getDdosCooInstancesResult => getDdosCooInstancesResult.Instances).Select(__item => __item.Id).ToList()),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ddos"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * pulumi.Run(func(ctx *pulumi.Context) error {
     * _default, err := ddos.GetDdosCooInstances(ctx, &ddos.GetDdosCooInstancesArgs{
     * NameRegex: pulumi.StringRef("tf"),
     * }, nil);
     * if err != nil {
     * return err
     * }
     * ctx.Export("instance", pulumi.StringArray(%!v(PANIC=Format method: fatal: A failure has occurred: unlowered splat expression @ example.pp:6,11-34)))
     * return nil
     * })
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.ddos.DdosFunctions;
     * import com.pulumi.alicloud.ddos.inputs.GetDdosCooInstancesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var default = DdosFunctions.getDdosCooInstances(GetDdosCooInstancesArgs.builder()
     *             .nameRegex("tf")
     *             .build());
     *         ctx.export("instance", default_.instances().stream().map(element -> element.id()).collect(toList()));
     *     }
     * }
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getDdosCooInstances.
     * @return A collection of values returned by getDdosCooInstances.
     */
    public suspend fun getDdosCooInstances(argument: GetDdosCooInstancesPlainArgs): GetDdosCooInstancesResult =
        getDdosCooInstancesResultToKotlin(getDdosCooInstancesPlain(argument.toJava()).await())

    /**
     * @see [getDdosCooInstances].
     * @param ids A list of instance IDs.
     * @param nameRegex A regex string to filter results by the instance name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @return A collection of values returned by getDdosCooInstances.
     */
    public suspend fun getDdosCooInstances(
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
    ): GetDdosCooInstancesResult {
        val argument = GetDdosCooInstancesPlainArgs(
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
        )
        return getDdosCooInstancesResultToKotlin(getDdosCooInstancesPlain(argument.toJava()).await())
    }

    /**
     * @see [getDdosCooInstances].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;ddos&#46;kotlin&#46;inputs&#46;GetDdosCooInstancesPlainArgs].
     * @return A collection of values returned by getDdosCooInstances.
     */
    public suspend fun getDdosCooInstances(argument: suspend GetDdosCooInstancesPlainArgsBuilder.() -> Unit): GetDdosCooInstancesResult {
        val builder = GetDdosCooInstancesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDdosCooInstancesResultToKotlin(getDdosCooInstancesPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Ddoscoo Ports of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.123.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const example = alicloud.ddos.getDdosCooPorts({
     *     instanceId: "ddoscoo-cn-6ja1rl4j****",
     *     ids: ["ddoscoo-cn-6ja1rl4j****:7001:tcp"],
     * });
     * export const firstDdoscooPortId = example.then(example => example.ports?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * example = alicloud.ddos.get_ddos_coo_ports(instance_id="ddoscoo-cn-6ja1rl4j****",
     *     ids=["ddoscoo-cn-6ja1rl4j****:7001:tcp"])
     * pulumi.export("firstDdoscooPortId", example.ports[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = AliCloud.Ddos.GetDdosCooPorts.Invoke(new()
     *     {
     *         InstanceId = "ddoscoo-cn-6ja1rl4j****",
     *         Ids = new[]
     *         {
     *             "ddoscoo-cn-6ja1rl4j****:7001:tcp",
     *         },
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["firstDdoscooPortId"] = example&#46;Apply(getDdosCooPortsResult => getDdosCooPortsResult&#46;Ports[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ddos"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		example, err := ddos.GetDdosCooPorts(ctx, &ddos.GetDdosCooPortsArgs{
     * 			InstanceId: "ddoscoo-cn-6ja1rl4j****",
     * 			Ids: []string{
     * 				"ddoscoo-cn-6ja1rl4j****:7001:tcp",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("firstDdoscooPortId", example.Ports[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.ddos.DdosFunctions;
     * import com.pulumi.alicloud.ddos.inputs.GetDdosCooPortsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = DdosFunctions.getDdosCooPorts(GetDdosCooPortsArgs.builder()
     *             .instanceId("ddoscoo-cn-6ja1rl4j****")
     *             .ids("ddoscoo-cn-6ja1rl4j****:7001:tcp")
     *             .build());
     *         ctx.export("firstDdoscooPortId", example.applyValue(getDdosCooPortsResult -> getDdosCooPortsResult.ports()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: alicloud:ddos:getDdosCooPorts
     *       Arguments:
     *         instanceId: ddoscoo-cn-6ja1rl4j****
     *         ids:
     *           - ddoscoo-cn-6ja1rl4j****:7001:tcp
     * outputs:
     *   firstDdoscooPortId: ${example.ports[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getDdosCooPorts.
     * @return A collection of values returned by getDdosCooPorts.
     */
    public suspend fun getDdosCooPorts(argument: GetDdosCooPortsPlainArgs): GetDdosCooPortsResult =
        getDdosCooPortsResultToKotlin(getDdosCooPortsPlain(argument.toJava()).await())

    /**
     * @see [getDdosCooPorts].
     * @param frontendPort The forwarding port.
     * @param frontendProtocol The forwarding protocol. Valid values `tcp` and `udp`.
     * @param ids A list of Port IDs.
     * @param instanceId The Ddoscoo instance ID.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @return A collection of values returned by getDdosCooPorts.
     */
    public suspend fun getDdosCooPorts(
        frontendPort: String? = null,
        frontendProtocol: String? = null,
        ids: List<String>? = null,
        instanceId: String,
        outputFile: String? = null,
    ): GetDdosCooPortsResult {
        val argument = GetDdosCooPortsPlainArgs(
            frontendPort = frontendPort,
            frontendProtocol = frontendProtocol,
            ids = ids,
            instanceId = instanceId,
            outputFile = outputFile,
        )
        return getDdosCooPortsResultToKotlin(getDdosCooPortsPlain(argument.toJava()).await())
    }

    /**
     * @see [getDdosCooPorts].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;ddos&#46;kotlin&#46;inputs&#46;GetDdosCooPortsPlainArgs].
     * @return A collection of values returned by getDdosCooPorts.
     */
    public suspend fun getDdosCooPorts(argument: suspend GetDdosCooPortsPlainArgsBuilder.() -> Unit): GetDdosCooPortsResult {
        val builder = GetDdosCooPortsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDdosCooPortsResultToKotlin(getDdosCooPortsPlain(builtArgument.toJava()).await())
    }
}
