@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ddos.kotlin

import com.pulumi.alicloud.ddos.kotlin.outputs.DomainResourceProxyType
import com.pulumi.alicloud.ddos.kotlin.outputs.DomainResourceProxyType.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [DomainResource].
 */
@PulumiTagMarker
public class DomainResourceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DomainResourceArgs = DomainResourceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DomainResourceArgsBuilder.() -> Unit) {
        val builder = DomainResourceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): DomainResource {
        val builtJavaResource = com.pulumi.alicloud.ddos.DomainResource(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return DomainResource(builtJavaResource)
    }
}

/**
 * Provides a Anti-DDoS Pro Domain Resource resource.
 * For information about Anti-DDoS Pro Domain Resource and how to use it, see [What is Domain Resource](https://www.alibabacloud.com/help/en/ddos-protection/latest/api-ddoscoo-2020-01-01-createwebrule).
 * > **NOTE:** Available since v1.123.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf-example";
 * const domain = config.get("domain") || "tf-example.alibaba.com";
 * const _default = new alicloud.ddos.DdosCooInstance("default", {
 *     name: name,
 *     bandwidth: "30",
 *     baseBandwidth: "30",
 *     serviceBandwidth: "100",
 *     portCount: "50",
 *     domainCount: "50",
 *     period: 1,
 *     productType: "ddoscoo",
 * });
 * const defaultDomainResource = new alicloud.ddos.DomainResource("default", {
 *     domain: domain,
 *     rsType: 0,
 *     instanceIds: [_default&#46;id],
 *     realServers: ["177&#46;167&#46;32&#46;11"],
 *     httpsExt: "{\"Http2\":1,\"Http2https\":0,\"Https2http\":0}",
 *     proxyTypes: [{
 *         proxyPorts: [443],
 *         proxyType: "https",
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf-example"
 * domain = config.get("domain")
 * if domain is None:
 *     domain = "tf-example.alibaba.com"
 * default = alicloud.ddos.DdosCooInstance("default",
 *     name=name,
 *     bandwidth="30",
 *     base_bandwidth="30",
 *     service_bandwidth="100",
 *     port_count="50",
 *     domain_count="50",
 *     period=1,
 *     product_type="ddoscoo")
 * default_domain_resource = alicloud.ddos.DomainResource("default",
 *     domain=domain,
 *     rs_type=0,
 *     instance_ids=[default&#46;id],
 *     real_servers=["177&#46;167&#46;32&#46;11"],
 *     https_ext="{\"Http2\":1,\"Http2https\":0,\"Https2http\":0}",
 *     proxy_types=[{
 *         "proxy_ports": [443],
 *         "proxy_type": "https",
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf-example";
 *     var domain = config.Get("domain") ?? "tf-example.alibaba.com";
 *     var @default = new AliCloud.Ddos.DdosCooInstance("default", new()
 *     {
 *         Name = name,
 *         Bandwidth = "30",
 *         BaseBandwidth = "30",
 *         ServiceBandwidth = "100",
 *         PortCount = "50",
 *         DomainCount = "50",
 *         Period = 1,
 *         ProductType = "ddoscoo",
 *     });
 *     var defaultDomainResource = new AliCloud.Ddos.DomainResource("default", new()
 *     {
 *         Domain = domain,
 *         RsType = 0,
 *         InstanceIds = new[]
 *         {
 *             @default.Id,
 *         },
 *         RealServers = new[]
 *         {
 *             "177.167.32.11",
 *         },
 *         HttpsExt = "{\"Http2\":1,\"Http2https\":0,\"Https2http\":0}",
 *         ProxyTypes = new[]
 *         {
 *             new AliCloud.Ddos.Inputs.DomainResourceProxyTypeArgs
 *             {
 *                 ProxyPorts = new[]
 *                 {
 *                     443,
 *                 },
 *                 ProxyType = "https",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ddos"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		domain := "tf-example.alibaba.com"
 * 		if param := cfg.Get("domain"); param != "" {
 * 			domain = param
 * 		}
 * 		_, err := ddos.NewDdosCooInstance(ctx, "default", &ddos.DdosCooInstanceArgs{
 * 			Name:             pulumi.String(name),
 * 			Bandwidth:        pulumi.String("30"),
 * 			BaseBandwidth:    pulumi.String("30"),
 * 			ServiceBandwidth: pulumi.String("100"),
 * 			PortCount:        pulumi.String("50"),
 * 			DomainCount:      pulumi.String("50"),
 * 			Period:           pulumi.Int(1),
 * 			ProductType:      pulumi.String("ddoscoo"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ddos.NewDomainResource(ctx, "default", &ddos.DomainResourceArgs{
 * 			Domain: pulumi.String(domain),
 * 			RsType: pulumi.Int(0),
 * 			InstanceIds: pulumi.StringArray{
 * 				_default.ID(),
 * 			},
 * 			RealServers: pulumi.StringArray{
 * 				pulumi.String("177.167.32.11"),
 * 			},
 * 			HttpsExt: pulumi.String("{\"Http2\":1,\"Http2https\":0,\"Https2http\":0}"),
 * 			ProxyTypes: ddos.DomainResourceProxyTypeArray{
 * 				&ddos.DomainResourceProxyTypeArgs{
 * 					ProxyPorts: pulumi.IntArray{
 * 						pulumi.Int(443),
 * 					},
 * 					ProxyType: pulumi.String("https"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.ddos.DdosCooInstance;
 * import com.pulumi.alicloud.ddos.DdosCooInstanceArgs;
 * import com.pulumi.alicloud.ddos.DomainResource;
 * import com.pulumi.alicloud.ddos.DomainResourceArgs;
 * import com.pulumi.alicloud.ddos.inputs.DomainResourceProxyTypeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf-example");
 *         final var domain = config.get("domain").orElse("tf-example.alibaba.com");
 *         var default_ = new DdosCooInstance("default", DdosCooInstanceArgs.builder()
 *             .name(name)
 *             .bandwidth("30")
 *             .baseBandwidth("30")
 *             .serviceBandwidth("100")
 *             .portCount("50")
 *             .domainCount("50")
 *             .period("1")
 *             .productType("ddoscoo")
 *             .build());
 *         var defaultDomainResource = new DomainResource("defaultDomainResource", DomainResourceArgs.builder()
 *             .domain(domain)
 *             .rsType(0)
 *             .instanceIds(default_.id())
 *             .realServers("177.167.32.11")
 *             .httpsExt("{\"Http2\":1,\"Http2https\":0,\"Https2http\":0}")
 *             .proxyTypes(DomainResourceProxyTypeArgs.builder()
 *                 .proxyPorts(443)
 *                 .proxyType("https")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf-example
 *   domain:
 *     type: string
 *     default: tf-example.alibaba.com
 * resources:
 *   default:
 *     type: alicloud:ddos:DdosCooInstance
 *     properties:
 *       name: ${name}
 *       bandwidth: '30'
 *       baseBandwidth: '30'
 *       serviceBandwidth: '100'
 *       portCount: '50'
 *       domainCount: '50'
 *       period: '1'
 *       productType: ddoscoo
 *   defaultDomainResource:
 *     type: alicloud:ddos:DomainResource
 *     name: default
 *     properties:
 *       domain: ${domain}
 *       rsType: 0
 *       instanceIds:
 *         - ${default.id}
 *       realServers:
 *         - 177.167.32.11
 *       httpsExt: '{"Http2":1,"Http2https":0,"Https2http":0}'
 *       proxyTypes:
 *         - proxyPorts:
 *             - 443
 *           proxyType: https
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Anti-DDoS Pro Domain Resource can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:ddos/domainResource:DomainResource example <domain>
 * ```
 */
public class DomainResource internal constructor(
    override val javaResource: com.pulumi.alicloud.ddos.DomainResource,
) : KotlinCustomResource(javaResource, DomainResourceMapper) {
    /**
     * (Available since v1.207.2) The CNAME assigned to the domain name.
     */
    public val cname: Output<String>
        get() = javaResource.cname().applyValue({ args0 -> args0 })

    /**
     * The domain name of the website that you want to add to the instance.
     */
    public val domain: Output<String>
        get() = javaResource.domain().applyValue({ args0 -> args0 })

    /**
     * The advanced HTTPS settings. This parameter takes effect only when the value of ProxyType includes https. This parameter is a string that contains a JSON struct. The JSON struct includes the following fields:
     * - `Http2https`: specifies whether to turn on Enforce HTTPS Routing. This field is optional and must be an integer. Valid values: `0` and `1`. The value `0` indicates that Enforce HTTPS Routing is turned off. The value `1` indicates that Enforce HTTPS Routing is turned on. The default value is `0`. If your website supports both HTTP and HTTPS, this feature suits your needs. If you turn on the switch, all HTTP requests are redirected to HTTPS requests on port 443 by default.
     * - `Https2http`: specifies whether to turn on Enable HTTP. This field is optional and must be an integer. Valid values: `0` and `1`. The value `0` indicates that Enable HTTP is turned off. The value `1` indicates that Enable HTTP is turned on. The default value is `0`. If your website does not support HTTPS, this feature suits your needs. If you turn on the switch, all HTTPS requests are redirected to HTTP requests and forwarded to origin servers. The feature can also redirect WebSockets requests to WebSocket requests. All requests are redirected over port 80.
     * - `Http2`: specifies whether to turn on Enable HTTP/2. This field is optional and must be an integer. Valid values: `0` and `1`. The value `0` indicates that Enable HTTP/2 is turned off. The value `1` indicates that Enable HTTP/2 is turned on. The default value is `0`. After you turn on the switch, the protocol type is HTTP/2.
     */
    public val httpsExt: Output<String>
        get() = javaResource.httpsExt().applyValue({ args0 -> args0 })

    /**
     * A list of instance ID that you want to associate. If this parameter is empty, only the domain name of the website is added but no instance is associated with the website.
     * > **NOTE:** There is a potential diff error because of the order of `instance_ids` values indefinite. So, from version 1.161.0, `instance_ids` type has been updated as `set` from `list`, and you can use tolist to convert it to a list.
     */
    public val instanceIds: Output<List<String>>
        get() = javaResource.instanceIds().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * Specifies whether to enable the OCSP feature. Default value: `false`. Valid values:
     */
    public val ocspEnabled: Output<Boolean>?
        get() = javaResource.ocspEnabled().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Protocol type and port number information. See `proxy_types` below.
     * > **NOTE:** From version 1.206.0, `proxy_types` can be modified.
     */
    public val proxyTypes: Output<List<DomainResourceProxyType>>
        get() = javaResource.proxyTypes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    toKotlin(args0)
                })
            })
        })

    /**
     * the IP address. This field is required and must be a string array.
     */
    public val realServers: Output<List<String>>
        get() = javaResource.realServers().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The address type of the origin server. Use the domain name of the origin server if you deploy proxies, such as Web Application Firewall (WAF), between the origin server and the Anti-DDoS Pro or Anti-DDoS Premium instance. If you use the domain name, you must enter the address of the proxy, such as the CNAME of WAF. Valid values:
     */
    public val rsType: Output<Int>
        get() = javaResource.rsType().applyValue({ args0 -> args0 })
}

public object DomainResourceMapper : ResourceMapper<DomainResource> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.ddos.DomainResource::class == javaResource::class

    override fun map(javaResource: Resource): DomainResource = DomainResource(
        javaResource as
            com.pulumi.alicloud.ddos.DomainResource,
    )
}

/**
 * @see [DomainResource].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [DomainResource].
 */
public suspend fun domainResource(
    name: String,
    block: suspend DomainResourceResourceBuilder.() -> Unit,
): DomainResource {
    val builder = DomainResourceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [DomainResource].
 * @param name The _unique_ name of the resulting resource.
 */
public fun domainResource(name: String): DomainResource {
    val builder = DomainResourceResourceBuilder()
    builder.name(name)
    return builder.build()
}
