@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ddos.kotlin

import com.pulumi.alicloud.ddos.DomainResourceArgs.builder
import com.pulumi.alicloud.ddos.kotlin.inputs.DomainResourceProxyTypeArgs
import com.pulumi.alicloud.ddos.kotlin.inputs.DomainResourceProxyTypeArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides a Anti-DDoS Pro Domain Resource resource.
 * For information about Anti-DDoS Pro Domain Resource and how to use it, see [What is Domain Resource](https://www.alibabacloud.com/help/en/ddos-protection/latest/api-ddoscoo-2020-01-01-createwebrule).
 * > **NOTE:** Available since v1.123.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf-example";
 * const domain = config.get("domain") || "tf-example.alibaba.com";
 * const _default = new alicloud.ddos.DdosCooInstance("default", {
 *     name: name,
 *     bandwidth: "30",
 *     baseBandwidth: "30",
 *     serviceBandwidth: "100",
 *     portCount: "50",
 *     domainCount: "50",
 *     period: 1,
 *     productType: "ddoscoo",
 * });
 * const defaultDomainResource = new alicloud.ddos.DomainResource("default", {
 *     domain: domain,
 *     rsType: 0,
 *     instanceIds: [_default&#46;id],
 *     realServers: ["177&#46;167&#46;32&#46;11"],
 *     httpsExt: "{\"Http2\":1,\"Http2https\":0,\"Https2http\":0}",
 *     proxyTypes: [{
 *         proxyPorts: [443],
 *         proxyType: "https",
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf-example"
 * domain = config.get("domain")
 * if domain is None:
 *     domain = "tf-example.alibaba.com"
 * default = alicloud.ddos.DdosCooInstance("default",
 *     name=name,
 *     bandwidth="30",
 *     base_bandwidth="30",
 *     service_bandwidth="100",
 *     port_count="50",
 *     domain_count="50",
 *     period=1,
 *     product_type="ddoscoo")
 * default_domain_resource = alicloud.ddos.DomainResource("default",
 *     domain=domain,
 *     rs_type=0,
 *     instance_ids=[default&#46;id],
 *     real_servers=["177&#46;167&#46;32&#46;11"],
 *     https_ext="{\"Http2\":1,\"Http2https\":0,\"Https2http\":0}",
 *     proxy_types=[{
 *         "proxy_ports": [443],
 *         "proxy_type": "https",
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf-example";
 *     var domain = config.Get("domain") ?? "tf-example.alibaba.com";
 *     var @default = new AliCloud.Ddos.DdosCooInstance("default", new()
 *     {
 *         Name = name,
 *         Bandwidth = "30",
 *         BaseBandwidth = "30",
 *         ServiceBandwidth = "100",
 *         PortCount = "50",
 *         DomainCount = "50",
 *         Period = 1,
 *         ProductType = "ddoscoo",
 *     });
 *     var defaultDomainResource = new AliCloud.Ddos.DomainResource("default", new()
 *     {
 *         Domain = domain,
 *         RsType = 0,
 *         InstanceIds = new[]
 *         {
 *             @default.Id,
 *         },
 *         RealServers = new[]
 *         {
 *             "177.167.32.11",
 *         },
 *         HttpsExt = "{\"Http2\":1,\"Http2https\":0,\"Https2http\":0}",
 *         ProxyTypes = new[]
 *         {
 *             new AliCloud.Ddos.Inputs.DomainResourceProxyTypeArgs
 *             {
 *                 ProxyPorts = new[]
 *                 {
 *                     443,
 *                 },
 *                 ProxyType = "https",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ddos"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		domain := "tf-example.alibaba.com"
 * 		if param := cfg.Get("domain"); param != "" {
 * 			domain = param
 * 		}
 * 		_, err := ddos.NewDdosCooInstance(ctx, "default", &ddos.DdosCooInstanceArgs{
 * 			Name:             pulumi.String(name),
 * 			Bandwidth:        pulumi.String("30"),
 * 			BaseBandwidth:    pulumi.String("30"),
 * 			ServiceBandwidth: pulumi.String("100"),
 * 			PortCount:        pulumi.String("50"),
 * 			DomainCount:      pulumi.String("50"),
 * 			Period:           pulumi.Int(1),
 * 			ProductType:      pulumi.String("ddoscoo"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ddos.NewDomainResource(ctx, "default", &ddos.DomainResourceArgs{
 * 			Domain: pulumi.String(domain),
 * 			RsType: pulumi.Int(0),
 * 			InstanceIds: pulumi.StringArray{
 * 				_default.ID(),
 * 			},
 * 			RealServers: pulumi.StringArray{
 * 				pulumi.String("177.167.32.11"),
 * 			},
 * 			HttpsExt: pulumi.String("{\"Http2\":1,\"Http2https\":0,\"Https2http\":0}"),
 * 			ProxyTypes: ddos.DomainResourceProxyTypeArray{
 * 				&ddos.DomainResourceProxyTypeArgs{
 * 					ProxyPorts: pulumi.IntArray{
 * 						pulumi.Int(443),
 * 					},
 * 					ProxyType: pulumi.String("https"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.ddos.DdosCooInstance;
 * import com.pulumi.alicloud.ddos.DdosCooInstanceArgs;
 * import com.pulumi.alicloud.ddos.DomainResource;
 * import com.pulumi.alicloud.ddos.DomainResourceArgs;
 * import com.pulumi.alicloud.ddos.inputs.DomainResourceProxyTypeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf-example");
 *         final var domain = config.get("domain").orElse("tf-example.alibaba.com");
 *         var default_ = new DdosCooInstance("default", DdosCooInstanceArgs.builder()
 *             .name(name)
 *             .bandwidth("30")
 *             .baseBandwidth("30")
 *             .serviceBandwidth("100")
 *             .portCount("50")
 *             .domainCount("50")
 *             .period("1")
 *             .productType("ddoscoo")
 *             .build());
 *         var defaultDomainResource = new DomainResource("defaultDomainResource", DomainResourceArgs.builder()
 *             .domain(domain)
 *             .rsType(0)
 *             .instanceIds(default_.id())
 *             .realServers("177.167.32.11")
 *             .httpsExt("{\"Http2\":1,\"Http2https\":0,\"Https2http\":0}")
 *             .proxyTypes(DomainResourceProxyTypeArgs.builder()
 *                 .proxyPorts(443)
 *                 .proxyType("https")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf-example
 *   domain:
 *     type: string
 *     default: tf-example.alibaba.com
 * resources:
 *   default:
 *     type: alicloud:ddos:DdosCooInstance
 *     properties:
 *       name: ${name}
 *       bandwidth: '30'
 *       baseBandwidth: '30'
 *       serviceBandwidth: '100'
 *       portCount: '50'
 *       domainCount: '50'
 *       period: '1'
 *       productType: ddoscoo
 *   defaultDomainResource:
 *     type: alicloud:ddos:DomainResource
 *     name: default
 *     properties:
 *       domain: ${domain}
 *       rsType: 0
 *       instanceIds:
 *         - ${default.id}
 *       realServers:
 *         - 177.167.32.11
 *       httpsExt: '{"Http2":1,"Http2https":0,"Https2http":0}'
 *       proxyTypes:
 *         - proxyPorts:
 *             - 443
 *           proxyType: https
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Anti-DDoS Pro Domain Resource can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:ddos/domainResource:DomainResource example <domain>
 * ```
 * @property domain The domain name of the website that you want to add to the instance.
 * @property httpsExt The advanced HTTPS settings. This parameter takes effect only when the value of ProxyType includes https. This parameter is a string that contains a JSON struct. The JSON struct includes the following fields:
 * - `Http2https`: specifies whether to turn on Enforce HTTPS Routing. This field is optional and must be an integer. Valid values: `0` and `1`. The value `0` indicates that Enforce HTTPS Routing is turned off. The value `1` indicates that Enforce HTTPS Routing is turned on. The default value is `0`. If your website supports both HTTP and HTTPS, this feature suits your needs. If you turn on the switch, all HTTP requests are redirected to HTTPS requests on port 443 by default.
 * - `Https2http`: specifies whether to turn on Enable HTTP. This field is optional and must be an integer. Valid values: `0` and `1`. The value `0` indicates that Enable HTTP is turned off. The value `1` indicates that Enable HTTP is turned on. The default value is `0`. If your website does not support HTTPS, this feature suits your needs. If you turn on the switch, all HTTPS requests are redirected to HTTP requests and forwarded to origin servers. The feature can also redirect WebSockets requests to WebSocket requests. All requests are redirected over port 80.
 * - `Http2`: specifies whether to turn on Enable HTTP/2. This field is optional and must be an integer. Valid values: `0` and `1`. The value `0` indicates that Enable HTTP/2 is turned off. The value `1` indicates that Enable HTTP/2 is turned on. The default value is `0`. After you turn on the switch, the protocol type is HTTP/2.
 * @property instanceIds A list of instance ID that you want to associate. If this parameter is empty, only the domain name of the website is added but no instance is associated with the website.
 * > **NOTE:** There is a potential diff error because of the order of `instance_ids` values indefinite. So, from version 1.161.0, `instance_ids` type has been updated as `set` from `list`, and you can use tolist to convert it to a list.
 * @property ocspEnabled Specifies whether to enable the OCSP feature. Default value: `false`. Valid values:
 * @property proxyTypes Protocol type and port number information. See `proxy_types` below.
 * > **NOTE:** From version 1.206.0, `proxy_types` can be modified.
 * @property realServers the IP address. This field is required and must be a string array.
 * @property rsType The address type of the origin server. Use the domain name of the origin server if you deploy proxies, such as Web Application Firewall (WAF), between the origin server and the Anti-DDoS Pro or Anti-DDoS Premium instance. If you use the domain name, you must enter the address of the proxy, such as the CNAME of WAF. Valid values:
 */
public data class DomainResourceArgs(
    public val domain: Output<String>? = null,
    public val httpsExt: Output<String>? = null,
    public val instanceIds: Output<List<String>>? = null,
    public val ocspEnabled: Output<Boolean>? = null,
    public val proxyTypes: Output<List<DomainResourceProxyTypeArgs>>? = null,
    public val realServers: Output<List<String>>? = null,
    public val rsType: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ddos.DomainResourceArgs> {
    override fun toJava(): com.pulumi.alicloud.ddos.DomainResourceArgs =
        com.pulumi.alicloud.ddos.DomainResourceArgs.builder()
            .domain(domain?.applyValue({ args0 -> args0 }))
            .httpsExt(httpsExt?.applyValue({ args0 -> args0 }))
            .instanceIds(instanceIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .ocspEnabled(ocspEnabled?.applyValue({ args0 -> args0 }))
            .proxyTypes(
                proxyTypes?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .realServers(realServers?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .rsType(rsType?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DomainResourceArgs].
 */
@PulumiTagMarker
public class DomainResourceArgsBuilder internal constructor() {
    private var domain: Output<String>? = null

    private var httpsExt: Output<String>? = null

    private var instanceIds: Output<List<String>>? = null

    private var ocspEnabled: Output<Boolean>? = null

    private var proxyTypes: Output<List<DomainResourceProxyTypeArgs>>? = null

    private var realServers: Output<List<String>>? = null

    private var rsType: Output<Int>? = null

    /**
     * @param value The domain name of the website that you want to add to the instance.
     */
    @JvmName("ghpgurmsbnyidftj")
    public suspend fun domain(`value`: Output<String>) {
        this.domain = value
    }

    /**
     * @param value The advanced HTTPS settings. This parameter takes effect only when the value of ProxyType includes https. This parameter is a string that contains a JSON struct. The JSON struct includes the following fields:
     * - `Http2https`: specifies whether to turn on Enforce HTTPS Routing. This field is optional and must be an integer. Valid values: `0` and `1`. The value `0` indicates that Enforce HTTPS Routing is turned off. The value `1` indicates that Enforce HTTPS Routing is turned on. The default value is `0`. If your website supports both HTTP and HTTPS, this feature suits your needs. If you turn on the switch, all HTTP requests are redirected to HTTPS requests on port 443 by default.
     * - `Https2http`: specifies whether to turn on Enable HTTP. This field is optional and must be an integer. Valid values: `0` and `1`. The value `0` indicates that Enable HTTP is turned off. The value `1` indicates that Enable HTTP is turned on. The default value is `0`. If your website does not support HTTPS, this feature suits your needs. If you turn on the switch, all HTTPS requests are redirected to HTTP requests and forwarded to origin servers. The feature can also redirect WebSockets requests to WebSocket requests. All requests are redirected over port 80.
     * - `Http2`: specifies whether to turn on Enable HTTP/2. This field is optional and must be an integer. Valid values: `0` and `1`. The value `0` indicates that Enable HTTP/2 is turned off. The value `1` indicates that Enable HTTP/2 is turned on. The default value is `0`. After you turn on the switch, the protocol type is HTTP/2.
     */
    @JvmName("pyncbprxiqidykvx")
    public suspend fun httpsExt(`value`: Output<String>) {
        this.httpsExt = value
    }

    /**
     * @param value A list of instance ID that you want to associate. If this parameter is empty, only the domain name of the website is added but no instance is associated with the website.
     * > **NOTE:** There is a potential diff error because of the order of `instance_ids` values indefinite. So, from version 1.161.0, `instance_ids` type has been updated as `set` from `list`, and you can use tolist to convert it to a list.
     */
    @JvmName("edewkmusjyluldjd")
    public suspend fun instanceIds(`value`: Output<List<String>>) {
        this.instanceIds = value
    }

    @JvmName("onpxyjceflcssitb")
    public suspend fun instanceIds(vararg values: Output<String>) {
        this.instanceIds = Output.all(values.asList())
    }

    /**
     * @param values A list of instance ID that you want to associate. If this parameter is empty, only the domain name of the website is added but no instance is associated with the website.
     * > **NOTE:** There is a potential diff error because of the order of `instance_ids` values indefinite. So, from version 1.161.0, `instance_ids` type has been updated as `set` from `list`, and you can use tolist to convert it to a list.
     */
    @JvmName("toqxyhrpltjajnhd")
    public suspend fun instanceIds(values: List<Output<String>>) {
        this.instanceIds = Output.all(values)
    }

    /**
     * @param value Specifies whether to enable the OCSP feature. Default value: `false`. Valid values:
     */
    @JvmName("erchwlucvncxomno")
    public suspend fun ocspEnabled(`value`: Output<Boolean>) {
        this.ocspEnabled = value
    }

    /**
     * @param value Protocol type and port number information. See `proxy_types` below.
     * > **NOTE:** From version 1.206.0, `proxy_types` can be modified.
     */
    @JvmName("ecpoebaattghullf")
    public suspend fun proxyTypes(`value`: Output<List<DomainResourceProxyTypeArgs>>) {
        this.proxyTypes = value
    }

    @JvmName("kgugfetlxflmdalf")
    public suspend fun proxyTypes(vararg values: Output<DomainResourceProxyTypeArgs>) {
        this.proxyTypes = Output.all(values.asList())
    }

    /**
     * @param values Protocol type and port number information. See `proxy_types` below.
     * > **NOTE:** From version 1.206.0, `proxy_types` can be modified.
     */
    @JvmName("mrehcsganbraeigj")
    public suspend fun proxyTypes(values: List<Output<DomainResourceProxyTypeArgs>>) {
        this.proxyTypes = Output.all(values)
    }

    /**
     * @param value the IP address. This field is required and must be a string array.
     */
    @JvmName("kolkphdqstubscui")
    public suspend fun realServers(`value`: Output<List<String>>) {
        this.realServers = value
    }

    @JvmName("prufofcvvncwqjhs")
    public suspend fun realServers(vararg values: Output<String>) {
        this.realServers = Output.all(values.asList())
    }

    /**
     * @param values the IP address. This field is required and must be a string array.
     */
    @JvmName("henjdphwbfifbkxb")
    public suspend fun realServers(values: List<Output<String>>) {
        this.realServers = Output.all(values)
    }

    /**
     * @param value The address type of the origin server. Use the domain name of the origin server if you deploy proxies, such as Web Application Firewall (WAF), between the origin server and the Anti-DDoS Pro or Anti-DDoS Premium instance. If you use the domain name, you must enter the address of the proxy, such as the CNAME of WAF. Valid values:
     */
    @JvmName("vpfdehmxlcopgvxj")
    public suspend fun rsType(`value`: Output<Int>) {
        this.rsType = value
    }

    /**
     * @param value The domain name of the website that you want to add to the instance.
     */
    @JvmName("mqbtqcpgfdawtbtc")
    public suspend fun domain(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.domain = mapped
    }

    /**
     * @param value The advanced HTTPS settings. This parameter takes effect only when the value of ProxyType includes https. This parameter is a string that contains a JSON struct. The JSON struct includes the following fields:
     * - `Http2https`: specifies whether to turn on Enforce HTTPS Routing. This field is optional and must be an integer. Valid values: `0` and `1`. The value `0` indicates that Enforce HTTPS Routing is turned off. The value `1` indicates that Enforce HTTPS Routing is turned on. The default value is `0`. If your website supports both HTTP and HTTPS, this feature suits your needs. If you turn on the switch, all HTTP requests are redirected to HTTPS requests on port 443 by default.
     * - `Https2http`: specifies whether to turn on Enable HTTP. This field is optional and must be an integer. Valid values: `0` and `1`. The value `0` indicates that Enable HTTP is turned off. The value `1` indicates that Enable HTTP is turned on. The default value is `0`. If your website does not support HTTPS, this feature suits your needs. If you turn on the switch, all HTTPS requests are redirected to HTTP requests and forwarded to origin servers. The feature can also redirect WebSockets requests to WebSocket requests. All requests are redirected over port 80.
     * - `Http2`: specifies whether to turn on Enable HTTP/2. This field is optional and must be an integer. Valid values: `0` and `1`. The value `0` indicates that Enable HTTP/2 is turned off. The value `1` indicates that Enable HTTP/2 is turned on. The default value is `0`. After you turn on the switch, the protocol type is HTTP/2.
     */
    @JvmName("jiqotvvhcgwxdxul")
    public suspend fun httpsExt(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.httpsExt = mapped
    }

    /**
     * @param value A list of instance ID that you want to associate. If this parameter is empty, only the domain name of the website is added but no instance is associated with the website.
     * > **NOTE:** There is a potential diff error because of the order of `instance_ids` values indefinite. So, from version 1.161.0, `instance_ids` type has been updated as `set` from `list`, and you can use tolist to convert it to a list.
     */
    @JvmName("tjhumthhqpsrstxc")
    public suspend fun instanceIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceIds = mapped
    }

    /**
     * @param values A list of instance ID that you want to associate. If this parameter is empty, only the domain name of the website is added but no instance is associated with the website.
     * > **NOTE:** There is a potential diff error because of the order of `instance_ids` values indefinite. So, from version 1.161.0, `instance_ids` type has been updated as `set` from `list`, and you can use tolist to convert it to a list.
     */
    @JvmName("ftbtnbyflbngsups")
    public suspend fun instanceIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.instanceIds = mapped
    }

    /**
     * @param value Specifies whether to enable the OCSP feature. Default value: `false`. Valid values:
     */
    @JvmName("eeycpuobgumwieqv")
    public suspend fun ocspEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ocspEnabled = mapped
    }

    /**
     * @param value Protocol type and port number information. See `proxy_types` below.
     * > **NOTE:** From version 1.206.0, `proxy_types` can be modified.
     */
    @JvmName("dapqiwkauecslmon")
    public suspend fun proxyTypes(`value`: List<DomainResourceProxyTypeArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.proxyTypes = mapped
    }

    /**
     * @param argument Protocol type and port number information. See `proxy_types` below.
     * > **NOTE:** From version 1.206.0, `proxy_types` can be modified.
     */
    @JvmName("irblfcyqgxjsdwxv")
    public suspend fun proxyTypes(argument: List<suspend DomainResourceProxyTypeArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            DomainResourceProxyTypeArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.proxyTypes = mapped
    }

    /**
     * @param argument Protocol type and port number information. See `proxy_types` below.
     * > **NOTE:** From version 1.206.0, `proxy_types` can be modified.
     */
    @JvmName("ympfbnqaguwwpxyt")
    public suspend fun proxyTypes(vararg argument: suspend DomainResourceProxyTypeArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            DomainResourceProxyTypeArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.proxyTypes = mapped
    }

    /**
     * @param argument Protocol type and port number information. See `proxy_types` below.
     * > **NOTE:** From version 1.206.0, `proxy_types` can be modified.
     */
    @JvmName("ndfvqjngdgrayfrp")
    public suspend fun proxyTypes(argument: suspend DomainResourceProxyTypeArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            DomainResourceProxyTypeArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.proxyTypes = mapped
    }

    /**
     * @param values Protocol type and port number information. See `proxy_types` below.
     * > **NOTE:** From version 1.206.0, `proxy_types` can be modified.
     */
    @JvmName("bcidktkvuocnprtb")
    public suspend fun proxyTypes(vararg values: DomainResourceProxyTypeArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.proxyTypes = mapped
    }

    /**
     * @param value the IP address. This field is required and must be a string array.
     */
    @JvmName("okfdqhvhxloyvmur")
    public suspend fun realServers(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.realServers = mapped
    }

    /**
     * @param values the IP address. This field is required and must be a string array.
     */
    @JvmName("nwavmkwcsplkoing")
    public suspend fun realServers(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.realServers = mapped
    }

    /**
     * @param value The address type of the origin server. Use the domain name of the origin server if you deploy proxies, such as Web Application Firewall (WAF), between the origin server and the Anti-DDoS Pro or Anti-DDoS Premium instance. If you use the domain name, you must enter the address of the proxy, such as the CNAME of WAF. Valid values:
     */
    @JvmName("xnaxhkewfykfjfkx")
    public suspend fun rsType(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rsType = mapped
    }

    internal fun build(): DomainResourceArgs = DomainResourceArgs(
        domain = domain,
        httpsExt = httpsExt,
        instanceIds = instanceIds,
        ocspEnabled = ocspEnabled,
        proxyTypes = proxyTypes,
        realServers = realServers,
        rsType = rsType,
    )
}
