@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ddos.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [Port].
 */
@PulumiTagMarker
public class PortResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: PortArgs = PortArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend PortArgsBuilder.() -> Unit) {
        val builder = PortArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Port {
        val builtJavaResource = com.pulumi.alicloud.ddos.Port(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Port(builtJavaResource)
    }
}

/**
 * Provides a Anti-DDoS Pro Port resource.
 * For information about Anti-DDoS Pro Port and how to use it, see [What is Port](https://www.alibabacloud.com/help/en/ddos-protection/latest/api-ddoscoo-2020-01-01-createport).
 * > **NOTE:** Available since v1.123.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf-example";
 * const _default = new alicloud.ddos.DdosCooInstance("default", {
 *     name: name,
 *     bandwidth: "30",
 *     baseBandwidth: "30",
 *     serviceBandwidth: "100",
 *     portCount: "50",
 *     domainCount: "50",
 *     period: 1,
 *     productType: "ddoscoo",
 * });
 * const defaultPort = new alicloud.ddos.Port("default", {
 *     instanceId: _default.id,
 *     frontendPort: "7001",
 *     backendPort: "7002",
 *     frontendProtocol: "tcp",
 *     realServers: [
 *         "1.1.1.1",
 *         "2.2.2.2",
 *     ],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf-example"
 * default = alicloud.ddos.DdosCooInstance("default",
 *     name=name,
 *     bandwidth="30",
 *     base_bandwidth="30",
 *     service_bandwidth="100",
 *     port_count="50",
 *     domain_count="50",
 *     period=1,
 *     product_type="ddoscoo")
 * default_port = alicloud.ddos.Port("default",
 *     instance_id=default.id,
 *     frontend_port="7001",
 *     backend_port="7002",
 *     frontend_protocol="tcp",
 *     real_servers=[
 *         "1.1.1.1",
 *         "2.2.2.2",
 *     ])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf-example";
 *     var @default = new AliCloud.Ddos.DdosCooInstance("default", new()
 *     {
 *         Name = name,
 *         Bandwidth = "30",
 *         BaseBandwidth = "30",
 *         ServiceBandwidth = "100",
 *         PortCount = "50",
 *         DomainCount = "50",
 *         Period = 1,
 *         ProductType = "ddoscoo",
 *     });
 *     var defaultPort = new AliCloud.Ddos.Port("default", new()
 *     {
 *         InstanceId = @default.Id,
 *         FrontendPort = "7001",
 *         BackendPort = "7002",
 *         FrontendProtocol = "tcp",
 *         RealServers = new[]
 *         {
 *             "1.1.1.1",
 *             "2.2.2.2",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ddos"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := ddos.NewDdosCooInstance(ctx, "default", &ddos.DdosCooInstanceArgs{
 * 			Name:             pulumi.String(name),
 * 			Bandwidth:        pulumi.String("30"),
 * 			BaseBandwidth:    pulumi.String("30"),
 * 			ServiceBandwidth: pulumi.String("100"),
 * 			PortCount:        pulumi.String("50"),
 * 			DomainCount:      pulumi.String("50"),
 * 			Period:           pulumi.Int(1),
 * 			ProductType:      pulumi.String("ddoscoo"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ddos.NewPort(ctx, "default", &ddos.PortArgs{
 * 			InstanceId:       _default.ID(),
 * 			FrontendPort:     pulumi.String("7001"),
 * 			BackendPort:      pulumi.String("7002"),
 * 			FrontendProtocol: pulumi.String("tcp"),
 * 			RealServers: pulumi.StringArray{
 * 				pulumi.String("1.1.1.1"),
 * 				pulumi.String("2.2.2.2"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.ddos.DdosCooInstance;
 * import com.pulumi.alicloud.ddos.DdosCooInstanceArgs;
 * import com.pulumi.alicloud.ddos.Port;
 * import com.pulumi.alicloud.ddos.PortArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf-example");
 *         var default_ = new DdosCooInstance("default", DdosCooInstanceArgs.builder()
 *             .name(name)
 *             .bandwidth("30")
 *             .baseBandwidth("30")
 *             .serviceBandwidth("100")
 *             .portCount("50")
 *             .domainCount("50")
 *             .period("1")
 *             .productType("ddoscoo")
 *             .build());
 *         var defaultPort = new Port("defaultPort", PortArgs.builder()
 *             .instanceId(default_.id())
 *             .frontendPort("7001")
 *             .backendPort("7002")
 *             .frontendProtocol("tcp")
 *             .realServers(
 *                 "1.1.1.1",
 *                 "2.2.2.2")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf-example
 * resources:
 *   default:
 *     type: alicloud:ddos:DdosCooInstance
 *     properties:
 *       name: ${name}
 *       bandwidth: '30'
 *       baseBandwidth: '30'
 *       serviceBandwidth: '100'
 *       portCount: '50'
 *       domainCount: '50'
 *       period: '1'
 *       productType: ddoscoo
 *   defaultPort:
 *     type: alicloud:ddos:Port
 *     name: default
 *     properties:
 *       instanceId: ${default.id}
 *       frontendPort: '7001'
 *       backendPort: '7002'
 *       frontendProtocol: tcp
 *       realServers:
 *         - 1.1.1.1
 *         - 2.2.2.2
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Anti-DDoS Pro Port can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:ddos/port:Port example <instance_id>:<frontend_port>:<frontend_protocol>
 * ```
 */
public class Port internal constructor(
    override val javaResource: com.pulumi.alicloud.ddos.Port,
) : KotlinCustomResource(javaResource, PortMapper) {
    /**
     * The port of the origin server. Valid values: [1~65535].
     */
    public val backendPort: Output<String>?
        get() = javaResource.backendPort().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The forwarding port. Valid values: [1~65535].
     */
    public val frontendPort: Output<String>
        get() = javaResource.frontendPort().applyValue({ args0 -> args0 })

    /**
     * The forwarding protocol. Valid values `tcp` and `udp`.
     */
    public val frontendProtocol: Output<String>
        get() = javaResource.frontendProtocol().applyValue({ args0 -> args0 })

    /**
     * The ID of Ddoscoo instance.
     */
    public val instanceId: Output<String>
        get() = javaResource.instanceId().applyValue({ args0 -> args0 })

    /**
     * List of source IP addresses.
     */
    public val realServers: Output<List<String>>
        get() = javaResource.realServers().applyValue({ args0 -> args0.map({ args0 -> args0 }) })
}

public object PortMapper : ResourceMapper<Port> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.ddos.Port::class == javaResource::class

    override fun map(javaResource: Resource): Port = Port(
        javaResource as
            com.pulumi.alicloud.ddos.Port,
    )
}

/**
 * @see [Port].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Port].
 */
public suspend fun port(name: String, block: suspend PortResourceBuilder.() -> Unit): Port {
    val builder = PortResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Port].
 * @param name The _unique_ name of the resulting resource.
 */
public fun port(name: String): Port {
    val builder = PortResourceBuilder()
    builder.name(name)
    return builder.build()
}
