@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ddos.kotlin

import com.pulumi.alicloud.ddos.PortArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides a Anti-DDoS Pro Port resource.
 * For information about Anti-DDoS Pro Port and how to use it, see [What is Port](https://www.alibabacloud.com/help/en/ddos-protection/latest/api-ddoscoo-2020-01-01-createport).
 * > **NOTE:** Available since v1.123.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf-example";
 * const _default = new alicloud.ddos.DdosCooInstance("default", {
 *     name: name,
 *     bandwidth: "30",
 *     baseBandwidth: "30",
 *     serviceBandwidth: "100",
 *     portCount: "50",
 *     domainCount: "50",
 *     period: 1,
 *     productType: "ddoscoo",
 * });
 * const defaultPort = new alicloud.ddos.Port("default", {
 *     instanceId: _default.id,
 *     frontendPort: "7001",
 *     backendPort: "7002",
 *     frontendProtocol: "tcp",
 *     realServers: [
 *         "1.1.1.1",
 *         "2.2.2.2",
 *     ],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf-example"
 * default = alicloud.ddos.DdosCooInstance("default",
 *     name=name,
 *     bandwidth="30",
 *     base_bandwidth="30",
 *     service_bandwidth="100",
 *     port_count="50",
 *     domain_count="50",
 *     period=1,
 *     product_type="ddoscoo")
 * default_port = alicloud.ddos.Port("default",
 *     instance_id=default.id,
 *     frontend_port="7001",
 *     backend_port="7002",
 *     frontend_protocol="tcp",
 *     real_servers=[
 *         "1.1.1.1",
 *         "2.2.2.2",
 *     ])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf-example";
 *     var @default = new AliCloud.Ddos.DdosCooInstance("default", new()
 *     {
 *         Name = name,
 *         Bandwidth = "30",
 *         BaseBandwidth = "30",
 *         ServiceBandwidth = "100",
 *         PortCount = "50",
 *         DomainCount = "50",
 *         Period = 1,
 *         ProductType = "ddoscoo",
 *     });
 *     var defaultPort = new AliCloud.Ddos.Port("default", new()
 *     {
 *         InstanceId = @default.Id,
 *         FrontendPort = "7001",
 *         BackendPort = "7002",
 *         FrontendProtocol = "tcp",
 *         RealServers = new[]
 *         {
 *             "1.1.1.1",
 *             "2.2.2.2",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ddos"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := ddos.NewDdosCooInstance(ctx, "default", &ddos.DdosCooInstanceArgs{
 * 			Name:             pulumi.String(name),
 * 			Bandwidth:        pulumi.String("30"),
 * 			BaseBandwidth:    pulumi.String("30"),
 * 			ServiceBandwidth: pulumi.String("100"),
 * 			PortCount:        pulumi.String("50"),
 * 			DomainCount:      pulumi.String("50"),
 * 			Period:           pulumi.Int(1),
 * 			ProductType:      pulumi.String("ddoscoo"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ddos.NewPort(ctx, "default", &ddos.PortArgs{
 * 			InstanceId:       _default.ID(),
 * 			FrontendPort:     pulumi.String("7001"),
 * 			BackendPort:      pulumi.String("7002"),
 * 			FrontendProtocol: pulumi.String("tcp"),
 * 			RealServers: pulumi.StringArray{
 * 				pulumi.String("1.1.1.1"),
 * 				pulumi.String("2.2.2.2"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.ddos.DdosCooInstance;
 * import com.pulumi.alicloud.ddos.DdosCooInstanceArgs;
 * import com.pulumi.alicloud.ddos.Port;
 * import com.pulumi.alicloud.ddos.PortArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf-example");
 *         var default_ = new DdosCooInstance("default", DdosCooInstanceArgs.builder()
 *             .name(name)
 *             .bandwidth("30")
 *             .baseBandwidth("30")
 *             .serviceBandwidth("100")
 *             .portCount("50")
 *             .domainCount("50")
 *             .period("1")
 *             .productType("ddoscoo")
 *             .build());
 *         var defaultPort = new Port("defaultPort", PortArgs.builder()
 *             .instanceId(default_.id())
 *             .frontendPort("7001")
 *             .backendPort("7002")
 *             .frontendProtocol("tcp")
 *             .realServers(
 *                 "1.1.1.1",
 *                 "2.2.2.2")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf-example
 * resources:
 *   default:
 *     type: alicloud:ddos:DdosCooInstance
 *     properties:
 *       name: ${name}
 *       bandwidth: '30'
 *       baseBandwidth: '30'
 *       serviceBandwidth: '100'
 *       portCount: '50'
 *       domainCount: '50'
 *       period: '1'
 *       productType: ddoscoo
 *   defaultPort:
 *     type: alicloud:ddos:Port
 *     name: default
 *     properties:
 *       instanceId: ${default.id}
 *       frontendPort: '7001'
 *       backendPort: '7002'
 *       frontendProtocol: tcp
 *       realServers:
 *         - 1.1.1.1
 *         - 2.2.2.2
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Anti-DDoS Pro Port can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:ddos/port:Port example <instance_id>:<frontend_port>:<frontend_protocol>
 * ```
 * @property backendPort The port of the origin server. Valid values: [1~65535].
 * @property frontendPort The forwarding port. Valid values: [1~65535].
 * @property frontendProtocol The forwarding protocol. Valid values `tcp` and `udp`.
 * @property instanceId The ID of Ddoscoo instance.
 * @property realServers List of source IP addresses.
 */
public data class PortArgs(
    public val backendPort: Output<String>? = null,
    public val frontendPort: Output<String>? = null,
    public val frontendProtocol: Output<String>? = null,
    public val instanceId: Output<String>? = null,
    public val realServers: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ddos.PortArgs> {
    override fun toJava(): com.pulumi.alicloud.ddos.PortArgs =
        com.pulumi.alicloud.ddos.PortArgs.builder()
            .backendPort(backendPort?.applyValue({ args0 -> args0 }))
            .frontendPort(frontendPort?.applyValue({ args0 -> args0 }))
            .frontendProtocol(frontendProtocol?.applyValue({ args0 -> args0 }))
            .instanceId(instanceId?.applyValue({ args0 -> args0 }))
            .realServers(realServers?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [PortArgs].
 */
@PulumiTagMarker
public class PortArgsBuilder internal constructor() {
    private var backendPort: Output<String>? = null

    private var frontendPort: Output<String>? = null

    private var frontendProtocol: Output<String>? = null

    private var instanceId: Output<String>? = null

    private var realServers: Output<List<String>>? = null

    /**
     * @param value The port of the origin server. Valid values: [1~65535].
     */
    @JvmName("jnhecjyvblobsktm")
    public suspend fun backendPort(`value`: Output<String>) {
        this.backendPort = value
    }

    /**
     * @param value The forwarding port. Valid values: [1~65535].
     */
    @JvmName("lvjmeuotvywqoyxp")
    public suspend fun frontendPort(`value`: Output<String>) {
        this.frontendPort = value
    }

    /**
     * @param value The forwarding protocol. Valid values `tcp` and `udp`.
     */
    @JvmName("jlaxchsnlcubfsoc")
    public suspend fun frontendProtocol(`value`: Output<String>) {
        this.frontendProtocol = value
    }

    /**
     * @param value The ID of Ddoscoo instance.
     */
    @JvmName("wurbppnkqfuqjpnj")
    public suspend fun instanceId(`value`: Output<String>) {
        this.instanceId = value
    }

    /**
     * @param value List of source IP addresses.
     */
    @JvmName("fnsqyqecnpupfjkp")
    public suspend fun realServers(`value`: Output<List<String>>) {
        this.realServers = value
    }

    @JvmName("mcpuenpvasbdlwuw")
    public suspend fun realServers(vararg values: Output<String>) {
        this.realServers = Output.all(values.asList())
    }

    /**
     * @param values List of source IP addresses.
     */
    @JvmName("wrtggedcjmsmaltg")
    public suspend fun realServers(values: List<Output<String>>) {
        this.realServers = Output.all(values)
    }

    /**
     * @param value The port of the origin server. Valid values: [1~65535].
     */
    @JvmName("fqxvwodeavcfpigk")
    public suspend fun backendPort(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.backendPort = mapped
    }

    /**
     * @param value The forwarding port. Valid values: [1~65535].
     */
    @JvmName("pcqenqoxluktgnny")
    public suspend fun frontendPort(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.frontendPort = mapped
    }

    /**
     * @param value The forwarding protocol. Valid values `tcp` and `udp`.
     */
    @JvmName("epxumyceylhcqcqs")
    public suspend fun frontendProtocol(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.frontendProtocol = mapped
    }

    /**
     * @param value The ID of Ddoscoo instance.
     */
    @JvmName("ubtugyutrpgrevxt")
    public suspend fun instanceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceId = mapped
    }

    /**
     * @param value List of source IP addresses.
     */
    @JvmName("nwjwpooqhbevktiv")
    public suspend fun realServers(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.realServers = mapped
    }

    /**
     * @param values List of source IP addresses.
     */
    @JvmName("tckhyjtbpurjrdpm")
    public suspend fun realServers(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.realServers = mapped
    }

    internal fun build(): PortArgs = PortArgs(
        backendPort = backendPort,
        frontendPort = frontendPort,
        frontendProtocol = frontendProtocol,
        instanceId = instanceId,
        realServers = realServers,
    )
}
