@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ddos.kotlin

import com.pulumi.alicloud.ddos.kotlin.outputs.SchedulerRuleRule
import com.pulumi.alicloud.ddos.kotlin.outputs.SchedulerRuleRule.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [SchedulerRule].
 */
@PulumiTagMarker
public class SchedulerRuleResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SchedulerRuleArgs = SchedulerRuleArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SchedulerRuleArgsBuilder.() -> Unit) {
        val builder = SchedulerRuleArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): SchedulerRule {
        val builtJavaResource = com.pulumi.alicloud.ddos.SchedulerRule(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return SchedulerRule(builtJavaResource)
    }
}

/**
 * Provides a DdosCoo Scheduler Rule resource. For information about DdosCoo Scheduler Rule and how to use it, see[What is DdosCoo Scheduler Rule](https://www.alibabacloud.com/help/en/ddos-protection/latest/api-ddoscoo-2020-01-01-createschedulerrule).
 * > **NOTE:** Available since v1.86.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf-example";
 * const example = new alicloud.ddos.SchedulerRule("example", {
 *     ruleName: name,
 *     ruleType: 3,
 *     rules: [
 *         {
 *             priority: 100,
 *             regionId: "cn-hangzhou",
 *             type: "A",
 *             value: "127.0.0.1",
 *             valueType: 3,
 *         },
 *         {
 *             priority: 50,
 *             regionId: "cn-hangzhou",
 *             type: "A",
 *             value: "127.0.0.0",
 *             valueType: 1,
 *         },
 *     ],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf-example"
 * example = alicloud.ddos.SchedulerRule("example",
 *     rule_name=name,
 *     rule_type=3,
 *     rules=[
 *         {
 *             "priority": 100,
 *             "region_id": "cn-hangzhou",
 *             "type": "A",
 *             "value": "127.0.0.1",
 *             "value_type": 3,
 *         },
 *         {
 *             "priority": 50,
 *             "region_id": "cn-hangzhou",
 *             "type": "A",
 *             "value": "127.0.0.0",
 *             "value_type": 1,
 *         },
 *     ])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf-example";
 *     var example = new AliCloud.Ddos.SchedulerRule("example", new()
 *     {
 *         RuleName = name,
 *         RuleType = 3,
 *         Rules = new[]
 *         {
 *             new AliCloud.Ddos.Inputs.SchedulerRuleRuleArgs
 *             {
 *                 Priority = 100,
 *                 RegionId = "cn-hangzhou",
 *                 Type = "A",
 *                 Value = "127.0.0.1",
 *                 ValueType = 3,
 *             },
 *             new AliCloud.Ddos.Inputs.SchedulerRuleRuleArgs
 *             {
 *                 Priority = 50,
 *                 RegionId = "cn-hangzhou",
 *                 Type = "A",
 *                 Value = "127.0.0.0",
 *                 ValueType = 1,
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ddos"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := ddos.NewSchedulerRule(ctx, "example", &ddos.SchedulerRuleArgs{
 * 			RuleName: pulumi.String(name),
 * 			RuleType: pulumi.Int(3),
 * 			Rules: ddos.SchedulerRuleRuleArray{
 * 				&ddos.SchedulerRuleRuleArgs{
 * 					Priority:  pulumi.Int(100),
 * 					RegionId:  pulumi.String("cn-hangzhou"),
 * 					Type:      pulumi.String("A"),
 * 					Value:     pulumi.String("127.0.0.1"),
 * 					ValueType: pulumi.Int(3),
 * 				},
 * 				&ddos.SchedulerRuleRuleArgs{
 * 					Priority:  pulumi.Int(50),
 * 					RegionId:  pulumi.String("cn-hangzhou"),
 * 					Type:      pulumi.String("A"),
 * 					Value:     pulumi.String("127.0.0.0"),
 * 					ValueType: pulumi.Int(1),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.ddos.SchedulerRule;
 * import com.pulumi.alicloud.ddos.SchedulerRuleArgs;
 * import com.pulumi.alicloud.ddos.inputs.SchedulerRuleRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf-example");
 *         var example = new SchedulerRule("example", SchedulerRuleArgs.builder()
 *             .ruleName(name)
 *             .ruleType(3)
 *             .rules(
 *                 SchedulerRuleRuleArgs.builder()
 *                     .priority(100)
 *                     .regionId("cn-hangzhou")
 *                     .type("A")
 *                     .value("127.0.0.1")
 *                     .valueType(3)
 *                     .build(),
 *                 SchedulerRuleRuleArgs.builder()
 *                     .priority(50)
 *                     .regionId("cn-hangzhou")
 *                     .type("A")
 *                     .value("127.0.0.0")
 *                     .valueType(1)
 *                     .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf-example
 * resources:
 *   example:
 *     type: alicloud:ddos:SchedulerRule
 *     properties:
 *       ruleName: ${name}
 *       ruleType: 3
 *       rules:
 *         - priority: 100
 *           regionId: cn-hangzhou
 *           type: A
 *           value: 127.0.0.1
 *           valueType: 3
 *         - priority: 50
 *           regionId: cn-hangzhou
 *           type: A
 *           value: 127.0.0.0
 *           valueType: 1
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * DdosCoo Scheduler Rule can be imported using the id or the rule name, e.g.
 * ```sh
 * $ pulumi import alicloud:ddos/schedulerRule:SchedulerRule example fbb20dc77e8fc******
 * ```
 */
public class SchedulerRule internal constructor(
    override val javaResource: com.pulumi.alicloud.ddos.SchedulerRule,
) : KotlinCustomResource(javaResource, SchedulerRuleMapper) {
    /**
     * The cname is the traffic scheduler corresponding to rules.
     */
    public val cname: Output<String>
        get() = javaResource.cname().applyValue({ args0 -> args0 })

    /**
     * The scheduling rule for the Global Accelerator instance that interacts with Anti-DDoS Pro or Anti-DDoS Premium.
     */
    public val `param`: Output<String>?
        get() = javaResource.`param`().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The ID of the resource group to which the anti-DDoS pro instance belongs in resource management. By default, no value is specified, indicating that the domains in the default resource group are listed.
     */
    public val resourceGroupId: Output<String>?
        get() = javaResource.resourceGroupId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the rule.
     */
    public val ruleName: Output<String>
        get() = javaResource.ruleName().applyValue({ args0 -> args0 })

    /**
     * The rule type. Valid values:
     * `2`: tiered protection.
     * `3`: globalization acceleration.
     * `6`: Cloud product interaction.
     */
    public val ruleType: Output<Int>
        get() = javaResource.ruleType().applyValue({ args0 -> args0 })

    /**
     * The information about the scheduling rules. See `rules` below.
     */
    public val rules: Output<List<SchedulerRuleRule>>
        get() = javaResource.rules().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    toKotlin(args0)
                })
            })
        })
}

public object SchedulerRuleMapper : ResourceMapper<SchedulerRule> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.ddos.SchedulerRule::class == javaResource::class

    override fun map(javaResource: Resource): SchedulerRule = SchedulerRule(
        javaResource as
            com.pulumi.alicloud.ddos.SchedulerRule,
    )
}

/**
 * @see [SchedulerRule].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [SchedulerRule].
 */
public suspend fun schedulerRule(
    name: String,
    block: suspend SchedulerRuleResourceBuilder.() -> Unit,
): SchedulerRule {
    val builder = SchedulerRuleResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [SchedulerRule].
 * @param name The _unique_ name of the resulting resource.
 */
public fun schedulerRule(name: String): SchedulerRule {
    val builder = SchedulerRuleResourceBuilder()
    builder.name(name)
    return builder.build()
}
