@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ddos.kotlin

import com.pulumi.alicloud.ddos.SchedulerRuleArgs.builder
import com.pulumi.alicloud.ddos.kotlin.inputs.SchedulerRuleRuleArgs
import com.pulumi.alicloud.ddos.kotlin.inputs.SchedulerRuleRuleArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides a DdosCoo Scheduler Rule resource. For information about DdosCoo Scheduler Rule and how to use it, see[What is DdosCoo Scheduler Rule](https://www.alibabacloud.com/help/en/ddos-protection/latest/api-ddoscoo-2020-01-01-createschedulerrule).
 * > **NOTE:** Available since v1.86.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf-example";
 * const example = new alicloud.ddos.SchedulerRule("example", {
 *     ruleName: name,
 *     ruleType: 3,
 *     rules: [
 *         {
 *             priority: 100,
 *             regionId: "cn-hangzhou",
 *             type: "A",
 *             value: "127.0.0.1",
 *             valueType: 3,
 *         },
 *         {
 *             priority: 50,
 *             regionId: "cn-hangzhou",
 *             type: "A",
 *             value: "127.0.0.0",
 *             valueType: 1,
 *         },
 *     ],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf-example"
 * example = alicloud.ddos.SchedulerRule("example",
 *     rule_name=name,
 *     rule_type=3,
 *     rules=[
 *         {
 *             "priority": 100,
 *             "region_id": "cn-hangzhou",
 *             "type": "A",
 *             "value": "127.0.0.1",
 *             "value_type": 3,
 *         },
 *         {
 *             "priority": 50,
 *             "region_id": "cn-hangzhou",
 *             "type": "A",
 *             "value": "127.0.0.0",
 *             "value_type": 1,
 *         },
 *     ])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf-example";
 *     var example = new AliCloud.Ddos.SchedulerRule("example", new()
 *     {
 *         RuleName = name,
 *         RuleType = 3,
 *         Rules = new[]
 *         {
 *             new AliCloud.Ddos.Inputs.SchedulerRuleRuleArgs
 *             {
 *                 Priority = 100,
 *                 RegionId = "cn-hangzhou",
 *                 Type = "A",
 *                 Value = "127.0.0.1",
 *                 ValueType = 3,
 *             },
 *             new AliCloud.Ddos.Inputs.SchedulerRuleRuleArgs
 *             {
 *                 Priority = 50,
 *                 RegionId = "cn-hangzhou",
 *                 Type = "A",
 *                 Value = "127.0.0.0",
 *                 ValueType = 1,
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ddos"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := ddos.NewSchedulerRule(ctx, "example", &ddos.SchedulerRuleArgs{
 * 			RuleName: pulumi.String(name),
 * 			RuleType: pulumi.Int(3),
 * 			Rules: ddos.SchedulerRuleRuleArray{
 * 				&ddos.SchedulerRuleRuleArgs{
 * 					Priority:  pulumi.Int(100),
 * 					RegionId:  pulumi.String("cn-hangzhou"),
 * 					Type:      pulumi.String("A"),
 * 					Value:     pulumi.String("127.0.0.1"),
 * 					ValueType: pulumi.Int(3),
 * 				},
 * 				&ddos.SchedulerRuleRuleArgs{
 * 					Priority:  pulumi.Int(50),
 * 					RegionId:  pulumi.String("cn-hangzhou"),
 * 					Type:      pulumi.String("A"),
 * 					Value:     pulumi.String("127.0.0.0"),
 * 					ValueType: pulumi.Int(1),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.ddos.SchedulerRule;
 * import com.pulumi.alicloud.ddos.SchedulerRuleArgs;
 * import com.pulumi.alicloud.ddos.inputs.SchedulerRuleRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf-example");
 *         var example = new SchedulerRule("example", SchedulerRuleArgs.builder()
 *             .ruleName(name)
 *             .ruleType(3)
 *             .rules(
 *                 SchedulerRuleRuleArgs.builder()
 *                     .priority(100)
 *                     .regionId("cn-hangzhou")
 *                     .type("A")
 *                     .value("127.0.0.1")
 *                     .valueType(3)
 *                     .build(),
 *                 SchedulerRuleRuleArgs.builder()
 *                     .priority(50)
 *                     .regionId("cn-hangzhou")
 *                     .type("A")
 *                     .value("127.0.0.0")
 *                     .valueType(1)
 *                     .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf-example
 * resources:
 *   example:
 *     type: alicloud:ddos:SchedulerRule
 *     properties:
 *       ruleName: ${name}
 *       ruleType: 3
 *       rules:
 *         - priority: 100
 *           regionId: cn-hangzhou
 *           type: A
 *           value: 127.0.0.1
 *           valueType: 3
 *         - priority: 50
 *           regionId: cn-hangzhou
 *           type: A
 *           value: 127.0.0.0
 *           valueType: 1
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * DdosCoo Scheduler Rule can be imported using the id or the rule name, e.g.
 * ```sh
 * $ pulumi import alicloud:ddos/schedulerRule:SchedulerRule example fbb20dc77e8fc******
 * ```
 * @property param The scheduling rule for the Global Accelerator instance that interacts with Anti-DDoS Pro or Anti-DDoS Premium.
 * @property resourceGroupId The ID of the resource group to which the anti-DDoS pro instance belongs in resource management. By default, no value is specified, indicating that the domains in the default resource group are listed.
 * @property ruleName The name of the rule.
 * @property ruleType The rule type. Valid values:
 * `2`: tiered protection.
 * `3`: globalization acceleration.
 * `6`: Cloud product interaction.
 * @property rules The information about the scheduling rules. See `rules` below.
 */
public data class SchedulerRuleArgs(
    public val `param`: Output<String>? = null,
    public val resourceGroupId: Output<String>? = null,
    public val ruleName: Output<String>? = null,
    public val ruleType: Output<Int>? = null,
    public val rules: Output<List<SchedulerRuleRuleArgs>>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ddos.SchedulerRuleArgs> {
    override fun toJava(): com.pulumi.alicloud.ddos.SchedulerRuleArgs =
        com.pulumi.alicloud.ddos.SchedulerRuleArgs.builder()
            .`param`(`param`?.applyValue({ args0 -> args0 }))
            .resourceGroupId(resourceGroupId?.applyValue({ args0 -> args0 }))
            .ruleName(ruleName?.applyValue({ args0 -> args0 }))
            .ruleType(ruleType?.applyValue({ args0 -> args0 }))
            .rules(
                rules?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [SchedulerRuleArgs].
 */
@PulumiTagMarker
public class SchedulerRuleArgsBuilder internal constructor() {
    private var `param`: Output<String>? = null

    private var resourceGroupId: Output<String>? = null

    private var ruleName: Output<String>? = null

    private var ruleType: Output<Int>? = null

    private var rules: Output<List<SchedulerRuleRuleArgs>>? = null

    /**
     * @param value The scheduling rule for the Global Accelerator instance that interacts with Anti-DDoS Pro or Anti-DDoS Premium.
     */
    @JvmName("kxogpwcpgchvjjua")
    public suspend fun `param`(`value`: Output<String>) {
        this.`param` = value
    }

    /**
     * @param value The ID of the resource group to which the anti-DDoS pro instance belongs in resource management. By default, no value is specified, indicating that the domains in the default resource group are listed.
     */
    @JvmName("jxqnqyfkyeiwboeb")
    public suspend fun resourceGroupId(`value`: Output<String>) {
        this.resourceGroupId = value
    }

    /**
     * @param value The name of the rule.
     */
    @JvmName("aiswgtgilufnowqb")
    public suspend fun ruleName(`value`: Output<String>) {
        this.ruleName = value
    }

    /**
     * @param value The rule type. Valid values:
     * `2`: tiered protection.
     * `3`: globalization acceleration.
     * `6`: Cloud product interaction.
     */
    @JvmName("vbwbcuyhbqwppkcg")
    public suspend fun ruleType(`value`: Output<Int>) {
        this.ruleType = value
    }

    /**
     * @param value The information about the scheduling rules. See `rules` below.
     */
    @JvmName("vhglgabjjglbkahp")
    public suspend fun rules(`value`: Output<List<SchedulerRuleRuleArgs>>) {
        this.rules = value
    }

    @JvmName("gyrsrwrertqjmene")
    public suspend fun rules(vararg values: Output<SchedulerRuleRuleArgs>) {
        this.rules = Output.all(values.asList())
    }

    /**
     * @param values The information about the scheduling rules. See `rules` below.
     */
    @JvmName("ohximqsgntqdnldu")
    public suspend fun rules(values: List<Output<SchedulerRuleRuleArgs>>) {
        this.rules = Output.all(values)
    }

    /**
     * @param value The scheduling rule for the Global Accelerator instance that interacts with Anti-DDoS Pro or Anti-DDoS Premium.
     */
    @JvmName("xboagjoihonlbldr")
    public suspend fun `param`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`param` = mapped
    }

    /**
     * @param value The ID of the resource group to which the anti-DDoS pro instance belongs in resource management. By default, no value is specified, indicating that the domains in the default resource group are listed.
     */
    @JvmName("osgxwphsjakgnucw")
    public suspend fun resourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupId = mapped
    }

    /**
     * @param value The name of the rule.
     */
    @JvmName("dinykahxcmsqubif")
    public suspend fun ruleName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ruleName = mapped
    }

    /**
     * @param value The rule type. Valid values:
     * `2`: tiered protection.
     * `3`: globalization acceleration.
     * `6`: Cloud product interaction.
     */
    @JvmName("cjxnnpvvxcpkaflq")
    public suspend fun ruleType(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ruleType = mapped
    }

    /**
     * @param value The information about the scheduling rules. See `rules` below.
     */
    @JvmName("lhytfjajlidnkmxb")
    public suspend fun rules(`value`: List<SchedulerRuleRuleArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rules = mapped
    }

    /**
     * @param argument The information about the scheduling rules. See `rules` below.
     */
    @JvmName("wumqojobxexhivwx")
    public suspend fun rules(argument: List<suspend SchedulerRuleRuleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            SchedulerRuleRuleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.rules = mapped
    }

    /**
     * @param argument The information about the scheduling rules. See `rules` below.
     */
    @JvmName("lqwrwclfdynqxcva")
    public suspend fun rules(vararg argument: suspend SchedulerRuleRuleArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            SchedulerRuleRuleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.rules = mapped
    }

    /**
     * @param argument The information about the scheduling rules. See `rules` below.
     */
    @JvmName("hywvagvfiyuskerx")
    public suspend fun rules(argument: suspend SchedulerRuleRuleArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(SchedulerRuleRuleArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.rules = mapped
    }

    /**
     * @param values The information about the scheduling rules. See `rules` below.
     */
    @JvmName("gdmagbdshppkayxs")
    public suspend fun rules(vararg values: SchedulerRuleRuleArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rules = mapped
    }

    internal fun build(): SchedulerRuleArgs = SchedulerRuleArgs(
        `param` = `param`,
        resourceGroupId = resourceGroupId,
        ruleName = ruleName,
        ruleType = ruleType,
        rules = rules,
    )
}
