@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ddos.kotlin.inputs

import com.pulumi.alicloud.ddos.inputs.BgpPolicyContentArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property blackIpListExpireAt Blacklist and whitelist timeout.
 * @property enableDefense Whether to enable L4 protection.
 * @property enableDropIcmp Switch to discard ICMP.
 * @property enableIntelligence Whether the intelligent switch is on.
 * @property fingerPrintRuleLists Fingerprint Rules. See `finger_print_rule_list` below.
 * @property intelligenceLevel Smart mode. Valid values: weak, hard, and default.
 * @property layer4RuleLists L4 protection rules. See `layer4_rule_list` below.
 * @property portRuleLists Port Rule List. See `port_rule_list` below.
 * @property reflectBlockUdpPortLists Reflective port filtering.
 * @property regionBlockCountryLists List of Regional Banned Countries.
 * @property regionBlockProvinceLists List of Prohibited Provinces by Region.
 * @property sourceBlockLists Source pull Black. See `source_block_list` below.
 * @property sourceLimit Do not fill in when the source speed limit is deleted. See `source_limit` below.
 * @property whitenGfbrNets Add white high protection back to source network segment switch.
 */
public data class BgpPolicyContentArgs(
    public val blackIpListExpireAt: Output<Int>? = null,
    public val enableDefense: Output<Boolean>? = null,
    public val enableDropIcmp: Output<Boolean>? = null,
    public val enableIntelligence: Output<Boolean>? = null,
    public val fingerPrintRuleLists: Output<List<BgpPolicyContentFingerPrintRuleListArgs>>? = null,
    public val intelligenceLevel: Output<String>? = null,
    public val layer4RuleLists: Output<List<BgpPolicyContentLayer4RuleListArgs>>? = null,
    public val portRuleLists: Output<List<BgpPolicyContentPortRuleListArgs>>? = null,
    public val reflectBlockUdpPortLists: Output<List<Int>>? = null,
    public val regionBlockCountryLists: Output<List<Int>>? = null,
    public val regionBlockProvinceLists: Output<List<Int>>? = null,
    public val sourceBlockLists: Output<List<BgpPolicyContentSourceBlockListArgs>>? = null,
    public val sourceLimit: Output<BgpPolicyContentSourceLimitArgs>? = null,
    public val whitenGfbrNets: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ddos.inputs.BgpPolicyContentArgs> {
    override fun toJava(): com.pulumi.alicloud.ddos.inputs.BgpPolicyContentArgs =
        com.pulumi.alicloud.ddos.inputs.BgpPolicyContentArgs.builder()
            .blackIpListExpireAt(blackIpListExpireAt?.applyValue({ args0 -> args0 }))
            .enableDefense(enableDefense?.applyValue({ args0 -> args0 }))
            .enableDropIcmp(enableDropIcmp?.applyValue({ args0 -> args0 }))
            .enableIntelligence(enableIntelligence?.applyValue({ args0 -> args0 }))
            .fingerPrintRuleLists(
                fingerPrintRuleLists?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .intelligenceLevel(intelligenceLevel?.applyValue({ args0 -> args0 }))
            .layer4RuleLists(
                layer4RuleLists?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .portRuleLists(
                portRuleLists?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .reflectBlockUdpPortLists(
                reflectBlockUdpPortLists?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            )
            .regionBlockCountryLists(
                regionBlockCountryLists?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            )
            .regionBlockProvinceLists(
                regionBlockProvinceLists?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            )
            .sourceBlockLists(
                sourceBlockLists?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .sourceLimit(sourceLimit?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .whitenGfbrNets(whitenGfbrNets?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BgpPolicyContentArgs].
 */
@PulumiTagMarker
public class BgpPolicyContentArgsBuilder internal constructor() {
    private var blackIpListExpireAt: Output<Int>? = null

    private var enableDefense: Output<Boolean>? = null

    private var enableDropIcmp: Output<Boolean>? = null

    private var enableIntelligence: Output<Boolean>? = null

    private var fingerPrintRuleLists: Output<List<BgpPolicyContentFingerPrintRuleListArgs>>? = null

    private var intelligenceLevel: Output<String>? = null

    private var layer4RuleLists: Output<List<BgpPolicyContentLayer4RuleListArgs>>? = null

    private var portRuleLists: Output<List<BgpPolicyContentPortRuleListArgs>>? = null

    private var reflectBlockUdpPortLists: Output<List<Int>>? = null

    private var regionBlockCountryLists: Output<List<Int>>? = null

    private var regionBlockProvinceLists: Output<List<Int>>? = null

    private var sourceBlockLists: Output<List<BgpPolicyContentSourceBlockListArgs>>? = null

    private var sourceLimit: Output<BgpPolicyContentSourceLimitArgs>? = null

    private var whitenGfbrNets: Output<Boolean>? = null

    /**
     * @param value Blacklist and whitelist timeout.
     */
    @JvmName("lnvhsjkwshsytdsb")
    public suspend fun blackIpListExpireAt(`value`: Output<Int>) {
        this.blackIpListExpireAt = value
    }

    /**
     * @param value Whether to enable L4 protection.
     */
    @JvmName("damsndhjcsissmjb")
    public suspend fun enableDefense(`value`: Output<Boolean>) {
        this.enableDefense = value
    }

    /**
     * @param value Switch to discard ICMP.
     */
    @JvmName("efbwhjbqvaienjxu")
    public suspend fun enableDropIcmp(`value`: Output<Boolean>) {
        this.enableDropIcmp = value
    }

    /**
     * @param value Whether the intelligent switch is on.
     */
    @JvmName("mqsfwksqvidoroda")
    public suspend fun enableIntelligence(`value`: Output<Boolean>) {
        this.enableIntelligence = value
    }

    /**
     * @param value Fingerprint Rules. See `finger_print_rule_list` below.
     */
    @JvmName("bnuewdhqukoopabc")
    public suspend fun fingerPrintRuleLists(`value`: Output<List<BgpPolicyContentFingerPrintRuleListArgs>>) {
        this.fingerPrintRuleLists = value
    }

    @JvmName("hpchagumgpqhnyjx")
    public suspend fun fingerPrintRuleLists(vararg values: Output<BgpPolicyContentFingerPrintRuleListArgs>) {
        this.fingerPrintRuleLists = Output.all(values.asList())
    }

    /**
     * @param values Fingerprint Rules. See `finger_print_rule_list` below.
     */
    @JvmName("amafuhftwkrbmnmk")
    public suspend fun fingerPrintRuleLists(values: List<Output<BgpPolicyContentFingerPrintRuleListArgs>>) {
        this.fingerPrintRuleLists = Output.all(values)
    }

    /**
     * @param value Smart mode. Valid values: weak, hard, and default.
     */
    @JvmName("nsjbixgqfhvjjksa")
    public suspend fun intelligenceLevel(`value`: Output<String>) {
        this.intelligenceLevel = value
    }

    /**
     * @param value L4 protection rules. See `layer4_rule_list` below.
     */
    @JvmName("qjjqthyjobodphmj")
    public suspend fun layer4RuleLists(`value`: Output<List<BgpPolicyContentLayer4RuleListArgs>>) {
        this.layer4RuleLists = value
    }

    @JvmName("cjkqbpkvbmbguxhc")
    public suspend fun layer4RuleLists(vararg values: Output<BgpPolicyContentLayer4RuleListArgs>) {
        this.layer4RuleLists = Output.all(values.asList())
    }

    /**
     * @param values L4 protection rules. See `layer4_rule_list` below.
     */
    @JvmName("mtgdhqbicrtjdyfn")
    public suspend fun layer4RuleLists(values: List<Output<BgpPolicyContentLayer4RuleListArgs>>) {
        this.layer4RuleLists = Output.all(values)
    }

    /**
     * @param value Port Rule List. See `port_rule_list` below.
     */
    @JvmName("ogvodyfutexthtmy")
    public suspend fun portRuleLists(`value`: Output<List<BgpPolicyContentPortRuleListArgs>>) {
        this.portRuleLists = value
    }

    @JvmName("gbrfckfbelhfndgt")
    public suspend fun portRuleLists(vararg values: Output<BgpPolicyContentPortRuleListArgs>) {
        this.portRuleLists = Output.all(values.asList())
    }

    /**
     * @param values Port Rule List. See `port_rule_list` below.
     */
    @JvmName("lrsmmlwfwxerrali")
    public suspend fun portRuleLists(values: List<Output<BgpPolicyContentPortRuleListArgs>>) {
        this.portRuleLists = Output.all(values)
    }

    /**
     * @param value Reflective port filtering.
     */
    @JvmName("djuwyklhqaolgayt")
    public suspend fun reflectBlockUdpPortLists(`value`: Output<List<Int>>) {
        this.reflectBlockUdpPortLists = value
    }

    @JvmName("yvjxawkyomsytrcs")
    public suspend fun reflectBlockUdpPortLists(vararg values: Output<Int>) {
        this.reflectBlockUdpPortLists = Output.all(values.asList())
    }

    /**
     * @param values Reflective port filtering.
     */
    @JvmName("rqosgxqiauaovunk")
    public suspend fun reflectBlockUdpPortLists(values: List<Output<Int>>) {
        this.reflectBlockUdpPortLists = Output.all(values)
    }

    /**
     * @param value List of Regional Banned Countries.
     */
    @JvmName("gdqsplmugstpgqgf")
    public suspend fun regionBlockCountryLists(`value`: Output<List<Int>>) {
        this.regionBlockCountryLists = value
    }

    @JvmName("lrtrhsehwbxpdjbf")
    public suspend fun regionBlockCountryLists(vararg values: Output<Int>) {
        this.regionBlockCountryLists = Output.all(values.asList())
    }

    /**
     * @param values List of Regional Banned Countries.
     */
    @JvmName("xgksagsjivgllvfj")
    public suspend fun regionBlockCountryLists(values: List<Output<Int>>) {
        this.regionBlockCountryLists = Output.all(values)
    }

    /**
     * @param value List of Prohibited Provinces by Region.
     */
    @JvmName("cjmpkvkkdcpfipoc")
    public suspend fun regionBlockProvinceLists(`value`: Output<List<Int>>) {
        this.regionBlockProvinceLists = value
    }

    @JvmName("jurwtomrmrnxwmev")
    public suspend fun regionBlockProvinceLists(vararg values: Output<Int>) {
        this.regionBlockProvinceLists = Output.all(values.asList())
    }

    /**
     * @param values List of Prohibited Provinces by Region.
     */
    @JvmName("twyodkvmrkwwbtyx")
    public suspend fun regionBlockProvinceLists(values: List<Output<Int>>) {
        this.regionBlockProvinceLists = Output.all(values)
    }

    /**
     * @param value Source pull Black. See `source_block_list` below.
     */
    @JvmName("ymemlodanslbdssl")
    public suspend fun sourceBlockLists(`value`: Output<List<BgpPolicyContentSourceBlockListArgs>>) {
        this.sourceBlockLists = value
    }

    @JvmName("ionhnsfvscwtjvcq")
    public suspend fun sourceBlockLists(vararg values: Output<BgpPolicyContentSourceBlockListArgs>) {
        this.sourceBlockLists = Output.all(values.asList())
    }

    /**
     * @param values Source pull Black. See `source_block_list` below.
     */
    @JvmName("joayjfiwhnxvrcpp")
    public suspend fun sourceBlockLists(values: List<Output<BgpPolicyContentSourceBlockListArgs>>) {
        this.sourceBlockLists = Output.all(values)
    }

    /**
     * @param value Do not fill in when the source speed limit is deleted. See `source_limit` below.
     */
    @JvmName("cwqoxdphgpmcsubn")
    public suspend fun sourceLimit(`value`: Output<BgpPolicyContentSourceLimitArgs>) {
        this.sourceLimit = value
    }

    /**
     * @param value Add white high protection back to source network segment switch.
     */
    @JvmName("wnlpqjuyeckbuhhb")
    public suspend fun whitenGfbrNets(`value`: Output<Boolean>) {
        this.whitenGfbrNets = value
    }

    /**
     * @param value Blacklist and whitelist timeout.
     */
    @JvmName("mnbrnpcdlmerkdkr")
    public suspend fun blackIpListExpireAt(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.blackIpListExpireAt = mapped
    }

    /**
     * @param value Whether to enable L4 protection.
     */
    @JvmName("vemuqioidvjnogvu")
    public suspend fun enableDefense(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableDefense = mapped
    }

    /**
     * @param value Switch to discard ICMP.
     */
    @JvmName("mxaxsxvffslbsfbx")
    public suspend fun enableDropIcmp(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableDropIcmp = mapped
    }

    /**
     * @param value Whether the intelligent switch is on.
     */
    @JvmName("mcxpcslokdctwxru")
    public suspend fun enableIntelligence(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableIntelligence = mapped
    }

    /**
     * @param value Fingerprint Rules. See `finger_print_rule_list` below.
     */
    @JvmName("coylpcrtjcdtecvc")
    public suspend fun fingerPrintRuleLists(`value`: List<BgpPolicyContentFingerPrintRuleListArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fingerPrintRuleLists = mapped
    }

    /**
     * @param argument Fingerprint Rules. See `finger_print_rule_list` below.
     */
    @JvmName("hbryyvqimndefamb")
    public suspend fun fingerPrintRuleLists(argument: List<suspend BgpPolicyContentFingerPrintRuleListArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            BgpPolicyContentFingerPrintRuleListArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.fingerPrintRuleLists = mapped
    }

    /**
     * @param argument Fingerprint Rules. See `finger_print_rule_list` below.
     */
    @JvmName("jkhaydtmgcocdlxt")
    public suspend fun fingerPrintRuleLists(vararg argument: suspend BgpPolicyContentFingerPrintRuleListArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            BgpPolicyContentFingerPrintRuleListArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.fingerPrintRuleLists = mapped
    }

    /**
     * @param argument Fingerprint Rules. See `finger_print_rule_list` below.
     */
    @JvmName("aaathvsthjapnrbo")
    public suspend fun fingerPrintRuleLists(argument: suspend BgpPolicyContentFingerPrintRuleListArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            BgpPolicyContentFingerPrintRuleListArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.fingerPrintRuleLists = mapped
    }

    /**
     * @param values Fingerprint Rules. See `finger_print_rule_list` below.
     */
    @JvmName("pfteerkwllsrsihw")
    public suspend fun fingerPrintRuleLists(vararg values: BgpPolicyContentFingerPrintRuleListArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.fingerPrintRuleLists = mapped
    }

    /**
     * @param value Smart mode. Valid values: weak, hard, and default.
     */
    @JvmName("rgtweaxhgetqhvui")
    public suspend fun intelligenceLevel(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.intelligenceLevel = mapped
    }

    /**
     * @param value L4 protection rules. See `layer4_rule_list` below.
     */
    @JvmName("furppnnuqkpdoiat")
    public suspend fun layer4RuleLists(`value`: List<BgpPolicyContentLayer4RuleListArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.layer4RuleLists = mapped
    }

    /**
     * @param argument L4 protection rules. See `layer4_rule_list` below.
     */
    @JvmName("ukkgjpnarxlpoxgm")
    public suspend fun layer4RuleLists(argument: List<suspend BgpPolicyContentLayer4RuleListArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            BgpPolicyContentLayer4RuleListArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.layer4RuleLists = mapped
    }

    /**
     * @param argument L4 protection rules. See `layer4_rule_list` below.
     */
    @JvmName("fejmiqwbkysalimw")
    public suspend fun layer4RuleLists(vararg argument: suspend BgpPolicyContentLayer4RuleListArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            BgpPolicyContentLayer4RuleListArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.layer4RuleLists = mapped
    }

    /**
     * @param argument L4 protection rules. See `layer4_rule_list` below.
     */
    @JvmName("ugngbuuqbobfhgnm")
    public suspend fun layer4RuleLists(argument: suspend BgpPolicyContentLayer4RuleListArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            BgpPolicyContentLayer4RuleListArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.layer4RuleLists = mapped
    }

    /**
     * @param values L4 protection rules. See `layer4_rule_list` below.
     */
    @JvmName("vrftteodirsaqqdb")
    public suspend fun layer4RuleLists(vararg values: BgpPolicyContentLayer4RuleListArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.layer4RuleLists = mapped
    }

    /**
     * @param value Port Rule List. See `port_rule_list` below.
     */
    @JvmName("ywaehmgbkkmkokys")
    public suspend fun portRuleLists(`value`: List<BgpPolicyContentPortRuleListArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.portRuleLists = mapped
    }

    /**
     * @param argument Port Rule List. See `port_rule_list` below.
     */
    @JvmName("lgopypdnmsntapyv")
    public suspend fun portRuleLists(argument: List<suspend BgpPolicyContentPortRuleListArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            BgpPolicyContentPortRuleListArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.portRuleLists = mapped
    }

    /**
     * @param argument Port Rule List. See `port_rule_list` below.
     */
    @JvmName("jekiuoyipflaavlp")
    public suspend fun portRuleLists(vararg argument: suspend BgpPolicyContentPortRuleListArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            BgpPolicyContentPortRuleListArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.portRuleLists = mapped
    }

    /**
     * @param argument Port Rule List. See `port_rule_list` below.
     */
    @JvmName("rglbykyowmcvkssu")
    public suspend fun portRuleLists(argument: suspend BgpPolicyContentPortRuleListArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            BgpPolicyContentPortRuleListArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.portRuleLists = mapped
    }

    /**
     * @param values Port Rule List. See `port_rule_list` below.
     */
    @JvmName("mkfkbafkautqmbjn")
    public suspend fun portRuleLists(vararg values: BgpPolicyContentPortRuleListArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.portRuleLists = mapped
    }

    /**
     * @param value Reflective port filtering.
     */
    @JvmName("wnvxwqngusjllmiv")
    public suspend fun reflectBlockUdpPortLists(`value`: List<Int>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.reflectBlockUdpPortLists = mapped
    }

    /**
     * @param values Reflective port filtering.
     */
    @JvmName("qmmejriyvgueoqsh")
    public suspend fun reflectBlockUdpPortLists(vararg values: Int) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.reflectBlockUdpPortLists = mapped
    }

    /**
     * @param value List of Regional Banned Countries.
     */
    @JvmName("pnvtwobbgluuyucm")
    public suspend fun regionBlockCountryLists(`value`: List<Int>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.regionBlockCountryLists = mapped
    }

    /**
     * @param values List of Regional Banned Countries.
     */
    @JvmName("ebunsyalgonicubj")
    public suspend fun regionBlockCountryLists(vararg values: Int) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.regionBlockCountryLists = mapped
    }

    /**
     * @param value List of Prohibited Provinces by Region.
     */
    @JvmName("xjtsdxovabuqncvp")
    public suspend fun regionBlockProvinceLists(`value`: List<Int>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.regionBlockProvinceLists = mapped
    }

    /**
     * @param values List of Prohibited Provinces by Region.
     */
    @JvmName("jhcpjvhvsqwrhxae")
    public suspend fun regionBlockProvinceLists(vararg values: Int) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.regionBlockProvinceLists = mapped
    }

    /**
     * @param value Source pull Black. See `source_block_list` below.
     */
    @JvmName("wwkoyywnhfbxydrf")
    public suspend fun sourceBlockLists(`value`: List<BgpPolicyContentSourceBlockListArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceBlockLists = mapped
    }

    /**
     * @param argument Source pull Black. See `source_block_list` below.
     */
    @JvmName("nmkqksvvhjjsuxdv")
    public suspend fun sourceBlockLists(argument: List<suspend BgpPolicyContentSourceBlockListArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            BgpPolicyContentSourceBlockListArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.sourceBlockLists = mapped
    }

    /**
     * @param argument Source pull Black. See `source_block_list` below.
     */
    @JvmName("ibjjvohekxvqatsj")
    public suspend fun sourceBlockLists(vararg argument: suspend BgpPolicyContentSourceBlockListArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            BgpPolicyContentSourceBlockListArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.sourceBlockLists = mapped
    }

    /**
     * @param argument Source pull Black. See `source_block_list` below.
     */
    @JvmName("chloiocdunsdwkua")
    public suspend fun sourceBlockLists(argument: suspend BgpPolicyContentSourceBlockListArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            BgpPolicyContentSourceBlockListArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.sourceBlockLists = mapped
    }

    /**
     * @param values Source pull Black. See `source_block_list` below.
     */
    @JvmName("kdgllaesbpksdkuq")
    public suspend fun sourceBlockLists(vararg values: BgpPolicyContentSourceBlockListArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sourceBlockLists = mapped
    }

    /**
     * @param value Do not fill in when the source speed limit is deleted. See `source_limit` below.
     */
    @JvmName("fdjtxjibjiihtumd")
    public suspend fun sourceLimit(`value`: BgpPolicyContentSourceLimitArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceLimit = mapped
    }

    /**
     * @param argument Do not fill in when the source speed limit is deleted. See `source_limit` below.
     */
    @JvmName("qwrcakctyhcgutlp")
    public suspend fun sourceLimit(argument: suspend BgpPolicyContentSourceLimitArgsBuilder.() -> Unit) {
        val toBeMapped = BgpPolicyContentSourceLimitArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sourceLimit = mapped
    }

    /**
     * @param value Add white high protection back to source network segment switch.
     */
    @JvmName("rvuohxsikqhgcusx")
    public suspend fun whitenGfbrNets(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.whitenGfbrNets = mapped
    }

    internal fun build(): BgpPolicyContentArgs = BgpPolicyContentArgs(
        blackIpListExpireAt = blackIpListExpireAt,
        enableDefense = enableDefense,
        enableDropIcmp = enableDropIcmp,
        enableIntelligence = enableIntelligence,
        fingerPrintRuleLists = fingerPrintRuleLists,
        intelligenceLevel = intelligenceLevel,
        layer4RuleLists = layer4RuleLists,
        portRuleLists = portRuleLists,
        reflectBlockUdpPortLists = reflectBlockUdpPortLists,
        regionBlockCountryLists = regionBlockCountryLists,
        regionBlockProvinceLists = regionBlockProvinceLists,
        sourceBlockLists = sourceBlockLists,
        sourceLimit = sourceLimit,
        whitenGfbrNets = whitenGfbrNets,
    )
}
