@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ddos.kotlin.inputs

import com.pulumi.alicloud.ddos.inputs.BgpPolicyContentFingerPrintRuleListArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property dstPortEnd End of destination port 0-65535.
 * @property dstPortStart Destination Port start 0-65535.
 * @property fingerPrintRuleId The UUID of the rule is required to be deleted and modified, and it is not required to be created.
 * @property matchAction Action. Currently, only drop is supported.
 * @property maxPktLen Maximum bag length.
 * @property minPktLen Minimum package length.
 * @property offset Offset.
 * @property payloadBytes Load match, hexadecimal string; Similar to 'abcd'.
 * @property protocol Protocol, tcp or udp.
 * @property rateValue Speed limit value 1-100000.
 * @property seqNo Serial number 1-100 ● Affects the order issued by the bottom layer ● The larger the number, the lower it is.
 * @property srcPortEnd Source Port end 0-65535.
 * @property srcPortStart Source port start 0-65535.
 */
public data class BgpPolicyContentFingerPrintRuleListArgs(
    public val dstPortEnd: Output<Int>,
    public val dstPortStart: Output<Int>,
    public val fingerPrintRuleId: Output<String>? = null,
    public val matchAction: Output<String>,
    public val maxPktLen: Output<Int>,
    public val minPktLen: Output<Int>,
    public val offset: Output<Int>? = null,
    public val payloadBytes: Output<String>? = null,
    public val protocol: Output<String>,
    public val rateValue: Output<Int>? = null,
    public val seqNo: Output<Int>,
    public val srcPortEnd: Output<Int>,
    public val srcPortStart: Output<Int>,
) : ConvertibleToJava<com.pulumi.alicloud.ddos.inputs.BgpPolicyContentFingerPrintRuleListArgs> {
    override fun toJava(): com.pulumi.alicloud.ddos.inputs.BgpPolicyContentFingerPrintRuleListArgs =
        com.pulumi.alicloud.ddos.inputs.BgpPolicyContentFingerPrintRuleListArgs.builder()
            .dstPortEnd(dstPortEnd.applyValue({ args0 -> args0 }))
            .dstPortStart(dstPortStart.applyValue({ args0 -> args0 }))
            .fingerPrintRuleId(fingerPrintRuleId?.applyValue({ args0 -> args0 }))
            .matchAction(matchAction.applyValue({ args0 -> args0 }))
            .maxPktLen(maxPktLen.applyValue({ args0 -> args0 }))
            .minPktLen(minPktLen.applyValue({ args0 -> args0 }))
            .offset(offset?.applyValue({ args0 -> args0 }))
            .payloadBytes(payloadBytes?.applyValue({ args0 -> args0 }))
            .protocol(protocol.applyValue({ args0 -> args0 }))
            .rateValue(rateValue?.applyValue({ args0 -> args0 }))
            .seqNo(seqNo.applyValue({ args0 -> args0 }))
            .srcPortEnd(srcPortEnd.applyValue({ args0 -> args0 }))
            .srcPortStart(srcPortStart.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BgpPolicyContentFingerPrintRuleListArgs].
 */
@PulumiTagMarker
public class BgpPolicyContentFingerPrintRuleListArgsBuilder internal constructor() {
    private var dstPortEnd: Output<Int>? = null

    private var dstPortStart: Output<Int>? = null

    private var fingerPrintRuleId: Output<String>? = null

    private var matchAction: Output<String>? = null

    private var maxPktLen: Output<Int>? = null

    private var minPktLen: Output<Int>? = null

    private var offset: Output<Int>? = null

    private var payloadBytes: Output<String>? = null

    private var protocol: Output<String>? = null

    private var rateValue: Output<Int>? = null

    private var seqNo: Output<Int>? = null

    private var srcPortEnd: Output<Int>? = null

    private var srcPortStart: Output<Int>? = null

    /**
     * @param value End of destination port 0-65535.
     */
    @JvmName("cbxaffkkyldoyjjo")
    public suspend fun dstPortEnd(`value`: Output<Int>) {
        this.dstPortEnd = value
    }

    /**
     * @param value Destination Port start 0-65535.
     */
    @JvmName("enflrsgkcdcuhyby")
    public suspend fun dstPortStart(`value`: Output<Int>) {
        this.dstPortStart = value
    }

    /**
     * @param value The UUID of the rule is required to be deleted and modified, and it is not required to be created.
     */
    @JvmName("vnhqwdwstwocmiki")
    public suspend fun fingerPrintRuleId(`value`: Output<String>) {
        this.fingerPrintRuleId = value
    }

    /**
     * @param value Action. Currently, only drop is supported.
     */
    @JvmName("trfgrfbbtnindjtx")
    public suspend fun matchAction(`value`: Output<String>) {
        this.matchAction = value
    }

    /**
     * @param value Maximum bag length.
     */
    @JvmName("yjnejfcdinynhnpn")
    public suspend fun maxPktLen(`value`: Output<Int>) {
        this.maxPktLen = value
    }

    /**
     * @param value Minimum package length.
     */
    @JvmName("swxhivvkfrixunjd")
    public suspend fun minPktLen(`value`: Output<Int>) {
        this.minPktLen = value
    }

    /**
     * @param value Offset.
     */
    @JvmName("mythyyvglfdmvjqk")
    public suspend fun offset(`value`: Output<Int>) {
        this.offset = value
    }

    /**
     * @param value Load match, hexadecimal string; Similar to 'abcd'.
     */
    @JvmName("uajlteqmybgrdjqn")
    public suspend fun payloadBytes(`value`: Output<String>) {
        this.payloadBytes = value
    }

    /**
     * @param value Protocol, tcp or udp.
     */
    @JvmName("bownaatmubaipala")
    public suspend fun protocol(`value`: Output<String>) {
        this.protocol = value
    }

    /**
     * @param value Speed limit value 1-100000.
     */
    @JvmName("gdxxgvxggehpchsd")
    public suspend fun rateValue(`value`: Output<Int>) {
        this.rateValue = value
    }

    /**
     * @param value Serial number 1-100 ● Affects the order issued by the bottom layer ● The larger the number, the lower it is.
     */
    @JvmName("vcwkicvaesgxshcl")
    public suspend fun seqNo(`value`: Output<Int>) {
        this.seqNo = value
    }

    /**
     * @param value Source Port end 0-65535.
     */
    @JvmName("nnbxaarpjpeswvls")
    public suspend fun srcPortEnd(`value`: Output<Int>) {
        this.srcPortEnd = value
    }

    /**
     * @param value Source port start 0-65535.
     */
    @JvmName("uymeigbdsnqaxlya")
    public suspend fun srcPortStart(`value`: Output<Int>) {
        this.srcPortStart = value
    }

    /**
     * @param value End of destination port 0-65535.
     */
    @JvmName("wtgbbkevjjxvnbui")
    public suspend fun dstPortEnd(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dstPortEnd = mapped
    }

    /**
     * @param value Destination Port start 0-65535.
     */
    @JvmName("rwknhjuvfusytlyo")
    public suspend fun dstPortStart(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dstPortStart = mapped
    }

    /**
     * @param value The UUID of the rule is required to be deleted and modified, and it is not required to be created.
     */
    @JvmName("dkuiblcjsgyuqomh")
    public suspend fun fingerPrintRuleId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fingerPrintRuleId = mapped
    }

    /**
     * @param value Action. Currently, only drop is supported.
     */
    @JvmName("kuwprlkbcprvkqnp")
    public suspend fun matchAction(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.matchAction = mapped
    }

    /**
     * @param value Maximum bag length.
     */
    @JvmName("ylrbvpkyvvjdtwnj")
    public suspend fun maxPktLen(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.maxPktLen = mapped
    }

    /**
     * @param value Minimum package length.
     */
    @JvmName("eqxgayalkldqxeyl")
    public suspend fun minPktLen(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.minPktLen = mapped
    }

    /**
     * @param value Offset.
     */
    @JvmName("fuamdhlpqriierpd")
    public suspend fun offset(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.offset = mapped
    }

    /**
     * @param value Load match, hexadecimal string; Similar to 'abcd'.
     */
    @JvmName("trsjlrsxcglowmho")
    public suspend fun payloadBytes(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.payloadBytes = mapped
    }

    /**
     * @param value Protocol, tcp or udp.
     */
    @JvmName("tmywfrrjiemipfgc")
    public suspend fun protocol(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    /**
     * @param value Speed limit value 1-100000.
     */
    @JvmName("xgqrbiahohdbywhn")
    public suspend fun rateValue(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rateValue = mapped
    }

    /**
     * @param value Serial number 1-100 ● Affects the order issued by the bottom layer ● The larger the number, the lower it is.
     */
    @JvmName("njyjwtddqaypldik")
    public suspend fun seqNo(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.seqNo = mapped
    }

    /**
     * @param value Source Port end 0-65535.
     */
    @JvmName("gnlaomkvntrsqjyl")
    public suspend fun srcPortEnd(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.srcPortEnd = mapped
    }

    /**
     * @param value Source port start 0-65535.
     */
    @JvmName("tbbdnyysxlrjfqqe")
    public suspend fun srcPortStart(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.srcPortStart = mapped
    }

    internal fun build(): BgpPolicyContentFingerPrintRuleListArgs =
        BgpPolicyContentFingerPrintRuleListArgs(
            dstPortEnd = dstPortEnd ?: throw PulumiNullFieldException("dstPortEnd"),
            dstPortStart = dstPortStart ?: throw PulumiNullFieldException("dstPortStart"),
            fingerPrintRuleId = fingerPrintRuleId,
            matchAction = matchAction ?: throw PulumiNullFieldException("matchAction"),
            maxPktLen = maxPktLen ?: throw PulumiNullFieldException("maxPktLen"),
            minPktLen = minPktLen ?: throw PulumiNullFieldException("minPktLen"),
            offset = offset,
            payloadBytes = payloadBytes,
            protocol = protocol ?: throw PulumiNullFieldException("protocol"),
            rateValue = rateValue,
            seqNo = seqNo ?: throw PulumiNullFieldException("seqNo"),
            srcPortEnd = srcPortEnd ?: throw PulumiNullFieldException("srcPortEnd"),
            srcPortStart = srcPortStart ?: throw PulumiNullFieldException("srcPortStart"),
        )
}
