@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ddos.kotlin.inputs

import com.pulumi.alicloud.ddos.inputs.BgpPolicyContentLayer4RuleListArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property action 1 for observation 2 for blocking.
 * @property conditionLists Matching Condition. See `condition_list` below.
 * @property limited .
 * @property match 0 indicates that the condition is not met 1 indicates that the condition is met.
 * @property method Char indicates a string match hex match.
 * @property name Rule Name.
 * @property priority 1-100, priority, the lower the number, the higher the priority.
 */
public data class BgpPolicyContentLayer4RuleListArgs(
    public val action: Output<String>,
    public val conditionLists: Output<List<BgpPolicyContentLayer4RuleListConditionListArgs>>,
    public val limited: Output<Int>,
    public val match: Output<String>,
    public val method: Output<String>,
    public val name: Output<String>,
    public val priority: Output<Int>,
) : ConvertibleToJava<com.pulumi.alicloud.ddos.inputs.BgpPolicyContentLayer4RuleListArgs> {
    override fun toJava(): com.pulumi.alicloud.ddos.inputs.BgpPolicyContentLayer4RuleListArgs =
        com.pulumi.alicloud.ddos.inputs.BgpPolicyContentLayer4RuleListArgs.builder()
            .action(action.applyValue({ args0 -> args0 }))
            .conditionLists(
                conditionLists.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .limited(limited.applyValue({ args0 -> args0 }))
            .match(match.applyValue({ args0 -> args0 }))
            .method(method.applyValue({ args0 -> args0 }))
            .name(name.applyValue({ args0 -> args0 }))
            .priority(priority.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BgpPolicyContentLayer4RuleListArgs].
 */
@PulumiTagMarker
public class BgpPolicyContentLayer4RuleListArgsBuilder internal constructor() {
    private var action: Output<String>? = null

    private var conditionLists: Output<List<BgpPolicyContentLayer4RuleListConditionListArgs>>? = null

    private var limited: Output<Int>? = null

    private var match: Output<String>? = null

    private var method: Output<String>? = null

    private var name: Output<String>? = null

    private var priority: Output<Int>? = null

    /**
     * @param value 1 for observation 2 for blocking.
     */
    @JvmName("livcrxglilhbnxgu")
    public suspend fun action(`value`: Output<String>) {
        this.action = value
    }

    /**
     * @param value Matching Condition. See `condition_list` below.
     */
    @JvmName("ievsjdsgfacqvcdu")
    public suspend fun conditionLists(`value`: Output<List<BgpPolicyContentLayer4RuleListConditionListArgs>>) {
        this.conditionLists = value
    }

    @JvmName("frpknafxrhybkyaf")
    public suspend fun conditionLists(vararg values: Output<BgpPolicyContentLayer4RuleListConditionListArgs>) {
        this.conditionLists = Output.all(values.asList())
    }

    /**
     * @param values Matching Condition. See `condition_list` below.
     */
    @JvmName("uvongvmingqbpgfs")
    public suspend fun conditionLists(values: List<Output<BgpPolicyContentLayer4RuleListConditionListArgs>>) {
        this.conditionLists = Output.all(values)
    }

    /**
     * @param value .
     */
    @JvmName("wrrenvqhdvckoijm")
    public suspend fun limited(`value`: Output<Int>) {
        this.limited = value
    }

    /**
     * @param value 0 indicates that the condition is not met 1 indicates that the condition is met.
     */
    @JvmName("ycpykflrglunched")
    public suspend fun match(`value`: Output<String>) {
        this.match = value
    }

    /**
     * @param value Char indicates a string match hex match.
     */
    @JvmName("hchkamlesjntmftx")
    public suspend fun method(`value`: Output<String>) {
        this.method = value
    }

    /**
     * @param value Rule Name.
     */
    @JvmName("aldpfugtpuiticog")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value 1-100, priority, the lower the number, the higher the priority.
     */
    @JvmName("ebksjoaxsvdmipji")
    public suspend fun priority(`value`: Output<Int>) {
        this.priority = value
    }

    /**
     * @param value 1 for observation 2 for blocking.
     */
    @JvmName("wbylbvrkstbhvfyh")
    public suspend fun action(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.action = mapped
    }

    /**
     * @param value Matching Condition. See `condition_list` below.
     */
    @JvmName("qrqkalrahygunbav")
    public suspend fun conditionLists(`value`: List<BgpPolicyContentLayer4RuleListConditionListArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.conditionLists = mapped
    }

    /**
     * @param argument Matching Condition. See `condition_list` below.
     */
    @JvmName("gojfppghsfvcownk")
    public suspend fun conditionLists(argument: List<suspend BgpPolicyContentLayer4RuleListConditionListArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            BgpPolicyContentLayer4RuleListConditionListArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.conditionLists = mapped
    }

    /**
     * @param argument Matching Condition. See `condition_list` below.
     */
    @JvmName("fxfkejvgjvxqqbyb")
    public suspend fun conditionLists(vararg argument: suspend BgpPolicyContentLayer4RuleListConditionListArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            BgpPolicyContentLayer4RuleListConditionListArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.conditionLists = mapped
    }

    /**
     * @param argument Matching Condition. See `condition_list` below.
     */
    @JvmName("lfquiqveljcsynxc")
    public suspend fun conditionLists(argument: suspend BgpPolicyContentLayer4RuleListConditionListArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            BgpPolicyContentLayer4RuleListConditionListArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.conditionLists = mapped
    }

    /**
     * @param values Matching Condition. See `condition_list` below.
     */
    @JvmName("udcakbtlpudhnlhm")
    public suspend fun conditionLists(vararg values: BgpPolicyContentLayer4RuleListConditionListArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.conditionLists = mapped
    }

    /**
     * @param value .
     */
    @JvmName("ibtnwhurmjkmhppd")
    public suspend fun limited(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.limited = mapped
    }

    /**
     * @param value 0 indicates that the condition is not met 1 indicates that the condition is met.
     */
    @JvmName("fetobedvuooejmxm")
    public suspend fun match(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.match = mapped
    }

    /**
     * @param value Char indicates a string match hex match.
     */
    @JvmName("okaknvrhrvdbbqqn")
    public suspend fun method(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.method = mapped
    }

    /**
     * @param value Rule Name.
     */
    @JvmName("momkhwttitsysumn")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value 1-100, priority, the lower the number, the higher the priority.
     */
    @JvmName("tswcgscyrfpeuuix")
    public suspend fun priority(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.priority = mapped
    }

    internal fun build(): BgpPolicyContentLayer4RuleListArgs = BgpPolicyContentLayer4RuleListArgs(
        action = action ?: throw PulumiNullFieldException("action"),
        conditionLists = conditionLists ?: throw PulumiNullFieldException("conditionLists"),
        limited = limited ?: throw PulumiNullFieldException("limited"),
        match = match ?: throw PulumiNullFieldException("match"),
        method = method ?: throw PulumiNullFieldException("method"),
        name = name ?: throw PulumiNullFieldException("name"),
        priority = priority ?: throw PulumiNullFieldException("priority"),
    )
}
