@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ddos.kotlin.inputs

import com.pulumi.alicloud.ddos.inputs.BgpPolicyContentLayer4RuleListConditionListArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property arg Matching target character.
 * @property depth Depth of Matching.
 * @property position Position to start matching, starting from 0.
 */
public data class BgpPolicyContentLayer4RuleListConditionListArgs(
    public val arg: Output<String>,
    public val depth: Output<Int>,
    public val position: Output<Int>,
) :
    ConvertibleToJava<com.pulumi.alicloud.ddos.inputs.BgpPolicyContentLayer4RuleListConditionListArgs> {
    override fun toJava(): com.pulumi.alicloud.ddos.inputs.BgpPolicyContentLayer4RuleListConditionListArgs =
        com.pulumi.alicloud.ddos.inputs.BgpPolicyContentLayer4RuleListConditionListArgs.builder()
            .arg(arg.applyValue({ args0 -> args0 }))
            .depth(depth.applyValue({ args0 -> args0 }))
            .position(position.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BgpPolicyContentLayer4RuleListConditionListArgs].
 */
@PulumiTagMarker
public class BgpPolicyContentLayer4RuleListConditionListArgsBuilder internal constructor() {
    private var arg: Output<String>? = null

    private var depth: Output<Int>? = null

    private var position: Output<Int>? = null

    /**
     * @param value Matching target character.
     */
    @JvmName("xwcmgcycarkhvalw")
    public suspend fun arg(`value`: Output<String>) {
        this.arg = value
    }

    /**
     * @param value Depth of Matching.
     */
    @JvmName("moliuwskhkcsscea")
    public suspend fun depth(`value`: Output<Int>) {
        this.depth = value
    }

    /**
     * @param value Position to start matching, starting from 0.
     */
    @JvmName("plntxmucalfnthwv")
    public suspend fun position(`value`: Output<Int>) {
        this.position = value
    }

    /**
     * @param value Matching target character.
     */
    @JvmName("gplxulfipleeagpn")
    public suspend fun arg(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.arg = mapped
    }

    /**
     * @param value Depth of Matching.
     */
    @JvmName("uhuvcfsjwpnpwaxf")
    public suspend fun depth(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.depth = mapped
    }

    /**
     * @param value Position to start matching, starting from 0.
     */
    @JvmName("wumwtjypddkyachu")
    public suspend fun position(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.position = mapped
    }

    internal fun build(): BgpPolicyContentLayer4RuleListConditionListArgs =
        BgpPolicyContentLayer4RuleListConditionListArgs(
            arg = arg ?: throw PulumiNullFieldException("arg"),
            depth = depth ?: throw PulumiNullFieldException("depth"),
            position = position ?: throw PulumiNullFieldException("position"),
        )
}
