@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ddos.kotlin.inputs

import com.pulumi.alicloud.ddos.inputs.BgpPolicyContentPortRuleListArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property dstPortEnd End of destination port 0-65535.
 * @property dstPortStart Destination Port start 0-65535.
 * @property matchAction Action. Currently, only drop is supported.
 * @property portRuleId Rule UUID is required to be deleted and modified, and is not required to be created.
 * @property protocol Protocol, tcp or udp.
 * @property seqNo Serial number 1-100 ● Affects the order issued by the bottom layer ● The larger the number, the lower it is.
 * @property srcPortEnd Source Port end 0-65535.
 * @property srcPortStart Source port start 0-65535.
 */
public data class BgpPolicyContentPortRuleListArgs(
    public val dstPortEnd: Output<Int>,
    public val dstPortStart: Output<Int>,
    public val matchAction: Output<String>,
    public val portRuleId: Output<String>? = null,
    public val protocol: Output<String>,
    public val seqNo: Output<Int>,
    public val srcPortEnd: Output<Int>,
    public val srcPortStart: Output<Int>,
) : ConvertibleToJava<com.pulumi.alicloud.ddos.inputs.BgpPolicyContentPortRuleListArgs> {
    override fun toJava(): com.pulumi.alicloud.ddos.inputs.BgpPolicyContentPortRuleListArgs =
        com.pulumi.alicloud.ddos.inputs.BgpPolicyContentPortRuleListArgs.builder()
            .dstPortEnd(dstPortEnd.applyValue({ args0 -> args0 }))
            .dstPortStart(dstPortStart.applyValue({ args0 -> args0 }))
            .matchAction(matchAction.applyValue({ args0 -> args0 }))
            .portRuleId(portRuleId?.applyValue({ args0 -> args0 }))
            .protocol(protocol.applyValue({ args0 -> args0 }))
            .seqNo(seqNo.applyValue({ args0 -> args0 }))
            .srcPortEnd(srcPortEnd.applyValue({ args0 -> args0 }))
            .srcPortStart(srcPortStart.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BgpPolicyContentPortRuleListArgs].
 */
@PulumiTagMarker
public class BgpPolicyContentPortRuleListArgsBuilder internal constructor() {
    private var dstPortEnd: Output<Int>? = null

    private var dstPortStart: Output<Int>? = null

    private var matchAction: Output<String>? = null

    private var portRuleId: Output<String>? = null

    private var protocol: Output<String>? = null

    private var seqNo: Output<Int>? = null

    private var srcPortEnd: Output<Int>? = null

    private var srcPortStart: Output<Int>? = null

    /**
     * @param value End of destination port 0-65535.
     */
    @JvmName("mhfwtttejntgsxfp")
    public suspend fun dstPortEnd(`value`: Output<Int>) {
        this.dstPortEnd = value
    }

    /**
     * @param value Destination Port start 0-65535.
     */
    @JvmName("uugygeupjbbrbiax")
    public suspend fun dstPortStart(`value`: Output<Int>) {
        this.dstPortStart = value
    }

    /**
     * @param value Action. Currently, only drop is supported.
     */
    @JvmName("jcyledvmtfbhvoap")
    public suspend fun matchAction(`value`: Output<String>) {
        this.matchAction = value
    }

    /**
     * @param value Rule UUID is required to be deleted and modified, and is not required to be created.
     */
    @JvmName("gykvrlgunkyvrojf")
    public suspend fun portRuleId(`value`: Output<String>) {
        this.portRuleId = value
    }

    /**
     * @param value Protocol, tcp or udp.
     */
    @JvmName("eixaqjrnarovfjlp")
    public suspend fun protocol(`value`: Output<String>) {
        this.protocol = value
    }

    /**
     * @param value Serial number 1-100 ● Affects the order issued by the bottom layer ● The larger the number, the lower it is.
     */
    @JvmName("alnkbkrjeqwshfsk")
    public suspend fun seqNo(`value`: Output<Int>) {
        this.seqNo = value
    }

    /**
     * @param value Source Port end 0-65535.
     */
    @JvmName("umpkxwwdcatatpaf")
    public suspend fun srcPortEnd(`value`: Output<Int>) {
        this.srcPortEnd = value
    }

    /**
     * @param value Source port start 0-65535.
     */
    @JvmName("jojkloxhlmfgqoui")
    public suspend fun srcPortStart(`value`: Output<Int>) {
        this.srcPortStart = value
    }

    /**
     * @param value End of destination port 0-65535.
     */
    @JvmName("fmgfnppfmxuahxca")
    public suspend fun dstPortEnd(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dstPortEnd = mapped
    }

    /**
     * @param value Destination Port start 0-65535.
     */
    @JvmName("sbeeehqwgcqsmlwo")
    public suspend fun dstPortStart(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dstPortStart = mapped
    }

    /**
     * @param value Action. Currently, only drop is supported.
     */
    @JvmName("egrwebcvgpgcgvmk")
    public suspend fun matchAction(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.matchAction = mapped
    }

    /**
     * @param value Rule UUID is required to be deleted and modified, and is not required to be created.
     */
    @JvmName("xabydpxrjhftfwyd")
    public suspend fun portRuleId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.portRuleId = mapped
    }

    /**
     * @param value Protocol, tcp or udp.
     */
    @JvmName("exaoorkdogtseagl")
    public suspend fun protocol(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    /**
     * @param value Serial number 1-100 ● Affects the order issued by the bottom layer ● The larger the number, the lower it is.
     */
    @JvmName("wlhdeonawfkvbvrb")
    public suspend fun seqNo(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.seqNo = mapped
    }

    /**
     * @param value Source Port end 0-65535.
     */
    @JvmName("quxyqtrbvxttjhqo")
    public suspend fun srcPortEnd(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.srcPortEnd = mapped
    }

    /**
     * @param value Source port start 0-65535.
     */
    @JvmName("ucmtdmmeuencfqsp")
    public suspend fun srcPortStart(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.srcPortStart = mapped
    }

    internal fun build(): BgpPolicyContentPortRuleListArgs = BgpPolicyContentPortRuleListArgs(
        dstPortEnd = dstPortEnd ?: throw PulumiNullFieldException("dstPortEnd"),
        dstPortStart = dstPortStart ?: throw PulumiNullFieldException("dstPortStart"),
        matchAction = matchAction ?: throw PulumiNullFieldException("matchAction"),
        portRuleId = portRuleId,
        protocol = protocol ?: throw PulumiNullFieldException("protocol"),
        seqNo = seqNo ?: throw PulumiNullFieldException("seqNo"),
        srcPortEnd = srcPortEnd ?: throw PulumiNullFieldException("srcPortEnd"),
        srcPortStart = srcPortStart ?: throw PulumiNullFieldException("srcPortStart"),
    )
}
