@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ddos.kotlin.inputs

import com.pulumi.alicloud.ddos.inputs.BgpPolicyContentSourceBlockListArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property blockExpireSeconds Statistical cycle range 60-1200.
 * @property everySeconds The time (unit second) for automatically releasing the black after triggering the speed limit is 60~2592000.
 * @property exceedLimitTimes The number of times the speed limit is exceeded in a statistical period ranges from 1 to 1200.
 * @property type Type
 */
public data class BgpPolicyContentSourceBlockListArgs(
    public val blockExpireSeconds: Output<Int>,
    public val everySeconds: Output<Int>,
    public val exceedLimitTimes: Output<Int>,
    public val type: Output<Int>,
) : ConvertibleToJava<com.pulumi.alicloud.ddos.inputs.BgpPolicyContentSourceBlockListArgs> {
    override fun toJava(): com.pulumi.alicloud.ddos.inputs.BgpPolicyContentSourceBlockListArgs =
        com.pulumi.alicloud.ddos.inputs.BgpPolicyContentSourceBlockListArgs.builder()
            .blockExpireSeconds(blockExpireSeconds.applyValue({ args0 -> args0 }))
            .everySeconds(everySeconds.applyValue({ args0 -> args0 }))
            .exceedLimitTimes(exceedLimitTimes.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BgpPolicyContentSourceBlockListArgs].
 */
@PulumiTagMarker
public class BgpPolicyContentSourceBlockListArgsBuilder internal constructor() {
    private var blockExpireSeconds: Output<Int>? = null

    private var everySeconds: Output<Int>? = null

    private var exceedLimitTimes: Output<Int>? = null

    private var type: Output<Int>? = null

    /**
     * @param value Statistical cycle range 60-1200.
     */
    @JvmName("klyvefjxdfpcbsuk")
    public suspend fun blockExpireSeconds(`value`: Output<Int>) {
        this.blockExpireSeconds = value
    }

    /**
     * @param value The time (unit second) for automatically releasing the black after triggering the speed limit is 60~2592000.
     */
    @JvmName("tidfpojkbelrfora")
    public suspend fun everySeconds(`value`: Output<Int>) {
        this.everySeconds = value
    }

    /**
     * @param value The number of times the speed limit is exceeded in a statistical period ranges from 1 to 1200.
     */
    @JvmName("tokkitrusahxlgvb")
    public suspend fun exceedLimitTimes(`value`: Output<Int>) {
        this.exceedLimitTimes = value
    }

    /**
     * @param value Type
     */
    @JvmName("fojywxvqhkcojxdb")
    public suspend fun type(`value`: Output<Int>) {
        this.type = value
    }

    /**
     * @param value Statistical cycle range 60-1200.
     */
    @JvmName("smtbegkjeysqanby")
    public suspend fun blockExpireSeconds(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.blockExpireSeconds = mapped
    }

    /**
     * @param value The time (unit second) for automatically releasing the black after triggering the speed limit is 60~2592000.
     */
    @JvmName("ygcmosiecqgetxfa")
    public suspend fun everySeconds(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.everySeconds = mapped
    }

    /**
     * @param value The number of times the speed limit is exceeded in a statistical period ranges from 1 to 1200.
     */
    @JvmName("nhaaqmjwbfschmut")
    public suspend fun exceedLimitTimes(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.exceedLimitTimes = mapped
    }

    /**
     * @param value Type
     */
    @JvmName("dyuesghlkdijpgck")
    public suspend fun type(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): BgpPolicyContentSourceBlockListArgs = BgpPolicyContentSourceBlockListArgs(
        blockExpireSeconds = blockExpireSeconds ?: throw PulumiNullFieldException("blockExpireSeconds"),
        everySeconds = everySeconds ?: throw PulumiNullFieldException("everySeconds"),
        exceedLimitTimes = exceedLimitTimes ?: throw PulumiNullFieldException("exceedLimitTimes"),
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
