@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ddos.kotlin.inputs

import com.pulumi.alicloud.ddos.inputs.BgpPolicyContentSourceLimitArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property bps bps range 1024~268435456.
 * @property pps Pps range 32~500000.
 * @property synBps SynBps range 1024~268435456.
 * @property synPps SynPps range 1~100000.
 */
public data class BgpPolicyContentSourceLimitArgs(
    public val bps: Output<Int>? = null,
    public val pps: Output<Int>? = null,
    public val synBps: Output<Int>? = null,
    public val synPps: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ddos.inputs.BgpPolicyContentSourceLimitArgs> {
    override fun toJava(): com.pulumi.alicloud.ddos.inputs.BgpPolicyContentSourceLimitArgs =
        com.pulumi.alicloud.ddos.inputs.BgpPolicyContentSourceLimitArgs.builder()
            .bps(bps?.applyValue({ args0 -> args0 }))
            .pps(pps?.applyValue({ args0 -> args0 }))
            .synBps(synBps?.applyValue({ args0 -> args0 }))
            .synPps(synPps?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BgpPolicyContentSourceLimitArgs].
 */
@PulumiTagMarker
public class BgpPolicyContentSourceLimitArgsBuilder internal constructor() {
    private var bps: Output<Int>? = null

    private var pps: Output<Int>? = null

    private var synBps: Output<Int>? = null

    private var synPps: Output<Int>? = null

    /**
     * @param value bps range 1024~268435456.
     */
    @JvmName("kkubuyxrbvmocwgn")
    public suspend fun bps(`value`: Output<Int>) {
        this.bps = value
    }

    /**
     * @param value Pps range 32~500000.
     */
    @JvmName("ewmgtxqumxhhcpnw")
    public suspend fun pps(`value`: Output<Int>) {
        this.pps = value
    }

    /**
     * @param value SynBps range 1024~268435456.
     */
    @JvmName("kvsoejbrainhccjs")
    public suspend fun synBps(`value`: Output<Int>) {
        this.synBps = value
    }

    /**
     * @param value SynPps range 1~100000.
     */
    @JvmName("ngngufwpuqvhsrja")
    public suspend fun synPps(`value`: Output<Int>) {
        this.synPps = value
    }

    /**
     * @param value bps range 1024~268435456.
     */
    @JvmName("frydhajrbnddqoho")
    public suspend fun bps(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bps = mapped
    }

    /**
     * @param value Pps range 32~500000.
     */
    @JvmName("hsrditbwdvtpxvsh")
    public suspend fun pps(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pps = mapped
    }

    /**
     * @param value SynBps range 1024~268435456.
     */
    @JvmName("ucodxpslwolptcse")
    public suspend fun synBps(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.synBps = mapped
    }

    /**
     * @param value SynPps range 1~100000.
     */
    @JvmName("yafbndkieupubbte")
    public suspend fun synPps(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.synPps = mapped
    }

    internal fun build(): BgpPolicyContentSourceLimitArgs = BgpPolicyContentSourceLimitArgs(
        bps = bps,
        pps = pps,
        synBps = synBps,
        synPps = synPps,
    )
}
