@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ddos.kotlin.inputs

import com.pulumi.alicloud.ddos.inputs.DomainResourceProxyTypeArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property proxyPorts the port number. This field is required and must be an integer. **NOTE:** From version 1.206.0, `proxy_ports` can be modified.
 * @property proxyType the protocol type. This field is required and must be a string. Valid values: `http`, `https`, `websocket`, and `websockets`.
 */
public data class DomainResourceProxyTypeArgs(
    public val proxyPorts: Output<List<Int>>? = null,
    public val proxyType: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ddos.inputs.DomainResourceProxyTypeArgs> {
    override fun toJava(): com.pulumi.alicloud.ddos.inputs.DomainResourceProxyTypeArgs =
        com.pulumi.alicloud.ddos.inputs.DomainResourceProxyTypeArgs.builder()
            .proxyPorts(proxyPorts?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .proxyType(proxyType?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DomainResourceProxyTypeArgs].
 */
@PulumiTagMarker
public class DomainResourceProxyTypeArgsBuilder internal constructor() {
    private var proxyPorts: Output<List<Int>>? = null

    private var proxyType: Output<String>? = null

    /**
     * @param value the port number. This field is required and must be an integer. **NOTE:** From version 1.206.0, `proxy_ports` can be modified.
     */
    @JvmName("itjkvvbqfrchglep")
    public suspend fun proxyPorts(`value`: Output<List<Int>>) {
        this.proxyPorts = value
    }

    @JvmName("mckhthdnmwtidqrn")
    public suspend fun proxyPorts(vararg values: Output<Int>) {
        this.proxyPorts = Output.all(values.asList())
    }

    /**
     * @param values the port number. This field is required and must be an integer. **NOTE:** From version 1.206.0, `proxy_ports` can be modified.
     */
    @JvmName("whtukbbaltoiaovf")
    public suspend fun proxyPorts(values: List<Output<Int>>) {
        this.proxyPorts = Output.all(values)
    }

    /**
     * @param value the protocol type. This field is required and must be a string. Valid values: `http`, `https`, `websocket`, and `websockets`.
     */
    @JvmName("wmxbijqdxtkteajp")
    public suspend fun proxyType(`value`: Output<String>) {
        this.proxyType = value
    }

    /**
     * @param value the port number. This field is required and must be an integer. **NOTE:** From version 1.206.0, `proxy_ports` can be modified.
     */
    @JvmName("vlrfwctckmkbyiyn")
    public suspend fun proxyPorts(`value`: List<Int>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.proxyPorts = mapped
    }

    /**
     * @param values the port number. This field is required and must be an integer. **NOTE:** From version 1.206.0, `proxy_ports` can be modified.
     */
    @JvmName("xhnqffbvlsmlnnwx")
    public suspend fun proxyPorts(vararg values: Int) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.proxyPorts = mapped
    }

    /**
     * @param value the protocol type. This field is required and must be a string. Valid values: `http`, `https`, `websocket`, and `websockets`.
     */
    @JvmName("xudbqfmummoqdpab")
    public suspend fun proxyType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.proxyType = mapped
    }

    internal fun build(): DomainResourceProxyTypeArgs = DomainResourceProxyTypeArgs(
        proxyPorts = proxyPorts,
        proxyType = proxyType,
    )
}
