@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ddos.kotlin.inputs

import com.pulumi.alicloud.ddos.inputs.GetDdosBgpIpsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getDdosBgpIps.
 * @property ids A list of Ip IDs.
 * @property instanceId The ID of the native protection enterprise instance to be operated.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property pageNumber
 * @property pageSize
 * @property productName The product name. Valid Value:`ECS`, `SLB`, `EIP`, `WAF`.
 * @property status The current state of the IP address. Valid Value:
 * - normal: indicates normal (not attacked).
 * - hole_begin: indicates that you are in a black hole state.
 */
public data class GetDdosBgpIpsPlainArgs(
    public val ids: List<String>? = null,
    public val instanceId: String,
    public val outputFile: String? = null,
    public val pageNumber: Int? = null,
    public val pageSize: Int? = null,
    public val productName: String? = null,
    public val status: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ddos.inputs.GetDdosBgpIpsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.ddos.inputs.GetDdosBgpIpsPlainArgs =
        com.pulumi.alicloud.ddos.inputs.GetDdosBgpIpsPlainArgs.builder()
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .instanceId(instanceId.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .pageNumber(pageNumber?.let({ args0 -> args0 }))
            .pageSize(pageSize?.let({ args0 -> args0 }))
            .productName(productName?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetDdosBgpIpsPlainArgs].
 */
@PulumiTagMarker
public class GetDdosBgpIpsPlainArgsBuilder internal constructor() {
    private var ids: List<String>? = null

    private var instanceId: String? = null

    private var outputFile: String? = null

    private var pageNumber: Int? = null

    private var pageSize: Int? = null

    private var productName: String? = null

    private var status: String? = null

    /**
     * @param value A list of Ip IDs.
     */
    @JvmName("ekyidgwbwytovmec")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Ip IDs.
     */
    @JvmName("iaveabgkpmrcidxi")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value The ID of the native protection enterprise instance to be operated.
     */
    @JvmName("qypmtwglpvwobosv")
    public suspend fun instanceId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.instanceId = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("htihdewmgsodielg")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value
     */
    @JvmName("wgdrkmstdjsowrsa")
    public suspend fun pageNumber(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.pageNumber = mapped
    }

    /**
     * @param value
     */
    @JvmName("inwdwmjracgvqesw")
    public suspend fun pageSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.pageSize = mapped
    }

    /**
     * @param value The product name. Valid Value:`ECS`, `SLB`, `EIP`, `WAF`.
     */
    @JvmName("sofnbepynoqbuaio")
    public suspend fun productName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.productName = mapped
    }

    /**
     * @param value The current state of the IP address. Valid Value:
     * - normal: indicates normal (not attacked).
     * - hole_begin: indicates that you are in a black hole state.
     */
    @JvmName("lttqbptuplihvvdk")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    internal fun build(): GetDdosBgpIpsPlainArgs = GetDdosBgpIpsPlainArgs(
        ids = ids,
        instanceId = instanceId ?: throw PulumiNullFieldException("instanceId"),
        outputFile = outputFile,
        pageNumber = pageNumber,
        pageSize = pageSize,
        productName = productName,
        status = status,
    )
}
