@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ddos.kotlin.inputs

import com.pulumi.alicloud.ddos.inputs.GetDdosCooDomainResourcesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getDdosCooDomainResources.
 * @property ids A list of Domain Resource IDs.
 * @property instanceIds A ID list of Ddoscoo instance.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property queryDomainPattern Match the pattern.
 */
public data class GetDdosCooDomainResourcesPlainArgs(
    public val ids: List<String>? = null,
    public val instanceIds: List<String>? = null,
    public val outputFile: String? = null,
    public val queryDomainPattern: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ddos.inputs.GetDdosCooDomainResourcesPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.ddos.inputs.GetDdosCooDomainResourcesPlainArgs =
        com.pulumi.alicloud.ddos.inputs.GetDdosCooDomainResourcesPlainArgs.builder()
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .instanceIds(instanceIds?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .queryDomainPattern(queryDomainPattern?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetDdosCooDomainResourcesPlainArgs].
 */
@PulumiTagMarker
public class GetDdosCooDomainResourcesPlainArgsBuilder internal constructor() {
    private var ids: List<String>? = null

    private var instanceIds: List<String>? = null

    private var outputFile: String? = null

    private var queryDomainPattern: String? = null

    /**
     * @param value A list of Domain Resource IDs.
     */
    @JvmName("gxcwxwytfptnxbjg")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Domain Resource IDs.
     */
    @JvmName("ctadtwqkuiqghltg")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value A ID list of Ddoscoo instance.
     */
    @JvmName("rgwwejquofdmssrw")
    public suspend fun instanceIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.instanceIds = mapped
    }

    /**
     * @param values A ID list of Ddoscoo instance.
     */
    @JvmName("jbwkjbqdbbgeofqu")
    public suspend fun instanceIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.instanceIds = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("jliacltkhrxdllvd")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value Match the pattern.
     */
    @JvmName("pbkwtfsjuilayfoa")
    public suspend fun queryDomainPattern(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.queryDomainPattern = mapped
    }

    internal fun build(): GetDdosCooDomainResourcesPlainArgs = GetDdosCooDomainResourcesPlainArgs(
        ids = ids,
        instanceIds = instanceIds,
        outputFile = outputFile,
        queryDomainPattern = queryDomainPattern,
    )
}
