@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ddos.kotlin.inputs

import com.pulumi.alicloud.ddos.inputs.GetDdosCooPortsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getDdosCooPorts.
 * @property frontendPort The forwarding port.
 * @property frontendProtocol The forwarding protocol. Valid values `tcp` and `udp`.
 * @property ids A list of Port IDs.
 * @property instanceId The Ddoscoo instance ID.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 */
public data class GetDdosCooPortsPlainArgs(
    public val frontendPort: String? = null,
    public val frontendProtocol: String? = null,
    public val ids: List<String>? = null,
    public val instanceId: String,
    public val outputFile: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ddos.inputs.GetDdosCooPortsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.ddos.inputs.GetDdosCooPortsPlainArgs =
        com.pulumi.alicloud.ddos.inputs.GetDdosCooPortsPlainArgs.builder()
            .frontendPort(frontendPort?.let({ args0 -> args0 }))
            .frontendProtocol(frontendProtocol?.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .instanceId(instanceId.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetDdosCooPortsPlainArgs].
 */
@PulumiTagMarker
public class GetDdosCooPortsPlainArgsBuilder internal constructor() {
    private var frontendPort: String? = null

    private var frontendProtocol: String? = null

    private var ids: List<String>? = null

    private var instanceId: String? = null

    private var outputFile: String? = null

    /**
     * @param value The forwarding port.
     */
    @JvmName("futdpfbchdjppdbl")
    public suspend fun frontendPort(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.frontendPort = mapped
    }

    /**
     * @param value The forwarding protocol. Valid values `tcp` and `udp`.
     */
    @JvmName("nkiugqrnlurdhtww")
    public suspend fun frontendProtocol(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.frontendProtocol = mapped
    }

    /**
     * @param value A list of Port IDs.
     */
    @JvmName("iixeadajkyaadsgo")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Port IDs.
     */
    @JvmName("wkdomggmhnxqdhan")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value The Ddoscoo instance ID.
     */
    @JvmName("hanlwioeyualsrrx")
    public suspend fun instanceId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.instanceId = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("cjsblahkrftqenhk")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    internal fun build(): GetDdosCooPortsPlainArgs = GetDdosCooPortsPlainArgs(
        frontendPort = frontendPort,
        frontendProtocol = frontendProtocol,
        ids = ids,
        instanceId = instanceId ?: throw PulumiNullFieldException("instanceId"),
        outputFile = outputFile,
    )
}
