@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ddos.kotlin.inputs

import com.pulumi.alicloud.ddos.inputs.SchedulerRuleRuleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property priority The priority of the rule.
 * @property regionId The region where the interaction resource that is used in the scheduling rule is deployed. **NOTE:** This parameter is returned only if the RuleType parameter is set to 2.
 * @property status The status of the scheduling rule.
 * @property type The address type of the interaction resource. Valid values:
 * `A`: IPv4 address.
 * `CNAME`: CNAME record.
 * @property value The address of the interaction resource.
 * @property valueType Required. The type of the linked resource. It is an Integer. Valid values:
 * `1`: The IP address of Anti-DDoS Pro or Anti-DDoS Premium
 * `2`: the IP address of the interaction resource (in the tiered protection scenario)
 * `3`: the IP address used to accelerate access (in the network acceleration scenario)
 * `6` the IP address of the interaction resource (in the cloud service interaction scenario)
 */
public data class SchedulerRuleRuleArgs(
    public val priority: Output<Int>? = null,
    public val regionId: Output<String>? = null,
    public val status: Output<Int>? = null,
    public val type: Output<String>? = null,
    public val `value`: Output<String>? = null,
    public val valueType: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ddos.inputs.SchedulerRuleRuleArgs> {
    override fun toJava(): com.pulumi.alicloud.ddos.inputs.SchedulerRuleRuleArgs =
        com.pulumi.alicloud.ddos.inputs.SchedulerRuleRuleArgs.builder()
            .priority(priority?.applyValue({ args0 -> args0 }))
            .regionId(regionId?.applyValue({ args0 -> args0 }))
            .status(status?.applyValue({ args0 -> args0 }))
            .type(type?.applyValue({ args0 -> args0 }))
            .`value`(`value`?.applyValue({ args0 -> args0 }))
            .valueType(valueType?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SchedulerRuleRuleArgs].
 */
@PulumiTagMarker
public class SchedulerRuleRuleArgsBuilder internal constructor() {
    private var priority: Output<Int>? = null

    private var regionId: Output<String>? = null

    private var status: Output<Int>? = null

    private var type: Output<String>? = null

    private var `value`: Output<String>? = null

    private var valueType: Output<Int>? = null

    /**
     * @param value The priority of the rule.
     */
    @JvmName("tjublugydwwuarib")
    public suspend fun priority(`value`: Output<Int>) {
        this.priority = value
    }

    /**
     * @param value The region where the interaction resource that is used in the scheduling rule is deployed. **NOTE:** This parameter is returned only if the RuleType parameter is set to 2.
     */
    @JvmName("ucevodijarketmxc")
    public suspend fun regionId(`value`: Output<String>) {
        this.regionId = value
    }

    /**
     * @param value The status of the scheduling rule.
     */
    @JvmName("xmfulfwanawequgh")
    public suspend fun status(`value`: Output<Int>) {
        this.status = value
    }

    /**
     * @param value The address type of the interaction resource. Valid values:
     * `A`: IPv4 address.
     * `CNAME`: CNAME record.
     */
    @JvmName("xxtvwjilntaxejbe")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The address of the interaction resource.
     */
    @JvmName("yvobxjyeefasylkx")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value Required. The type of the linked resource. It is an Integer. Valid values:
     * `1`: The IP address of Anti-DDoS Pro or Anti-DDoS Premium
     * `2`: the IP address of the interaction resource (in the tiered protection scenario)
     * `3`: the IP address used to accelerate access (in the network acceleration scenario)
     * `6` the IP address of the interaction resource (in the cloud service interaction scenario)
     */
    @JvmName("odgafjiioamaqgjg")
    public suspend fun valueType(`value`: Output<Int>) {
        this.valueType = value
    }

    /**
     * @param value The priority of the rule.
     */
    @JvmName("posfnimkanrbqgec")
    public suspend fun priority(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.priority = mapped
    }

    /**
     * @param value The region where the interaction resource that is used in the scheduling rule is deployed. **NOTE:** This parameter is returned only if the RuleType parameter is set to 2.
     */
    @JvmName("uopypxmeeypaydiq")
    public suspend fun regionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.regionId = mapped
    }

    /**
     * @param value The status of the scheduling rule.
     */
    @JvmName("qogaidmmjdgdtjil")
    public suspend fun status(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value The address type of the interaction resource. Valid values:
     * `A`: IPv4 address.
     * `CNAME`: CNAME record.
     */
    @JvmName("vgmfbpshydijblkf")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The address of the interaction resource.
     */
    @JvmName("sfqwpmlnebdovnyf")
    public suspend fun `value`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    /**
     * @param value Required. The type of the linked resource. It is an Integer. Valid values:
     * `1`: The IP address of Anti-DDoS Pro or Anti-DDoS Premium
     * `2`: the IP address of the interaction resource (in the tiered protection scenario)
     * `3`: the IP address used to accelerate access (in the network acceleration scenario)
     * `6` the IP address of the interaction resource (in the cloud service interaction scenario)
     */
    @JvmName("elrqdvoqfufisyej")
    public suspend fun valueType(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.valueType = mapped
    }

    internal fun build(): SchedulerRuleRuleArgs = SchedulerRuleRuleArgs(
        priority = priority,
        regionId = regionId,
        status = status,
        type = type,
        `value` = `value`,
        valueType = valueType,
    )
}
