@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ddos.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property blackIpListExpireAt Blacklist and whitelist timeout.
 * @property enableDefense Whether to enable L4 protection.
 * @property enableDropIcmp Switch to discard ICMP.
 * @property enableIntelligence Whether the intelligent switch is on.
 * @property fingerPrintRuleLists Fingerprint Rules. See `finger_print_rule_list` below.
 * @property intelligenceLevel Smart mode. Valid values: weak, hard, and default.
 * @property layer4RuleLists L4 protection rules. See `layer4_rule_list` below.
 * @property portRuleLists Port Rule List. See `port_rule_list` below.
 * @property reflectBlockUdpPortLists Reflective port filtering.
 * @property regionBlockCountryLists List of Regional Banned Countries.
 * @property regionBlockProvinceLists List of Prohibited Provinces by Region.
 * @property sourceBlockLists Source pull Black. See `source_block_list` below.
 * @property sourceLimit Do not fill in when the source speed limit is deleted. See `source_limit` below.
 * @property whitenGfbrNets Add white high protection back to source network segment switch.
 */
public data class BgpPolicyContent(
    public val blackIpListExpireAt: Int? = null,
    public val enableDefense: Boolean? = null,
    public val enableDropIcmp: Boolean? = null,
    public val enableIntelligence: Boolean? = null,
    public val fingerPrintRuleLists: List<BgpPolicyContentFingerPrintRuleList>? = null,
    public val intelligenceLevel: String? = null,
    public val layer4RuleLists: List<BgpPolicyContentLayer4RuleList>? = null,
    public val portRuleLists: List<BgpPolicyContentPortRuleList>? = null,
    public val reflectBlockUdpPortLists: List<Int>? = null,
    public val regionBlockCountryLists: List<Int>? = null,
    public val regionBlockProvinceLists: List<Int>? = null,
    public val sourceBlockLists: List<BgpPolicyContentSourceBlockList>? = null,
    public val sourceLimit: BgpPolicyContentSourceLimit? = null,
    public val whitenGfbrNets: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ddos.outputs.BgpPolicyContent): BgpPolicyContent = BgpPolicyContent(
            blackIpListExpireAt = javaType.blackIpListExpireAt().map({ args0 -> args0 }).orElse(null),
            enableDefense = javaType.enableDefense().map({ args0 -> args0 }).orElse(null),
            enableDropIcmp = javaType.enableDropIcmp().map({ args0 -> args0 }).orElse(null),
            enableIntelligence = javaType.enableIntelligence().map({ args0 -> args0 }).orElse(null),
            fingerPrintRuleLists = javaType.fingerPrintRuleLists().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.ddos.kotlin.outputs.BgpPolicyContentFingerPrintRuleList.Companion.toKotlin(args0)
                })
            }),
            intelligenceLevel = javaType.intelligenceLevel().map({ args0 -> args0 }).orElse(null),
            layer4RuleLists = javaType.layer4RuleLists().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.ddos.kotlin.outputs.BgpPolicyContentLayer4RuleList.Companion.toKotlin(args0)
                })
            }),
            portRuleLists = javaType.portRuleLists().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.ddos.kotlin.outputs.BgpPolicyContentPortRuleList.Companion.toKotlin(args0)
                })
            }),
            reflectBlockUdpPortLists = javaType.reflectBlockUdpPortLists().map({ args0 -> args0 }),
            regionBlockCountryLists = javaType.regionBlockCountryLists().map({ args0 -> args0 }),
            regionBlockProvinceLists = javaType.regionBlockProvinceLists().map({ args0 -> args0 }),
            sourceBlockLists = javaType.sourceBlockLists().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.ddos.kotlin.outputs.BgpPolicyContentSourceBlockList.Companion.toKotlin(args0)
                })
            }),
            sourceLimit = javaType.sourceLimit().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.ddos.kotlin.outputs.BgpPolicyContentSourceLimit.Companion.toKotlin(args0)
                })
            }).orElse(null),
            whitenGfbrNets = javaType.whitenGfbrNets().map({ args0 -> args0 }).orElse(null),
        )
    }
}
