@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ddos.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property dstPortEnd End of destination port 0-65535.
 * @property dstPortStart Destination Port start 0-65535.
 * @property fingerPrintRuleId The UUID of the rule is required to be deleted and modified, and it is not required to be created.
 * @property matchAction Action. Currently, only drop is supported.
 * @property maxPktLen Maximum bag length.
 * @property minPktLen Minimum package length.
 * @property offset Offset.
 * @property payloadBytes Load match, hexadecimal string; Similar to 'abcd'.
 * @property protocol Protocol, tcp or udp.
 * @property rateValue Speed limit value 1-100000.
 * @property seqNo Serial number 1-100 ● Affects the order issued by the bottom layer ● The larger the number, the lower it is.
 * @property srcPortEnd Source Port end 0-65535.
 * @property srcPortStart Source port start 0-65535.
 */
public data class BgpPolicyContentFingerPrintRuleList(
    public val dstPortEnd: Int,
    public val dstPortStart: Int,
    public val fingerPrintRuleId: String? = null,
    public val matchAction: String,
    public val maxPktLen: Int,
    public val minPktLen: Int,
    public val offset: Int? = null,
    public val payloadBytes: String? = null,
    public val protocol: String,
    public val rateValue: Int? = null,
    public val seqNo: Int,
    public val srcPortEnd: Int,
    public val srcPortStart: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ddos.outputs.BgpPolicyContentFingerPrintRuleList): BgpPolicyContentFingerPrintRuleList = BgpPolicyContentFingerPrintRuleList(
            dstPortEnd = javaType.dstPortEnd(),
            dstPortStart = javaType.dstPortStart(),
            fingerPrintRuleId = javaType.fingerPrintRuleId().map({ args0 -> args0 }).orElse(null),
            matchAction = javaType.matchAction(),
            maxPktLen = javaType.maxPktLen(),
            minPktLen = javaType.minPktLen(),
            offset = javaType.offset().map({ args0 -> args0 }).orElse(null),
            payloadBytes = javaType.payloadBytes().map({ args0 -> args0 }).orElse(null),
            protocol = javaType.protocol(),
            rateValue = javaType.rateValue().map({ args0 -> args0 }).orElse(null),
            seqNo = javaType.seqNo(),
            srcPortEnd = javaType.srcPortEnd(),
            srcPortStart = javaType.srcPortStart(),
        )
    }
}
