@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ddos.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property action 1 for observation 2 for blocking.
 * @property conditionLists Matching Condition. See `condition_list` below.
 * @property limited .
 * @property match 0 indicates that the condition is not met 1 indicates that the condition is met.
 * @property method Char indicates a string match hex match.
 * @property name Rule Name.
 * @property priority 1-100, priority, the lower the number, the higher the priority.
 */
public data class BgpPolicyContentLayer4RuleList(
    public val action: String,
    public val conditionLists: List<BgpPolicyContentLayer4RuleListConditionList>,
    public val limited: Int,
    public val match: String,
    public val method: String,
    public val name: String,
    public val priority: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ddos.outputs.BgpPolicyContentLayer4RuleList): BgpPolicyContentLayer4RuleList = BgpPolicyContentLayer4RuleList(
            action = javaType.action(),
            conditionLists = javaType.conditionLists().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.ddos.kotlin.outputs.BgpPolicyContentLayer4RuleListConditionList.Companion.toKotlin(args0)
                })
            }),
            limited = javaType.limited(),
            match = javaType.match(),
            method = javaType.method(),
            name = javaType.name(),
            priority = javaType.priority(),
        )
    }
}
