@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ddos.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property dstPortEnd End of destination port 0-65535.
 * @property dstPortStart Destination Port start 0-65535.
 * @property matchAction Action. Currently, only drop is supported.
 * @property portRuleId Rule UUID is required to be deleted and modified, and is not required to be created.
 * @property protocol Protocol, tcp or udp.
 * @property seqNo Serial number 1-100 ● Affects the order issued by the bottom layer ● The larger the number, the lower it is.
 * @property srcPortEnd Source Port end 0-65535.
 * @property srcPortStart Source port start 0-65535.
 */
public data class BgpPolicyContentPortRuleList(
    public val dstPortEnd: Int,
    public val dstPortStart: Int,
    public val matchAction: String,
    public val portRuleId: String? = null,
    public val protocol: String,
    public val seqNo: Int,
    public val srcPortEnd: Int,
    public val srcPortStart: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ddos.outputs.BgpPolicyContentPortRuleList): BgpPolicyContentPortRuleList = BgpPolicyContentPortRuleList(
            dstPortEnd = javaType.dstPortEnd(),
            dstPortStart = javaType.dstPortStart(),
            matchAction = javaType.matchAction(),
            portRuleId = javaType.portRuleId().map({ args0 -> args0 }).orElse(null),
            protocol = javaType.protocol(),
            seqNo = javaType.seqNo(),
            srcPortEnd = javaType.srcPortEnd(),
            srcPortStart = javaType.srcPortStart(),
        )
    }
}
