@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ddos.kotlin.outputs

import kotlin.Int
import kotlin.Suppress

/**
 *
 * @property blockExpireSeconds Statistical cycle range 60-1200.
 * @property everySeconds The time (unit second) for automatically releasing the black after triggering the speed limit is 60~2592000.
 * @property exceedLimitTimes The number of times the speed limit is exceeded in a statistical period ranges from 1 to 1200.
 * @property type Type
 */
public data class BgpPolicyContentSourceBlockList(
    public val blockExpireSeconds: Int,
    public val everySeconds: Int,
    public val exceedLimitTimes: Int,
    public val type: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ddos.outputs.BgpPolicyContentSourceBlockList): BgpPolicyContentSourceBlockList = BgpPolicyContentSourceBlockList(
            blockExpireSeconds = javaType.blockExpireSeconds(),
            everySeconds = javaType.everySeconds(),
            exceedLimitTimes = javaType.exceedLimitTimes(),
            type = javaType.type(),
        )
    }
}
