@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ddos.kotlin.outputs

import kotlin.Int
import kotlin.Suppress

/**
 *
 * @property bps bps range 1024~268435456.
 * @property pps Pps range 32~500000.
 * @property synBps SynBps range 1024~268435456.
 * @property synPps SynPps range 1~100000.
 */
public data class BgpPolicyContentSourceLimit(
    public val bps: Int? = null,
    public val pps: Int? = null,
    public val synBps: Int? = null,
    public val synPps: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ddos.outputs.BgpPolicyContentSourceLimit): BgpPolicyContentSourceLimit = BgpPolicyContentSourceLimit(
            bps = javaType.bps().map({ args0 -> args0 }).orElse(null),
            pps = javaType.pps().map({ args0 -> args0 }).orElse(null),
            synBps = javaType.synBps().map({ args0 -> args0 }).orElse(null),
            synPps = javaType.synPps().map({ args0 -> args0 }).orElse(null),
        )
    }
}
