@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ddos.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property proxyPorts the port number. This field is required and must be an integer. **NOTE:** From version 1.206.0, `proxy_ports` can be modified.
 * @property proxyType the protocol type. This field is required and must be a string. Valid values: `http`, `https`, `websocket`, and `websockets`.
 */
public data class DomainResourceProxyType(
    public val proxyPorts: List<Int>? = null,
    public val proxyType: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ddos.outputs.DomainResourceProxyType): DomainResourceProxyType = DomainResourceProxyType(
            proxyPorts = javaType.proxyPorts().map({ args0 -> args0 }),
            proxyType = javaType.proxyType().map({ args0 -> args0 }).orElse(null),
        )
    }
}
