@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ddos.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property bandwidth The instance's elastic defend bandwidth.
 * @property baseBandwidth The instance's base defend bandwidth.
 * @property id The instance's id.
 * @property ipCount The instance's count of ip config.
 * @property ipType The instance's IP version.
 * @property name The instance's remark.
 * @property normalBandwidth Normal defend bandwidth of the instance. The unit is Gbps.
 * @property region The instance's region.
 * @property type The instance's type.
 */
public data class GetDdosBgpInstancesInstance(
    public val bandwidth: Int,
    public val baseBandwidth: Int,
    public val id: String,
    public val ipCount: Int,
    public val ipType: String,
    public val name: String,
    public val normalBandwidth: Int,
    public val region: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ddos.outputs.GetDdosBgpInstancesInstance): GetDdosBgpInstancesInstance = GetDdosBgpInstancesInstance(
            bandwidth = javaType.bandwidth(),
            baseBandwidth = javaType.baseBandwidth(),
            id = javaType.id(),
            ipCount = javaType.ipCount(),
            ipType = javaType.ipType(),
            name = javaType.name(),
            normalBandwidth = javaType.normalBandwidth(),
            region = javaType.region(),
            type = javaType.type(),
        )
    }
}
